/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.xmp.impl;

import com.itextpdf.xmp.XMPConst;
import com.itextpdf.xmp.XMPDateTime;
import com.itextpdf.xmp.XMPDateTimeFactory;
import com.itextpdf.xmp.XMPException;
import com.itextpdf.xmp.XMPMetaFactory;
import com.itextpdf.xmp.XMPUtils;
import com.itextpdf.xmp.impl.Utils;
import com.itextpdf.xmp.impl.XMPNode;
import com.itextpdf.xmp.impl.xpath.XMPPath;
import com.itextpdf.xmp.impl.xpath.XMPPathSegment;
import com.itextpdf.xmp.options.PropertyOptions;
import java.util.GregorianCalendar;
import java.util.Iterator;

public class XMPNodeUtils
implements XMPConst {
    static final int CLT_NO_VALUES = 0;
    static final int CLT_SPECIFIC_MATCH = 1;
    static final int CLT_SINGLE_GENERIC = 2;
    static final int CLT_MULTIPLE_GENERIC = 3;
    static final int CLT_XDEFAULT = 4;
    static final int CLT_FIRST_ITEM = 5;

    private XMPNodeUtils() {
    }

    static XMPNode findSchemaNode(XMPNode tree, String namespaceURI, boolean createNodes) throws XMPException {
        return XMPNodeUtils.findSchemaNode(tree, namespaceURI, null, createNodes);
    }

    static XMPNode findSchemaNode(XMPNode tree, String namespaceURI, String suggestedPrefix, boolean createNodes) throws XMPException {
        assert (tree.getParent() == null);
        XMPNode schemaNode = tree.findChildByName(namespaceURI);
        if (schemaNode == null && createNodes) {
            schemaNode = new XMPNode(namespaceURI, new PropertyOptions().setSchemaNode(true));
            schemaNode.setImplicit(true);
            String prefix = XMPMetaFactory.getSchemaRegistry().getNamespacePrefix(namespaceURI);
            if (prefix == null) {
                if (suggestedPrefix != null && suggestedPrefix.length() != 0) {
                    prefix = XMPMetaFactory.getSchemaRegistry().registerNamespace(namespaceURI, suggestedPrefix);
                } else {
                    throw new XMPException("Unregistered schema namespace URI", 101);
                }
            }
            schemaNode.setValue(prefix);
            tree.addChild(schemaNode);
        }
        return schemaNode;
    }

    static XMPNode findChildNode(XMPNode parent, String childName, boolean createNodes) throws XMPException {
        XMPNode childNode;
        if (!parent.getOptions().isSchemaNode() && !parent.getOptions().isStruct()) {
            if (!parent.isImplicit()) {
                throw new XMPException("Named children only allowed for schemas and structs", 102);
            }
            if (parent.getOptions().isArray()) {
                throw new XMPException("Named children not allowed for arrays", 102);
            }
            if (createNodes) {
                parent.getOptions().setStruct(true);
            }
        }
        if ((childNode = parent.findChildByName(childName)) == null && createNodes) {
            PropertyOptions options = new PropertyOptions();
            childNode = new XMPNode(childName, options);
            childNode.setImplicit(true);
            parent.addChild(childNode);
        }
        assert (childNode != null || !createNodes);
        return childNode;
    }

    static XMPNode findNode(XMPNode xmpTree, XMPPath xpath, boolean createNodes, PropertyOptions leafOptions) throws XMPException {
        if (xpath == null || xpath.size() == 0) {
            throw new XMPException("Empty XMPPath", 102);
        }
        XMPNode rootImplicitNode = null;
        XMPNode currNode = null;
        currNode = XMPNodeUtils.findSchemaNode(xmpTree, xpath.getSegment(0).getName(), createNodes);
        if (currNode == null) {
            return null;
        }
        if (currNode.isImplicit()) {
            currNode.setImplicit(false);
            rootImplicitNode = currNode;
        }
        try {
            for (int i2 = 1; i2 < xpath.size(); ++i2) {
                if ((currNode = XMPNodeUtils.followXPathStep(currNode, xpath.getSegment(i2), createNodes)) == null) {
                    if (createNodes) {
                        XMPNodeUtils.deleteNode(rootImplicitNode);
                    }
                    return null;
                }
                if (!currNode.isImplicit()) continue;
                currNode.setImplicit(false);
                if (i2 == 1 && xpath.getSegment(i2).isAlias() && xpath.getSegment(i2).getAliasForm() != 0) {
                    currNode.getOptions().setOption(xpath.getSegment(i2).getAliasForm(), true);
                } else if (i2 < xpath.size() - 1 && xpath.getSegment(i2).getKind() == 1 && !currNode.getOptions().isCompositeProperty()) {
                    currNode.getOptions().setStruct(true);
                }
                if (rootImplicitNode != null) continue;
                rootImplicitNode = currNode;
            }
        }
        catch (XMPException e2) {
            if (rootImplicitNode != null) {
                XMPNodeUtils.deleteNode(rootImplicitNode);
            }
            throw e2;
        }
        if (rootImplicitNode != null) {
            currNode.getOptions().mergeWith(leafOptions);
            currNode.setOptions(currNode.getOptions());
        }
        return currNode;
    }

    static void deleteNode(XMPNode node) {
        XMPNode parent = node.getParent();
        if (node.getOptions().isQualifier()) {
            parent.removeQualifier(node);
        } else {
            parent.removeChild(node);
        }
        if (!parent.hasChildren() && parent.getOptions().isSchemaNode()) {
            parent.getParent().removeChild(parent);
        }
    }

    static void setNodeValue(XMPNode node, Object value) {
        String strValue = XMPNodeUtils.serializeNodeValue(value);
        if (!node.getOptions().isQualifier() || !"xml:lang".equals(node.getName())) {
            node.setValue(strValue);
        } else {
            node.setValue(Utils.normalizeLangValue(strValue));
        }
    }

    static PropertyOptions verifySetOptions(PropertyOptions options, Object itemValue) throws XMPException {
        if (options == null) {
            options = new PropertyOptions();
        }
        if (options.isArrayAltText()) {
            options.setArrayAlternate(true);
        }
        if (options.isArrayAlternate()) {
            options.setArrayOrdered(true);
        }
        if (options.isArrayOrdered()) {
            options.setArray(true);
        }
        if (options.isCompositeProperty() && itemValue != null && itemValue.toString().length() > 0) {
            throw new XMPException("Structs and arrays can't have values", 103);
        }
        options.assertConsistency(options.getOptions());
        return options;
    }

    static String serializeNodeValue(Object value) {
        String strValue;
        if (value == null) {
            strValue = null;
        } else if (value instanceof Boolean) {
            strValue = XMPUtils.convertFromBoolean((Boolean)value);
        } else if (value instanceof Integer) {
            strValue = XMPUtils.convertFromInteger((Integer)value);
        } else if (value instanceof Long) {
            strValue = XMPUtils.convertFromLong((Long)value);
        } else if (value instanceof Double) {
            strValue = XMPUtils.convertFromDouble((Double)value);
        } else if (value instanceof XMPDateTime) {
            strValue = XMPUtils.convertFromDate((XMPDateTime)value);
        } else if (value instanceof GregorianCalendar) {
            XMPDateTime dt = XMPDateTimeFactory.createFromCalendar((GregorianCalendar)value);
            strValue = XMPUtils.convertFromDate(dt);
        } else {
            strValue = value instanceof byte[] ? XMPUtils.encodeBase64((byte[])value) : value.toString();
        }
        return strValue != null ? Utils.removeControlChars(strValue) : null;
    }

    private static XMPNode followXPathStep(XMPNode parentNode, XMPPathSegment nextStep, boolean createNodes) throws XMPException {
        XMPNode nextNode = null;
        int index = 0;
        int stepKind = nextStep.getKind();
        if (stepKind == 1) {
            nextNode = XMPNodeUtils.findChildNode(parentNode, nextStep.getName(), createNodes);
        } else if (stepKind == 2) {
            nextNode = XMPNodeUtils.findQualifierNode(parentNode, nextStep.getName().substring(1), createNodes);
        } else {
            if (!parentNode.getOptions().isArray()) {
                throw new XMPException("Indexing applied to non-array", 102);
            }
            if (stepKind == 3) {
                index = XMPNodeUtils.findIndexedItem(parentNode, nextStep.getName(), createNodes);
            } else if (stepKind == 4) {
                index = parentNode.getChildrenLength();
            } else if (stepKind == 6) {
                String[] result2 = Utils.splitNameAndValue(nextStep.getName());
                String fieldName = result2[0];
                String fieldValue = result2[1];
                index = XMPNodeUtils.lookupFieldSelector(parentNode, fieldName, fieldValue);
            } else if (stepKind == 5) {
                String[] result3 = Utils.splitNameAndValue(nextStep.getName());
                String qualName = result3[0];
                String qualValue = result3[1];
                index = XMPNodeUtils.lookupQualSelector(parentNode, qualName, qualValue, nextStep.getAliasForm());
            } else {
                throw new XMPException("Unknown array indexing step in FollowXPathStep", 9);
            }
            if (1 <= index && index <= parentNode.getChildrenLength()) {
                nextNode = parentNode.getChild(index);
            }
        }
        return nextNode;
    }

    private static XMPNode findQualifierNode(XMPNode parent, String qualName, boolean createNodes) throws XMPException {
        assert (!qualName.startsWith("?"));
        XMPNode qualNode = parent.findQualifierByName(qualName);
        if (qualNode == null && createNodes) {
            qualNode = new XMPNode(qualName, null);
            qualNode.setImplicit(true);
            parent.addQualifier(qualNode);
        }
        return qualNode;
    }

    private static int findIndexedItem(XMPNode arrayNode, String segment, boolean createNodes) throws XMPException {
        int index = 0;
        try {
            segment = segment.substring(1, segment.length() - 1);
            index = Integer.parseInt(segment);
            if (index < 1) {
                throw new XMPException("Array index must be larger than zero", 102);
            }
        }
        catch (NumberFormatException e2) {
            throw new XMPException("Array index not digits.", 102);
        }
        if (createNodes && index == arrayNode.getChildrenLength() + 1) {
            XMPNode newItem = new XMPNode("[]", null);
            newItem.setImplicit(true);
            arrayNode.addChild(newItem);
        }
        return index;
    }

    private static int lookupFieldSelector(XMPNode arrayNode, String fieldName, String fieldValue) throws XMPException {
        int result2 = -1;
        block0: for (int index = 1; index <= arrayNode.getChildrenLength() && result2 < 0; ++index) {
            XMPNode currItem = arrayNode.getChild(index);
            if (!currItem.getOptions().isStruct()) {
                throw new XMPException("Field selector must be used on array of struct", 102);
            }
            for (int f2 = 1; f2 <= currItem.getChildrenLength(); ++f2) {
                XMPNode currField = currItem.getChild(f2);
                if (!fieldName.equals(currField.getName()) || !fieldValue.equals(currField.getValue())) continue;
                result2 = index;
                continue block0;
            }
        }
        return result2;
    }

    private static int lookupQualSelector(XMPNode arrayNode, String qualName, String qualValue, int aliasForm) throws XMPException {
        if ("xml:lang".equals(qualName)) {
            int index = XMPNodeUtils.lookupLanguageItem(arrayNode, qualValue = Utils.normalizeLangValue(qualValue));
            if (index < 0 && (aliasForm & 0x1000) > 0) {
                XMPNode langNode = new XMPNode("[]", null);
                XMPNode xdefault = new XMPNode("xml:lang", "x-default", null);
                langNode.addQualifier(xdefault);
                arrayNode.addChild(1, langNode);
                return 1;
            }
            return index;
        }
        for (int index = 1; index < arrayNode.getChildrenLength(); ++index) {
            XMPNode currItem = arrayNode.getChild(index);
            Iterator it = currItem.iterateQualifier();
            while (it.hasNext()) {
                XMPNode qualifier = (XMPNode)it.next();
                if (!qualName.equals(qualifier.getName()) || !qualValue.equals(qualifier.getValue())) continue;
                return index;
            }
        }
        return -1;
    }

    static void normalizeLangArray(XMPNode arrayNode) {
        if (!arrayNode.getOptions().isArrayAltText()) {
            return;
        }
        for (int i2 = 2; i2 <= arrayNode.getChildrenLength(); ++i2) {
            XMPNode child;
            block4: {
                child = arrayNode.getChild(i2);
                if (!child.hasQualifier() || !"x-default".equals(child.getQualifier(1).getValue())) continue;
                try {
                    arrayNode.removeChild(i2);
                    arrayNode.addChild(1, child);
                }
                catch (XMPException e2) {
                    if ($assertionsDisabled) break block4;
                    throw new AssertionError();
                }
            }
            if (i2 != 2) break;
            arrayNode.getChild(2).setValue(child.getValue());
            break;
        }
    }

    static void detectAltText(XMPNode arrayNode) {
        if (arrayNode.getOptions().isArrayAlternate() && arrayNode.hasChildren()) {
            boolean isAltText = false;
            Iterator it = arrayNode.iterateChildren();
            while (it.hasNext()) {
                XMPNode child = (XMPNode)it.next();
                if (!child.getOptions().getHasLanguage()) continue;
                isAltText = true;
                break;
            }
            if (isAltText) {
                arrayNode.getOptions().setArrayAltText(true);
                XMPNodeUtils.normalizeLangArray(arrayNode);
            }
        }
    }

    static void appendLangItem(XMPNode arrayNode, String itemLang, String itemValue) throws XMPException {
        XMPNode newItem = new XMPNode("[]", itemValue, null);
        XMPNode langQual = new XMPNode("xml:lang", itemLang, null);
        newItem.addQualifier(langQual);
        if (!"x-default".equals(langQual.getValue())) {
            arrayNode.addChild(newItem);
        } else {
            arrayNode.addChild(1, newItem);
        }
    }

    static Object[] chooseLocalizedText(XMPNode arrayNode, String genericLang, String specificLang) throws XMPException {
        if (!arrayNode.getOptions().isArrayAltText()) {
            throw new XMPException("Localized text array is not alt-text", 102);
        }
        if (!arrayNode.hasChildren()) {
            return new Object[]{new Integer(0), null};
        }
        int foundGenericMatches = 0;
        XMPNode resultNode = null;
        XMPNode xDefault = null;
        Iterator it = arrayNode.iterateChildren();
        while (it.hasNext()) {
            XMPNode currItem = (XMPNode)it.next();
            if (currItem.getOptions().isCompositeProperty()) {
                throw new XMPException("Alt-text array item is not simple", 102);
            }
            if (!currItem.hasQualifier() || !"xml:lang".equals(currItem.getQualifier(1).getName())) {
                throw new XMPException("Alt-text array item has no language qualifier", 102);
            }
            String currLang = currItem.getQualifier(1).getValue();
            if (specificLang.equals(currLang)) {
                return new Object[]{new Integer(1), currItem};
            }
            if (genericLang != null && currLang.startsWith(genericLang)) {
                if (resultNode == null) {
                    resultNode = currItem;
                }
                ++foundGenericMatches;
                continue;
            }
            if (!"x-default".equals(currLang)) continue;
            xDefault = currItem;
        }
        if (foundGenericMatches == 1) {
            return new Object[]{new Integer(2), resultNode};
        }
        if (foundGenericMatches > 1) {
            return new Object[]{new Integer(3), resultNode};
        }
        if (xDefault != null) {
            return new Object[]{new Integer(4), xDefault};
        }
        return new Object[]{new Integer(5), arrayNode.getChild(1)};
    }

    static int lookupLanguageItem(XMPNode arrayNode, String language) throws XMPException {
        if (!arrayNode.getOptions().isArray()) {
            throw new XMPException("Language item must be used on array", 102);
        }
        for (int index = 1; index <= arrayNode.getChildrenLength(); ++index) {
            XMPNode child = arrayNode.getChild(index);
            if (!child.hasQualifier() || !"xml:lang".equals(child.getQualifier(1).getName()) || !language.equals(child.getQualifier(1).getValue())) continue;
            return index;
        }
        return -1;
    }
}

