/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.qrcode;

import com.itextpdf.text.pdf.qrcode.BitArray;

public final class BitMatrix {
    public final int width;
    public final int height;
    public final int rowSize;
    public final int[] bits;

    public BitMatrix(int dimension) {
        this(dimension, dimension);
    }

    public BitMatrix(int width, int height) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("Both dimensions must be greater than 0");
        }
        this.width = width;
        this.height = height;
        int rowSize = width >> 5;
        if ((width & 0x1F) != 0) {
            ++rowSize;
        }
        this.rowSize = rowSize;
        this.bits = new int[rowSize * height];
    }

    public boolean get(int x2, int y2) {
        int offset = y2 * this.rowSize + (x2 >> 5);
        return (this.bits[offset] >>> (x2 & 0x1F) & 1) != 0;
    }

    public void set(int x2, int y2) {
        int offset;
        int n2 = offset = y2 * this.rowSize + (x2 >> 5);
        this.bits[n2] = this.bits[n2] | 1 << (x2 & 0x1F);
    }

    public void flip(int x2, int y2) {
        int offset;
        int n2 = offset = y2 * this.rowSize + (x2 >> 5);
        this.bits[n2] = this.bits[n2] ^ 1 << (x2 & 0x1F);
    }

    public void clear() {
        int max = this.bits.length;
        for (int i2 = 0; i2 < max; ++i2) {
            this.bits[i2] = 0;
        }
    }

    public void setRegion(int left2, int top2, int width, int height) {
        if (top2 < 0 || left2 < 0) {
            throw new IllegalArgumentException("Left and top must be nonnegative");
        }
        if (height < 1 || width < 1) {
            throw new IllegalArgumentException("Height and width must be at least 1");
        }
        int right2 = left2 + width;
        int bottom2 = top2 + height;
        if (bottom2 > this.height || right2 > this.width) {
            throw new IllegalArgumentException("The region must fit inside the matrix");
        }
        for (int y2 = top2; y2 < bottom2; ++y2) {
            int offset = y2 * this.rowSize;
            for (int x2 = left2; x2 < right2; ++x2) {
                int n2 = offset + (x2 >> 5);
                this.bits[n2] = this.bits[n2] | 1 << (x2 & 0x1F);
            }
        }
    }

    public BitArray getRow(int y2, BitArray row2) {
        if (row2 == null || row2.getSize() < this.width) {
            row2 = new BitArray(this.width);
        }
        int offset = y2 * this.rowSize;
        for (int x2 = 0; x2 < this.rowSize; ++x2) {
            row2.setBulk(x2 << 5, this.bits[offset + x2]);
        }
        return row2;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getDimension() {
        if (this.width != this.height) {
            throw new RuntimeException("Can't call getDimension() on a non-square matrix");
        }
        return this.width;
    }

    public String toString() {
        StringBuffer result2 = new StringBuffer(this.height * (this.width + 1));
        for (int y2 = 0; y2 < this.height; ++y2) {
            for (int x2 = 0; x2 < this.width; ++x2) {
                result2.append(this.get(x2, y2) ? "X " : "  ");
            }
            result2.append('\n');
        }
        return result2.toString();
    }
}

