/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.primitives.Shorts;

public class GForceBlock
extends DataBlock {
    private short xInHunderthOfG;
    private short yInHunderthOfG;
    private short zInHunderthOfG;
    private short maxXInHunderthOfG;
    private short maxYInHunderthOfG;
    private short maxZInHunderthOfG;
    private short minZInHunderthOfG;

    public GForceBlock(byte[] rawData) {
        super(rawData);
        this.decode(rawData);
        this.measurementNames.add("X GF");
        this.measurementNames.add("Y GF");
        this.measurementNames.add("Z GF");
        this.measurementNames.add("Xmax GF");
        this.measurementNames.add("Ymax GF");
        this.measurementNames.add("Zmax GF");
        this.measurementNames.add("Zmin GF");
        this.measurementUnits.add("G");
        this.measurementUnits.add("G");
        this.measurementUnits.add("G");
        this.measurementUnits.add("G");
        this.measurementUnits.add("G");
        this.measurementUnits.add("G");
        this.measurementUnits.add("G");
        this.measurementFactors.add(0.01);
        this.measurementFactors.add(0.01);
        this.measurementFactors.add(0.01);
        this.measurementFactors.add(0.01);
        this.measurementFactors.add(0.01);
        this.measurementFactors.add(0.01);
        this.measurementFactors.add(0.01);
    }

    @Override
    public boolean areValuesEquals(DataBlock block) {
        if (block instanceof GForceBlock) {
            GForceBlock gf = (GForceBlock)block;
            return gf.xInHunderthOfG == this.xInHunderthOfG && gf.yInHunderthOfG == this.yInHunderthOfG && gf.zInHunderthOfG == this.zInHunderthOfG && gf.maxXInHunderthOfG == this.maxXInHunderthOfG && gf.maxYInHunderthOfG == this.maxYInHunderthOfG && gf.maxZInHunderthOfG == this.maxZInHunderthOfG && gf.minZInHunderthOfG == this.minZInHunderthOfG;
        }
        return false;
    }

    public short getXInHunderthOfG() {
        return this.xInHunderthOfG;
    }

    public short getYInHunderthOfG() {
        return this.yInHunderthOfG;
    }

    public short getZInHunderthOfG() {
        return this.zInHunderthOfG;
    }

    public short getMaxXInHunderthOfG() {
        return this.maxXInHunderthOfG;
    }

    public short getMaxYInHunderthOfG() {
        return this.maxYInHunderthOfG;
    }

    public short getMaxZInHunderthOfG() {
        return this.maxZInHunderthOfG;
    }

    public short getMinZInHunderthOfG() {
        return this.minZInHunderthOfG;
    }

    private void decode(byte[] rawData) {
        this.xInHunderthOfG = Shorts.fromBytes(rawData[6], rawData[7]);
        this.yInHunderthOfG = Shorts.fromBytes(rawData[8], rawData[9]);
        this.zInHunderthOfG = Shorts.fromBytes(rawData[10], rawData[11]);
        this.maxXInHunderthOfG = Shorts.fromBytes(rawData[12], rawData[13]);
        this.maxYInHunderthOfG = Shorts.fromBytes(rawData[14], rawData[15]);
        this.maxZInHunderthOfG = Shorts.fromBytes(rawData[16], rawData[17]);
        this.minZInHunderthOfG = Shorts.fromBytes(rawData[18], rawData[19]);
        this.measurementValues.add(Integer.valueOf(this.getXInHunderthOfG()));
        this.measurementValues.add(Integer.valueOf(this.getYInHunderthOfG()));
        this.measurementValues.add(Integer.valueOf(this.getZInHunderthOfG()));
        this.measurementValues.add(Integer.valueOf(this.getMaxXInHunderthOfG()));
        this.measurementValues.add(Integer.valueOf(this.getMaxYInHunderthOfG()));
        this.measurementValues.add(Integer.valueOf(this.getMaxZInHunderthOfG()));
        this.measurementValues.add(Integer.valueOf(this.getMinZInHunderthOfG()));
    }
}

