/*
 * Decompiled with CFR 0.152.
 */
package org.usb4java.javax;

import javax.usb.UsbHub;
import javax.usb.UsbPort;
import org.usb4java.javax.AbstractDevice;

final class Port
implements UsbPort {
    private final UsbHub hub;
    private final byte portNumber;
    private AbstractDevice device;

    Port(UsbHub hub, byte portNumber) {
        this.hub = hub;
        this.portNumber = portNumber;
    }

    public byte getPortNumber() {
        return this.portNumber;
    }

    public UsbHub getUsbHub() {
        return this.hub;
    }

    public AbstractDevice getUsbDevice() {
        return this.device;
    }

    public boolean isUsbDeviceAttached() {
        return this.device != null;
    }

    void connectUsbDevice(AbstractDevice device) {
        if (device == null) {
            throw new IllegalArgumentException("device must not be null");
        }
        if (this.device != null) {
            throw new IllegalStateException("Port already has a connected device");
        }
        this.device = device;
        device.setParentUsbPort(this);
    }

    void disconnectUsbDevice() {
        if (this.device == null) {
            throw new IllegalStateException("Port has no connected device");
        }
        AbstractDevice device = this.device;
        this.device = null;
        device.setParentUsbPort(null);
    }
}

