/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nsisant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sf.nsisant.Define;
import net.sf.nsisant.Scriptcmd;
import net.sf.nsisant.Verbosity;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;

public class Task
extends org.apache.tools.ant.Task {
    protected static final String NSIS_CMD_LINE = "makensis";
    protected static final String NSIS_OPT_VERBOSITY = "V";
    protected static final String NSIS_OPT_OUTPUT = "O";
    protected static final String NSIS_OPT_PAUSE = "PAUSE";
    protected static final String NSIS_OPT_NOCONFIG = "NOCONFIG";
    protected static final String NSIS_OPT_NOCD = "NOCD";
    protected static final String NSIS_OPT_DEFINE = "D";
    protected static final String NSIS_OPT_SCRIPTCMD = "X";
    protected File m_fScript;
    protected Integer m_iVerbosity;
    protected File m_fOut;
    protected Boolean m_bPause;
    protected Boolean m_bNoconfig;
    protected Boolean m_bNocd;
    protected String m_sPath;
    protected char m_cPrefix = (char)(System.getProperty("os.name").startsWith("Windows") ? 47 : 45);
    protected List m_lDefines = new ArrayList();
    protected List m_lScriptcmds = new ArrayList();

    public void execute() {
        String string;
        Object object;
        int n;
        if (this.m_fScript == null) {
            throw new BuildException("Attribute 'script' is required", this.getLocation());
        }
        if (this.m_sPath == null) {
            this.m_sPath = "";
        } else if (!new File(this.m_sPath).exists()) {
            throw new BuildException("Specified path does not exist: " + this.m_sPath, this.getLocation());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.m_iVerbosity != null) {
            arrayList.add(this.m_cPrefix + NSIS_OPT_VERBOSITY + this.m_iVerbosity);
        }
        if (this.m_fOut != null) {
            arrayList.add(this.m_cPrefix + NSIS_OPT_OUTPUT + this.m_fOut.getPath());
        }
        if (this.m_bPause != null) {
            arrayList.add(this.m_cPrefix + NSIS_OPT_PAUSE);
        }
        if (this.m_bNoconfig != null && this.m_bNoconfig.booleanValue()) {
            arrayList.add(this.m_cPrefix + NSIS_OPT_NOCONFIG);
        }
        if (this.m_bNocd != null && this.m_bNocd.booleanValue()) {
            arrayList.add(this.m_cPrefix + NSIS_OPT_NOCD);
        }
        for (n = 0; n < this.m_lDefines.size(); ++n) {
            object = (Define)this.m_lDefines.get(n);
            string = ((Define)object).getName();
            if (string == null) {
                throw new BuildException("Attribute 'name' is required", this.getLocation());
            }
            String string2 = ((Define)object).getValue();
            if (string2 == null) {
                throw new BuildException("Attribute 'value' is required", this.getLocation());
            }
            arrayList.add(this.m_cPrefix + NSIS_OPT_DEFINE + string + "=" + string2);
        }
        for (n = 0; n < this.m_lScriptcmds.size(); ++n) {
            object = (Scriptcmd)this.m_lScriptcmds.get(n);
            string = ((Scriptcmd)object).getCmd();
            if (string == null) {
                throw new BuildException("Attribute 'cmd' is required", this.getLocation());
            }
            arrayList.add(this.m_cPrefix + NSIS_OPT_SCRIPTCMD + string);
        }
        arrayList.add(this.m_fScript.getPath());
        Commandline commandline = new Commandline();
        commandline.setExecutable(this.m_sPath + NSIS_CMD_LINE);
        commandline.addArguments(arrayList.toArray(new String[arrayList.size()]));
        object = new Execute((ExecuteStreamHandler)new LogStreamHandler((org.apache.tools.ant.Task)this, 2, 1));
        object.setAntRun(this.getProject());
        object.setWorkingDirectory(this.getProject().getBaseDir());
        object.setCommandline(commandline.getCommandline());
        try {
            int n2 = object.execute();
            if (n2 != 0) {
                throw new BuildException("Command failed, error code " + n2 + ": '" + commandline + "'", this.getLocation());
            }
            this.log("Successfully compiled script " + this.m_fScript, 2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new BuildException("Command failed: '" + commandline + "'", (Throwable)iOException, this.getLocation());
        }
    }

    public void addDefine(Define define) {
        this.m_lDefines.add(define);
    }

    public void addScriptcmd(Scriptcmd scriptcmd) {
        this.m_lScriptcmds.add(scriptcmd);
    }

    public void setScript(File file) {
        this.m_fScript = file;
    }

    public void setVerbosity(Verbosity verbosity) {
        try {
            this.m_iVerbosity = new Integer(verbosity.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
    }

    public void setOut(File file) {
        this.m_fOut = file;
    }

    public void setPause(Boolean bl) {
        this.m_bPause = bl;
    }

    public void setNoconfig(Boolean bl) {
        this.m_bNoconfig = bl;
    }

    public void setNocd(Boolean bl) {
        this.m_bNocd = bl;
    }

    public void setPrefix(char c) {
        this.m_cPrefix = c;
    }

    public void setPath(String string) {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        this.m_sPath = string;
    }
}

