/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;

public class InstructionSequenceMatcher
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_MORE = false;
    public static final int X = 0x40000000;
    public static final int Y = 0x40000001;
    public static final int Z = 0x40000002;
    public static final int A = 0x40000003;
    public static final int B = 0x40000004;
    public static final int C = 0x40000005;
    public static final int D = 0x40000006;
    private final Constant[] patternConstants;
    private final Instruction[] patternInstructions;
    private boolean matching;
    private int patternInstructionIndex;
    private final int[] matchedInstructionOffsets;
    private int matchedArgumentFlags;
    private final int[] matchedArguments = new int[7];
    private final long[] matchedConstantFlags;
    private final int[] matchedConstantIndices;
    private int constantFlags;
    private int previousConstantFlags;
    private Constant patternConstant;
    private boolean matchingConstant;

    public InstructionSequenceMatcher(Constant[] constantArray, Instruction[] instructionArray) {
        this.patternConstants = constantArray;
        this.patternInstructions = instructionArray;
        this.matchedInstructionOffsets = new int[instructionArray.length];
        this.matchedConstantFlags = new long[(constantArray.length + 63) / 64];
        this.matchedConstantIndices = new int[constantArray.length];
    }

    public void reset() {
        this.patternInstructionIndex = 0;
        this.matchedArgumentFlags = 0;
        Arrays.fill(this.matchedConstantFlags, 0L);
        this.previousConstantFlags = this.constantFlags;
        this.constantFlags = 0;
    }

    public boolean isMatching() {
        return this.matching;
    }

    public int instructionCount() {
        return this.patternInstructions.length;
    }

    public int matchedInstructionOffset(int n) {
        return this.matchedInstructionOffsets[n];
    }

    public boolean wasConstant(int n) {
        return (this.previousConstantFlags & 1 << n - 0x40000000) != 0;
    }

    public int matchedArgument(int n) {
        int n2 = n - 0x40000000;
        return n2 < 0 ? n : this.matchedArguments[n2];
    }

    public int[] matchedArguments(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.matchedArgument(nArray[i]);
        }
        return nArray2;
    }

    public int matchedConstantIndex(int n) {
        int n2 = n - 0x40000000;
        return n2 < 0 ? this.matchedConstantIndices[n] : this.matchedArguments[n2];
    }

    public int matchedBranchOffset(int n, int n2) {
        int n3 = n2 - 0x40000000;
        return n3 < 0 ? n2 : this.matchedArguments[n3] - n;
    }

    public int[] matchedJumpOffsets(int n, int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = this.matchedBranchOffset(n, nArray[i]);
        }
        return nArray2;
    }

    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, SimpleInstruction simpleInstruction) {
        Instruction instruction = this.patternInstructions[this.patternInstructionIndex];
        boolean bl = this.matchingOpcodes(simpleInstruction, instruction) && this.matchingArguments(simpleInstruction.constant, ((SimpleInstruction)instruction).constant);
        this.checkMatch(bl, clazz, method, codeAttribute, n, simpleInstruction);
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, VariableInstruction variableInstruction) {
        Instruction instruction = this.patternInstructions[this.patternInstructionIndex];
        boolean bl = this.matchingOpcodes(variableInstruction, instruction) && this.matchingArguments(variableInstruction.variableIndex, ((VariableInstruction)instruction).variableIndex) && this.matchingArguments(variableInstruction.constant, ((VariableInstruction)instruction).constant);
        this.checkMatch(bl, clazz, method, codeAttribute, n, variableInstruction);
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        Instruction instruction = this.patternInstructions[this.patternInstructionIndex];
        boolean bl = this.matchingOpcodes(constantInstruction, instruction) && this.matchingConstantIndices(clazz, constantInstruction.constantIndex, ((ConstantInstruction)instruction).constantIndex) && this.matchingArguments(constantInstruction.constant, ((ConstantInstruction)instruction).constant);
        this.checkMatch(bl, clazz, method, codeAttribute, n, constantInstruction);
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, BranchInstruction branchInstruction) {
        Instruction instruction = this.patternInstructions[this.patternInstructionIndex];
        boolean bl = this.matchingOpcodes(branchInstruction, instruction) && this.matchingBranchOffsets(n, branchInstruction.branchOffset, ((BranchInstruction)instruction).branchOffset);
        this.checkMatch(bl, clazz, method, codeAttribute, n, branchInstruction);
    }

    public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, TableSwitchInstruction tableSwitchInstruction) {
        Instruction instruction = this.patternInstructions[this.patternInstructionIndex];
        boolean bl = this.matchingOpcodes(tableSwitchInstruction, instruction) && this.matchingBranchOffsets(n, tableSwitchInstruction.defaultOffset, ((TableSwitchInstruction)instruction).defaultOffset) && this.matchingArguments(tableSwitchInstruction.lowCase, ((TableSwitchInstruction)instruction).lowCase) && this.matchingArguments(tableSwitchInstruction.highCase, ((TableSwitchInstruction)instruction).highCase) && this.matchingJumpOffsets(n, tableSwitchInstruction.jumpOffsets, ((TableSwitchInstruction)instruction).jumpOffsets);
        this.checkMatch(bl, clazz, method, codeAttribute, n, tableSwitchInstruction);
    }

    public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
        Instruction instruction = this.patternInstructions[this.patternInstructionIndex];
        boolean bl = this.matchingOpcodes(lookUpSwitchInstruction, instruction) && this.matchingBranchOffsets(n, lookUpSwitchInstruction.defaultOffset, ((LookUpSwitchInstruction)instruction).defaultOffset) && this.matchingArguments(lookUpSwitchInstruction.cases, ((LookUpSwitchInstruction)instruction).cases) && this.matchingJumpOffsets(n, lookUpSwitchInstruction.jumpOffsets, ((LookUpSwitchInstruction)instruction).jumpOffsets);
        this.checkMatch(bl, clazz, method, codeAttribute, n, lookUpSwitchInstruction);
    }

    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        IntegerConstant integerConstant2 = (IntegerConstant)this.patternConstant;
        this.matchingConstant = integerConstant.getValue() == integerConstant2.getValue();
    }

    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        LongConstant longConstant2 = (LongConstant)this.patternConstant;
        this.matchingConstant = longConstant.getValue() == longConstant2.getValue();
    }

    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        FloatConstant floatConstant2 = (FloatConstant)this.patternConstant;
        this.matchingConstant = floatConstant.getValue() == floatConstant2.getValue();
    }

    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        DoubleConstant doubleConstant2 = (DoubleConstant)this.patternConstant;
        this.matchingConstant = doubleConstant.getValue() == doubleConstant2.getValue();
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        StringConstant stringConstant2 = (StringConstant)this.patternConstant;
        this.matchingConstant = this.matchingConstantIndices(clazz, stringConstant.u2stringIndex, stringConstant2.u2stringIndex);
    }

    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        Utf8Constant utf8Constant2 = (Utf8Constant)this.patternConstant;
        this.matchingConstant = utf8Constant.getString().equals(utf8Constant2.getString());
    }

    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        InvokeDynamicConstant invokeDynamicConstant2 = (InvokeDynamicConstant)this.patternConstant;
        this.matchingConstant = this.matchingConstantIndices(clazz, invokeDynamicConstant.getBootstrapMethodAttributeIndex(), invokeDynamicConstant2.getBootstrapMethodAttributeIndex()) && this.matchingConstantIndices(clazz, invokeDynamicConstant.getNameAndTypeIndex(), invokeDynamicConstant2.getNameAndTypeIndex());
    }

    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        MethodHandleConstant methodHandleConstant2 = (MethodHandleConstant)this.patternConstant;
        this.matchingConstant = this.matchingArguments(methodHandleConstant.getReferenceKind(), methodHandleConstant2.getReferenceKind()) && this.matchingConstantIndices(clazz, methodHandleConstant.getReferenceIndex(), methodHandleConstant2.getReferenceIndex());
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        RefConstant refConstant2 = (RefConstant)this.patternConstant;
        this.matchingConstant = this.matchingConstantIndices(clazz, refConstant.getClassIndex(), refConstant2.getClassIndex()) && this.matchingConstantIndices(clazz, refConstant.getNameAndTypeIndex(), refConstant2.getNameAndTypeIndex());
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        ClassConstant classConstant2 = (ClassConstant)this.patternConstant;
        this.matchingConstant = this.matchingConstantIndices(clazz, classConstant.u2nameIndex, classConstant2.u2nameIndex);
    }

    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        MethodTypeConstant methodTypeConstant2 = (MethodTypeConstant)this.patternConstant;
        this.matchingConstant = this.matchingConstantIndices(clazz, methodTypeConstant.u2descriptorIndex, methodTypeConstant2.u2descriptorIndex);
    }

    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        NameAndTypeConstant nameAndTypeConstant2 = (NameAndTypeConstant)this.patternConstant;
        this.matchingConstant = this.matchingConstantIndices(clazz, nameAndTypeConstant.u2nameIndex, nameAndTypeConstant2.u2nameIndex) && this.matchingConstantIndices(clazz, nameAndTypeConstant.u2descriptorIndex, nameAndTypeConstant2.u2descriptorIndex);
    }

    private boolean matchingOpcodes(Instruction instruction, Instruction instruction2) {
        return instruction.opcode == instruction2.opcode || instruction.canonicalOpcode() == instruction2.opcode;
    }

    private boolean matchingArguments(int n, int n2) {
        int n3 = n2 - 0x40000000;
        if (n3 < 0) {
            return n == n2;
        }
        if (!this.isMatchingArgumentIndex(n3)) {
            this.setMatchingArgument(n3, n);
            return true;
        }
        return this.matchedArguments[n3] == n;
    }

    private void setMatchingArgument(int n, int n2) {
        this.matchedArguments[n] = n2;
        this.matchedArgumentFlags |= 1 << n;
    }

    private boolean isMatchingArgumentIndex(int n) {
        return (this.matchedArgumentFlags & 1 << n) != 0;
    }

    private boolean matchingArguments(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (this.matchingArguments(nArray[i], nArray2[i])) continue;
            return false;
        }
        return true;
    }

    private boolean matchingConstantIndices(Clazz clazz, int n, int n2) {
        if (n2 >= 0x40000000) {
            this.constantFlags |= 1 << n2 - 0x40000000;
            return this.matchingArguments(n, n2);
        }
        if (!this.isMatchingConstantIndex(n2)) {
            this.matchingConstant = false;
            this.patternConstant = this.patternConstants[n2];
            if (clazz.getTag(n) == this.patternConstant.getTag()) {
                clazz.constantPoolEntryAccept(n, this);
                if (this.matchingConstant) {
                    this.setMatchingConstant(n2, n);
                }
            }
            return this.matchingConstant;
        }
        return this.matchedConstantIndices[n2] == n;
    }

    private void setMatchingConstant(int n, int n2) {
        this.matchedConstantIndices[n] = n2;
        int n3 = n / 64;
        this.matchedConstantFlags[n3] = this.matchedConstantFlags[n3] | 1L << n;
    }

    private boolean isMatchingConstantIndex(int n) {
        return (this.matchedConstantFlags[n / 64] & 1L << n) != 0L;
    }

    private boolean matchingBranchOffsets(int n, int n2, int n3) {
        int n4 = n3 - 0x40000000;
        if (n4 < 0) {
            return n2 == n3;
        }
        if (!this.isMatchingArgumentIndex(n4)) {
            this.setMatchingArgument(n4, n + n2);
            return true;
        }
        return this.matchedArguments[n4] == n + n2;
    }

    private boolean matchingJumpOffsets(int n, int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (this.matchingBranchOffsets(n, nArray[i], nArray2[i])) continue;
            return false;
        }
        return true;
    }

    private void checkMatch(boolean bl, Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        if (bl) {
            this.matchedInstructionOffsets[this.patternInstructionIndex] = n;
            ++this.patternInstructionIndex;
            boolean bl2 = this.matching = this.patternInstructionIndex == this.patternInstructions.length;
            if (this.matching) {
                this.reset();
            }
        } else {
            this.matching = false;
            boolean bl3 = this.patternInstructionIndex == 1;
            this.reset();
            if (bl3) {
                instruction.accept(clazz, method, codeAttribute, n, this);
            }
        }
    }
}

