/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import gde.data.Record;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.histo.utils.GpsCoordinate;
import gde.log.Level;
import gde.utils.StringHelper;
import java.util.Date;
import java.util.Locale;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Logger;

public class GPSHelper {
    private static Logger log = Logger.getLogger(GPSHelper.class.getName());
    static final double rad = Math.PI / 180;

    public static synchronized double getDistance2D_m(double fistLatitude, double firstLongitude, double secondLatitude, double secondLongitude) {
        return 6378388.0 * Math.acos(Math.sin(fistLatitude * (Math.PI / 180)) * Math.sin(secondLatitude * (Math.PI / 180)) + Math.cos(fistLatitude * (Math.PI / 180)) * Math.cos(secondLatitude * (Math.PI / 180)) * Math.cos((firstLongitude - secondLongitude) * (Math.PI / 180)));
    }

    public static double getDistance3D_m(double fistLatitude, double firstLongitude, double firstAltitude, double secondLatitude, double secondLongitude, double secondAltitude) {
        double dist_m = 6378388.0 * Math.acos(Math.sin(fistLatitude * (Math.PI / 180)) * Math.sin(secondLatitude * (Math.PI / 180)) + Math.cos(fistLatitude * (Math.PI / 180)) * Math.cos(secondLatitude * (Math.PI / 180)) * Math.cos((firstLongitude - secondLongitude) * (Math.PI / 180)));
        double dz = secondAltitude - firstAltitude;
        return Math.sqrt(Math.pow(dist_m, 2.0) + Math.pow(dz, 2.0));
    }

    public static double getSpeed2D_kmh(double fistLatitude, double firstLongitude, long firstTime_ms, double secondLatitude, double secondLongitude, long secondTime_ms) {
        double dist_m = 6378388.0 * Math.acos(Math.sin(fistLatitude * (Math.PI / 180)) * Math.sin(secondLatitude * (Math.PI / 180)) + Math.cos(fistLatitude * (Math.PI / 180)) * Math.cos(secondLatitude * (Math.PI / 180)) * Math.cos((firstLongitude - secondLongitude) * (Math.PI / 180)));
        long deltaTime_ms = (secondTime_ms - firstTime_ms) / 10L;
        return dist_m / (double)deltaTime_ms * 3600.0;
    }

    public static double getSpeed3D_kmh(double firstLatitude, double firstLongitude, double firstAltitude, long firstTime_ms, double secondLatitude, double secondLongitude, double secondAltitude, long secondTime_ms) {
        double dz = secondAltitude - firstAltitude;
        long deltaTime_ms = (secondTime_ms - firstTime_ms) / 10L;
        double dist_m = 6378388.0 * Math.acos(Math.sin(firstLatitude * (Math.PI / 180)) * Math.sin(secondLatitude * (Math.PI / 180)) + Math.cos(firstLatitude * (Math.PI / 180)) * Math.cos(secondLatitude * (Math.PI / 180)) * Math.cos((firstLongitude - secondLongitude) * (Math.PI / 180)));
        return Math.sqrt(Math.pow(dist_m, 2.0) + Math.pow(dz, 2.0)) / (double)deltaTime_ms * 3600.0;
    }

    public static synchronized int getStartIndexGPS(RecordSet recordSet, int recordOrdinalLatitude, int recordOrdinalLongitude) {
        int startIndexGPS = -1;
        Record recordLatitude = recordSet.get(recordOrdinalLatitude);
        Record recordLongitude = recordSet.get(recordOrdinalLongitude);
        int recordSize = recordLatitude.realSize();
        if (recordSize >= 3 && recordLatitude.hasReasonableData() && recordLongitude.hasReasonableData()) {
            startIndexGPS = 0;
            for (int i = 0; i < recordSize; ++i) {
                if (recordLatitude.get(i) == 0 || recordLongitude.get(i) == 0) continue;
                startIndexGPS = i;
                break;
            }
        }
        return startIndexGPS < recordSize - 1 ? startIndexGPS + 1 : startIndexGPS;
    }

    public static synchronized void calculateValues(IDevice device, RecordSet recordSet, int recordOrdinalLatitude, int recordOrdinalLongitude, int recordOrdinalAltitude, int startAltitude, int recordOrdinalTripLength, int recordOrdinalDistance, int recordOrdinalAzimuth, int recordOrdinalDirectionStart) {
        double lastTripLength = 0.0;
        long startTime = new Date().getTime();
        try {
            Record recordLatitude = recordSet.get(recordOrdinalLatitude);
            Record recordLongitude = recordSet.get(recordOrdinalLongitude);
            Record recordAlitude = recordSet.get(recordOrdinalAltitude);
            int recordSize = recordLatitude.realSize();
            if (recordSize >= 3 && recordLatitude.hasReasonableData() && recordLongitude.hasReasonableData()) {
                int i;
                Record recordTripLength = recordSet.get(recordOrdinalTripLength);
                Record recordDistance = recordSet.get(recordOrdinalDistance);
                Record recordAzimuth = recordSet.get(recordOrdinalAzimuth);
                Record recordDirection = recordSet.get(recordOrdinalDirectionStart);
                recordTripLength.clear();
                recordDistance.clear();
                recordAzimuth.clear();
                recordDirection.clear();
                int indexGPS = 0;
                for (i = 0; i < recordSize; ++i) {
                    if (recordLatitude.get(i) != 0 && recordLongitude.get(i) != 0) {
                        indexGPS = i++;
                        break;
                    }
                    recordTripLength.add(0);
                    recordDistance.add(0);
                    recordDirection.add(0);
                    recordAzimuth.add(0);
                    recordDirection.add(0);
                }
                recordTripLength.add(0);
                recordDistance.add(0);
                int lastLongitude = recordLongitude.get(indexGPS);
                int startLongitude = recordLongitude.get(indexGPS);
                double phi_start_rad = device.translateValue(recordLatitude, (double)recordLatitude.get(indexGPS).intValue() / 1000.0) * (Math.PI / 180);
                double lambda_start = device.translateValue(recordLongitude, (double)lastLongitude / 1000.0);
                double phi_A_rad = phi_start_rad;
                double lambda_A = lambda_start;
                int indexMovement = 0;
                recordTripLength.add(0);
                recordDistance.add(0);
                recordDirection.add(0);
                while (i < recordSize) {
                    double prod_alpha;
                    double prod_alpha_start;
                    double phi_B_rad = device.translateValue(recordLatitude, (double)recordLatitude.get(i).intValue() / 1000.0) * (Math.PI / 180);
                    double lambda_B = device.translateValue(recordLongitude, (double)recordLongitude.get(i).intValue() / 1000.0);
                    double prod_start = Math.sin(phi_start_rad) * Math.sin(phi_B_rad) + Math.cos(phi_start_rad) * Math.cos(phi_B_rad) * Math.cos((lambda_B - lambda_start) * (Math.PI / 180));
                    prod_start = prod_start > 1.0 ? 1.0 : (prod_start < -1.0 ? -1.0 : prod_start);
                    double zeta_start_rad = Math.acos(prod_start);
                    zeta_start_rad = zeta_start_rad <= 0.0 ? 0.0 : (zeta_start_rad >= Math.PI ? Math.PI : zeta_start_rad);
                    double zeta_start = zeta_start_rad / (Math.PI / 180);
                    double prod = Math.sin(phi_A_rad) * Math.sin(phi_B_rad) + Math.cos(phi_A_rad) * Math.cos(phi_B_rad) * Math.cos((lambda_B - lambda_A) * (Math.PI / 180));
                    prod = prod > 1.0 ? 1.0 : (prod < -1.0 ? -1.0 : prod);
                    double zeta_rad = Math.acos(prod);
                    zeta_rad = zeta_rad <= 0.0 ? 0.0 : (zeta_rad >= Math.PI ? Math.PI : zeta_rad);
                    double zeta = zeta_rad / (Math.PI / 180);
                    double powDeltaHeight = Math.pow((double)(recordAlitude.get(i - 1) - recordAlitude.get(i)) / 1000.0, 2.0);
                    double powOrthodrome = Math.pow(zeta * 111225.0, 2.0);
                    double deltaTrip = Math.sqrt(powOrthodrome + powDeltaHeight) * 0.942;
                    recordTripLength.add((int)(lastTripLength + deltaTrip));
                    powDeltaHeight = Math.pow((double)(recordAlitude.get(i) - startAltitude) / 1000.0, 2.0);
                    powOrthodrome = Math.pow(zeta_start * 4.0041E7 / 360.0, 2.0);
                    recordDistance.add((int)(Math.sqrt(powOrthodrome + powDeltaHeight) * 1000.0));
                    double d = zeta_start <= 0.0 ? -1.0 : (prod_alpha_start = zeta_start >= Math.PI ? Math.PI : (Math.sin(phi_B_rad) - Math.sin(phi_start_rad) * Math.cos(zeta_start_rad)) / (Math.cos(phi_start_rad) * Math.sin(zeta_start_rad)));
                    double alpha_start = Math.acos(prod_alpha_start < -1.0 ? -1.0 : (prod_alpha_start > 1.0 ? 1.0 : prod_alpha_start)) / (Math.PI / 180);
                    alpha_start = startLongitude > recordLongitude.get(i) ? 360.0 - alpha_start : alpha_start;
                    recordDirection.add((int)(alpha_start * 1000.0));
                    double d2 = zeta_rad <= 0.0 ? -1.0 : (prod_alpha = zeta_rad >= Math.PI ? Math.PI : (Math.sin(phi_B_rad) - Math.sin(phi_A_rad) * Math.cos(zeta_rad)) / (Math.cos(phi_A_rad) * Math.sin(zeta_rad)));
                    double alpha = Math.acos(prod_alpha < -1.0 ? -1.0 : (prod_alpha > 1.0 ? 1.0 : prod_alpha)) / (Math.PI / 180);
                    alpha = lastLongitude > recordLongitude.get(i) ? 360.0 - alpha : alpha;
                    recordAzimuth.add((int)(alpha * 1000.0));
                    int deltaLongitude = Math.abs(lastLongitude - recordLongitude.get(i));
                    int deltaDistance = Math.abs(recordDistance.get(i - 1) - recordDistance.get(i));
                    if (i != 1 && (deltaLongitude <= 2 && deltaTrip < 0.5 || deltaDistance < 5)) {
                        if (i - indexGPS > 3) {
                            recordAzimuth.set(i - 1, (recordAzimuth.get(i - 1) + recordAzimuth.get(i - 2) + recordAzimuth.get(i - 3)) / 3);
                        } else {
                            recordAzimuth.set(i - 1, recordAzimuth.get(i - 1));
                        }
                    } else {
                        lastLongitude = recordLongitude.get(i);
                    }
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, String.format("deltaLongitude = %d; deltaDistance = %d; Kurswinkel = %7.3f; %7.3f", deltaLongitude, deltaDistance, alpha, (double)recordAzimuth.get(i - 1).intValue() / 1000.0));
                    }
                    phi_A_rad = phi_B_rad;
                    lambda_A = lambda_B;
                    lastTripLength += deltaTrip;
                    if (indexMovement == 0 && recordDistance.get(i) > 1500) {
                        indexMovement = i;
                    }
                    ++i;
                }
                recordAzimuth.add(recordAzimuth.getLast());
                int azimuth = recordAzimuth.get(indexMovement);
                int direction = recordDirection.get(indexMovement);
                for (i = 0; i < indexMovement; ++i) {
                    recordAzimuth.set(i, azimuth);
                    recordDirection.set(i, direction);
                }
            }
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
        if (log.isLoggable(Level.TIME)) {
            log.log(Level.TIME, "calcualation time = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - startTime));
        }
    }

    public static synchronized void calculateTripLength(IDevice device, RecordSet recordSet, int recordOrdinalLatitude, int recordOrdinalLongitude, int recordOrdinalAltitude, int startAltitude, int recordOrdinalTripLength) {
        double lastTripLength = 0.0;
        long startTime = new Date().getTime();
        try {
            Record recordLatitude = recordSet.get(recordOrdinalLatitude);
            Record recordLongitude = recordSet.get(recordOrdinalLongitude);
            Record recordAlitude = recordSet.get(recordOrdinalAltitude);
            int recordSize = recordLatitude.realSize();
            if (recordSize >= 3 && recordLatitude.hasReasonableData() && recordLongitude.hasReasonableData()) {
                int i;
                Record recordTripLength = recordSet.get(recordOrdinalTripLength);
                recordTripLength.clear();
                int indexGPS = 0;
                for (i = 0; i < recordSize; ++i) {
                    if (recordLatitude.get(i) != 0 || recordLongitude.get(i) != 0) {
                        indexGPS = i++;
                        break;
                    }
                    recordTripLength.add(0);
                }
                recordTripLength.add(0);
                int lastLongitude = recordLongitude.get(indexGPS);
                int startLongitude = recordLongitude.get(indexGPS);
                double phi_start_rad = device.translateValue(recordLatitude, (double)recordLatitude.get(indexGPS).intValue() / 1000.0) * (Math.PI / 180);
                double lambda_start = device.translateValue(recordLongitude, (double)lastLongitude / 1000.0);
                double phi_A_rad = phi_start_rad;
                double lambda_A = lambda_start;
                while (i < recordSize) {
                    if (recordLatitude.get(i) != 0 || recordLongitude.get(i) != 0) {
                        double prod_alpha;
                        double prod_alpha_start;
                        double phi_B_rad = device.translateValue(recordLatitude, (double)recordLatitude.get(i).intValue() / 1000.0) * (Math.PI / 180);
                        double lambda_B = device.translateValue(recordLongitude, (double)recordLongitude.get(i).intValue() / 1000.0);
                        double prod_start = Math.sin(phi_start_rad) * Math.sin(phi_B_rad) + Math.cos(phi_start_rad) * Math.cos(phi_B_rad) * Math.cos((lambda_B - lambda_start) * (Math.PI / 180));
                        prod_start = prod_start > 1.0 ? 1.0 : (prod_start < -1.0 ? -1.0 : prod_start);
                        double zeta_start_rad = Math.acos(prod_start);
                        zeta_start_rad = zeta_start_rad <= 0.0 ? 0.0 : (zeta_start_rad >= Math.PI ? Math.PI : zeta_start_rad);
                        double zeta_start = zeta_start_rad / (Math.PI / 180);
                        double prod = Math.sin(phi_A_rad) * Math.sin(phi_B_rad) + Math.cos(phi_A_rad) * Math.cos(phi_B_rad) * Math.cos((lambda_B - lambda_A) * (Math.PI / 180));
                        prod = prod > 1.0 ? 1.0 : (prod < -1.0 ? -1.0 : prod);
                        double zeta_rad = Math.acos(prod);
                        zeta_rad = zeta_rad <= 0.0 ? 0.0 : (zeta_rad >= Math.PI ? Math.PI : zeta_rad);
                        double zeta = zeta_rad / (Math.PI / 180);
                        double powDeltaHeight = Math.pow((double)(recordAlitude.get(i - 1) - recordAlitude.get(i)) / 1000.0, 2.0);
                        double powOrthodrome = Math.pow(zeta * 111225.0, 2.0);
                        double deltaTrip = Math.sqrt(powOrthodrome + powDeltaHeight);
                        recordTripLength.add((int)(lastTripLength + deltaTrip));
                        double d = zeta_start <= 0.0 ? -1.0 : (prod_alpha_start = zeta_start >= Math.PI ? Math.PI : (Math.sin(phi_B_rad) - Math.sin(phi_start_rad) * Math.cos(zeta_start_rad)) / (Math.cos(phi_start_rad) * Math.sin(zeta_start_rad)));
                        double alpha_start = Math.acos(prod_alpha_start < -1.0 ? -1.0 : (prod_alpha_start > 1.0 ? 1.0 : prod_alpha_start)) / (Math.PI / 180);
                        double d2 = alpha_start = startLongitude > recordLongitude.get(i) ? 360.0 - alpha_start : alpha_start;
                        double d3 = zeta_rad <= 0.0 ? -1.0 : (prod_alpha = zeta_rad >= Math.PI ? Math.PI : (Math.sin(phi_B_rad) - Math.sin(phi_A_rad) * Math.cos(zeta_rad)) / (Math.cos(phi_A_rad) * Math.sin(zeta_rad)));
                        double alpha = Math.acos(prod_alpha < -1.0 ? -1.0 : (prod_alpha > 1.0 ? 1.0 : prod_alpha)) / (Math.PI / 180);
                        alpha = lastLongitude > recordLongitude.get(i) ? 360.0 - alpha : alpha;
                        lastLongitude = recordLongitude.get(i);
                        phi_A_rad = phi_B_rad;
                        lambda_A = lambda_B;
                        lastTripLength += deltaTrip;
                    } else {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, String.format("%d - %s", i, recordSet.getName(), recordLatitude, recordLongitude));
                        }
                        recordTripLength.add((int)lastTripLength);
                    }
                    ++i;
                }
                for (int j = recordTripLength.realSize(); j < recordSize; ++j) {
                    recordTripLength.add(recordTripLength.get(recordTripLength.realSize() - 1));
                }
            }
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
        if (log.isLoggable(Level.TIME)) {
            log.log(Level.TIME, "calcualation time = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - startTime));
        }
    }

    public static synchronized void calculateTripLength2D(IDevice device, RecordSet recordSet, int recordOrdinalLatitude, int recordOrdinalLongitude, int recordOrdinalTripLength) {
        double lastTripLength = 0.0;
        long startTime = new Date().getTime();
        try {
            Record recordLatitude = recordSet.get(recordOrdinalLatitude);
            Record recordLongitude = recordSet.get(recordOrdinalLongitude);
            int recordSize = recordLatitude.realSize();
            if (recordSize >= 3 && recordLatitude.hasReasonableData() && recordLongitude.hasReasonableData()) {
                int i;
                Record recordTripLength = recordSet.get(recordOrdinalTripLength);
                recordTripLength.clear();
                int indexGPS = 0;
                for (i = 0; i < recordSize; ++i) {
                    if (recordLatitude.get(i) != 0 || recordLongitude.get(i) != 0) {
                        indexGPS = i++;
                        break;
                    }
                    recordTripLength.add(0);
                }
                recordTripLength.add(0);
                int lastLongitude = recordLongitude.get(indexGPS);
                int startLongitude = recordLongitude.get(indexGPS);
                double phi_start_rad = device.translateValue(recordLatitude, (double)recordLatitude.get(indexGPS).intValue() / 1000.0) * (Math.PI / 180);
                double lambda_start = device.translateValue(recordLongitude, (double)lastLongitude / 1000.0);
                double phi_A_rad = phi_start_rad;
                double lambda_A = lambda_start;
                while (i < recordSize) {
                    if (recordLatitude.get(i) != 0 || recordLongitude.get(i) != 0) {
                        double prod_alpha;
                        double prod_alpha_start;
                        double phi_B_rad = device.translateValue(recordLatitude, (double)recordLatitude.get(i).intValue() / 1000.0) * (Math.PI / 180);
                        double lambda_B = device.translateValue(recordLongitude, (double)recordLongitude.get(i).intValue() / 1000.0);
                        double prod_start = Math.sin(phi_start_rad) * Math.sin(phi_B_rad) + Math.cos(phi_start_rad) * Math.cos(phi_B_rad) * Math.cos((lambda_B - lambda_start) * (Math.PI / 180));
                        prod_start = prod_start > 1.0 ? 1.0 : (prod_start < -1.0 ? -1.0 : prod_start);
                        double zeta_start_rad = Math.acos(prod_start);
                        zeta_start_rad = zeta_start_rad <= 0.0 ? 0.0 : (zeta_start_rad >= Math.PI ? Math.PI : zeta_start_rad);
                        double zeta_start = zeta_start_rad / (Math.PI / 180);
                        double prod = Math.sin(phi_A_rad) * Math.sin(phi_B_rad) + Math.cos(phi_A_rad) * Math.cos(phi_B_rad) * Math.cos((lambda_B - lambda_A) * (Math.PI / 180));
                        prod = prod > 1.0 ? 1.0 : (prod < -1.0 ? -1.0 : prod);
                        double zeta_rad = Math.acos(prod);
                        zeta_rad = zeta_rad <= 0.0 ? 0.0 : (zeta_rad >= Math.PI ? Math.PI : zeta_rad);
                        double zeta = zeta_rad / (Math.PI / 180);
                        double powOrthodrome = Math.pow(zeta * 111225.0, 2.0);
                        double deltaTrip = Math.sqrt(powOrthodrome);
                        recordTripLength.add((int)(lastTripLength + deltaTrip));
                        double d = zeta_start <= 0.0 ? -1.0 : (prod_alpha_start = zeta_start >= Math.PI ? Math.PI : (Math.sin(phi_B_rad) - Math.sin(phi_start_rad) * Math.cos(zeta_start_rad)) / (Math.cos(phi_start_rad) * Math.sin(zeta_start_rad)));
                        double alpha_start = Math.acos(prod_alpha_start < -1.0 ? -1.0 : (prod_alpha_start > 1.0 ? 1.0 : prod_alpha_start)) / (Math.PI / 180);
                        double d2 = alpha_start = startLongitude > recordLongitude.get(i) ? 360.0 - alpha_start : alpha_start;
                        double d3 = zeta_rad <= 0.0 ? -1.0 : (prod_alpha = zeta_rad >= Math.PI ? Math.PI : (Math.sin(phi_B_rad) - Math.sin(phi_A_rad) * Math.cos(zeta_rad)) / (Math.cos(phi_A_rad) * Math.sin(zeta_rad)));
                        double alpha = Math.acos(prod_alpha < -1.0 ? -1.0 : (prod_alpha > 1.0 ? 1.0 : prod_alpha)) / (Math.PI / 180);
                        alpha = lastLongitude > recordLongitude.get(i) ? 360.0 - alpha : alpha;
                        lastLongitude = recordLongitude.get(i);
                        phi_A_rad = phi_B_rad;
                        lambda_A = lambda_B;
                        lastTripLength += deltaTrip;
                    } else {
                        if (log.isLoggable(Level.FINE)) {
                            log.log(Level.FINE, String.format("%d - %s", i, recordSet.getName(), recordLatitude, recordLongitude));
                        }
                        recordTripLength.add((int)lastTripLength);
                    }
                    ++i;
                }
                for (int j = recordTripLength.realSize(); j < recordSize; ++j) {
                    recordTripLength.add(recordTripLength.get(recordTripLength.realSize() - 1));
                }
            }
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
        if (log.isLoggable(Level.TIME)) {
            log.log(Level.TIME, "calcualation time = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - startTime));
        }
    }

    public static synchronized Vector<Integer> calculateAzimuth(IDevice device, RecordSet recordSet, int recordOrdinalLatitude, int recordOrdinalLongitude, int recordOrdinalAltitude) {
        Vector<Integer> recordAzimuth = new Vector<Integer>();
        long startTime = new Date().getTime();
        try {
            Record recordLatitude = recordSet.get(recordOrdinalLatitude);
            Record recordLongitude = recordSet.get(recordOrdinalLongitude);
            Record recordAltitude = recordOrdinalAltitude < 0 ? null : recordSet.get(recordOrdinalAltitude);
            int recordSize = recordLatitude.realSize();
            if (recordSize >= 3 && recordLatitude.hasReasonableData() && recordLongitude.hasReasonableData()) {
                int i;
                int indexGPS = 0;
                for (i = 0; i < recordSize; ++i) {
                    if (recordLatitude.get(i) != 0 && recordLongitude.get(i) != 0) {
                        indexGPS = i++;
                        break;
                    }
                    recordAzimuth.add(0);
                }
                int lastLongitude = recordLongitude.get(indexGPS);
                double phi_A_rad = device.translateValue(recordLatitude, (double)recordLatitude.get(indexGPS).intValue() / 1000.0) * (Math.PI / 180);
                double lambda_A = device.translateValue(recordLongitude, (double)lastLongitude / 1000.0);
                int indexMovement = 0;
                while (i < recordSize) {
                    double prod_alpha;
                    double phi_B_rad = device.translateValue(recordLatitude, (double)recordLatitude.get(i).intValue() / 1000.0) * (Math.PI / 180);
                    double lambda_B = device.translateValue(recordLongitude, (double)recordLongitude.get(i).intValue() / 1000.0);
                    double prod = Math.sin(phi_A_rad) * Math.sin(phi_B_rad) + Math.cos(phi_A_rad) * Math.cos(phi_B_rad) * Math.cos((lambda_B - lambda_A) * (Math.PI / 180));
                    prod = prod > 1.0 ? 1.0 : (prod < -1.0 ? -1.0 : prod);
                    double zeta_rad = Math.acos(prod);
                    double d = zeta_rad <= 0.0 ? 0.0 : (zeta_rad = zeta_rad >= Math.PI ? Math.PI : zeta_rad);
                    double d2 = zeta_rad <= 0.0 ? -1.0 : (prod_alpha = zeta_rad >= Math.PI ? Math.PI : (Math.sin(phi_B_rad) - Math.sin(phi_A_rad) * Math.cos(zeta_rad)) / (Math.cos(phi_A_rad) * Math.sin(zeta_rad)));
                    double alpha = Math.acos(prod_alpha < -1.0 ? -1.0 : (prod_alpha > 1.0 ? 1.0 : prod_alpha)) / (Math.PI / 180);
                    alpha = lastLongitude > recordLongitude.get(i) ? 360.0 - alpha : alpha;
                    recordAzimuth.add((int)(alpha * 1000.0));
                    phi_A_rad = phi_B_rad;
                    lambda_A = lambda_B;
                    lastLongitude = recordLongitude.get(i);
                    if (indexMovement == 0) {
                        double zeta = zeta_rad / (Math.PI / 180);
                        double powDeltaHeight = recordAltitude == null ? 0.0 : Math.pow((double)(recordAltitude.get(i - 1) - recordAltitude.get(i)) / 1000.0, 2.0);
                        double powOrthodrome = Math.pow(zeta * 111225.0, 2.0);
                        if ((int)(Math.sqrt(powOrthodrome + powDeltaHeight) * 1000.0) > 1500) {
                            indexMovement = i;
                        }
                    }
                    ++i;
                }
                recordAzimuth.add(recordAzimuth.get(recordAzimuth.size() - 1));
                int azimuth = recordAzimuth.get(indexMovement);
                for (i = 0; i < indexMovement; ++i) {
                    recordAzimuth.set(i, azimuth);
                }
            }
        }
        catch (RuntimeException e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
        if (log.isLoggable(Level.TIME)) {
            log.log(Level.TIME, "calcualation time = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - startTime));
        }
        return recordAzimuth;
    }

    public static synchronized void calculateSpeed2D(IDevice device, RecordSet recordSet, int recordOrdinalLatitude, int recordOrdinalLongitude, int recordOrdinalSpeed) {
        int i;
        Record recordLatitude = recordSet.get(recordOrdinalLatitude);
        Record recordLongitude = recordSet.get(recordOrdinalLongitude);
        int recordSize = recordLatitude.realSize();
        Record recordSpeed = recordSet.get(recordOrdinalSpeed);
        recordSpeed.clear();
        recordSpeed.add(0);
        recordSpeed.add(0);
        for (i = 2; i < recordSize - 1; ++i) {
            double speed2D = GPSHelper.getSpeed2D_kmh(device.translateValue(recordLatitude, (double)recordLatitude.realGet(i - 2).intValue() / 1000.0), device.translateValue(recordLongitude, (double)recordLongitude.realGet(i - 2).intValue() / 1000.0), recordSet.getTime(i - 2), device.translateValue(recordLatitude, (double)recordLatitude.realGet(i).intValue() / 1000.0), device.translateValue(recordLongitude, (double)recordLongitude.realGet(i).intValue() / 1000.0), recordSet.getTime(i + 1));
            recordSpeed.add((int)(speed2D * 1000.0));
        }
        recordSpeed.add(0);
        recordSpeed.add(0);
        recordSpeed.add(0);
        recordSpeed.resetMinMax();
        recordSpeed.resetStatiticCalculationBase();
        for (i = 3; i < recordSize - 3; ++i) {
            recordSpeed.set(i, (recordSpeed.get(i - 3) + recordSpeed.get(i - 2) + recordSpeed.get(i - 1) + recordSpeed.get(i) + recordSpeed.get(i + 1) + recordSpeed.get(i + 2)) / 6);
        }
    }

    public static synchronized void calculateSpeed3D(IDevice device, RecordSet recordSet, int recordOrdinalLatitude, int recordOrdinalLongitude, int recordOrdinalAltitude, int recordOrdinalSpeed) {
        int i;
        Record recordLatitude = recordSet.get(recordOrdinalLatitude);
        Record recordLongitude = recordSet.get(recordOrdinalLongitude);
        Record recordAltitude = recordSet.get(recordOrdinalAltitude);
        int recordSize = recordLatitude.realSize();
        Record recordSpeed = recordSet.get(recordOrdinalSpeed);
        recordSpeed.clear();
        recordSpeed.add(0);
        recordSpeed.add(0);
        for (i = 2; i < recordSize - 1; ++i) {
            double speed3D_kmh = GPSHelper.getSpeed3D_kmh(device.translateValue(recordLatitude, (double)recordLatitude.realGet(i - 2).intValue() / 1000.0), device.translateValue(recordLongitude, (double)recordLongitude.realGet(i - 2).intValue() / 1000.0), device.translateValue(recordAltitude, (double)recordAltitude.realGet(i - 2).intValue() / 1000.0), recordSet.getTime(i - 2), device.translateValue(recordLatitude, (double)recordLatitude.realGet(i).intValue() / 1000.0), device.translateValue(recordLongitude, (double)recordLongitude.realGet(i).intValue() / 1000.0), device.translateValue(recordAltitude, (double)recordAltitude.realGet(i).intValue() / 1000.0), recordSet.getTime(i + 1));
            recordSpeed.add(Double.valueOf(speed3D_kmh * 1000.0).intValue());
        }
        recordSpeed.add(0);
        recordSpeed.add(0);
        recordSpeed.resetMinMax();
        recordSpeed.resetStatiticCalculationBase();
        for (i = 2; i < recordSize - 5; ++i) {
            recordSpeed.set(i - 1, (recordSpeed.get(i - 3) + recordSpeed.get(i - 2) + recordSpeed.get(i - 1) + recordSpeed.get(i) + recordSpeed.get(i + 1) + recordSpeed.get(i + 2) + recordSpeed.get(i + 3)) / 7);
        }
    }

    public static synchronized Vector<Long> calculateLabs(IDevice device, RecordSet recordSet, int recordOrdinalLatitude, int recordOrdinalLongitude, int recordOrdinalDistance, int recordOrdinalTrip, int recordOrdinalSpeed) {
        long startTime;
        Vector<Long> labTimes;
        block21: {
            labTimes = new Vector<Long>();
            startTime = new Date().getTime();
            try {
                double deltaLongitude;
                int i;
                Record recordLatitude = recordSet.get(recordOrdinalLatitude);
                Record recordLongitude = recordSet.get(recordOrdinalLongitude);
                Record recordSpeed = recordSet.get(recordOrdinalSpeed);
                int recordSize = recordLatitude.realSize();
                if (!recordLatitude.hasReasonableData() || !recordLongitude.hasReasonableData()) break block21;
                for (i = 0; i < recordSize && (recordLatitude.get(i) == 0 || recordLongitude.get(i) == 0); ++i) {
                }
                int filterIndexCount = (int)(6000.0 / (recordSet.getTime_ms(recordSize - 1) / (double)recordSize));
                double lapStartTime = recordSet.getTime_ms(i);
                filterIndexCount = 15;
                GpsCoordinate startPoint = new GpsCoordinate(48.6625593592642, 9.434632658958435);
                GpsCoordinate endPoint = new GpsCoordinate(48.66223848103202, 9.43461287766695);
                double deltaLatitude = Math.abs(endPoint.getLatitude() - startPoint.getLatitude());
                boolean isLatitude = deltaLatitude > (deltaLongitude = Math.abs(endPoint.getLongitude() - startPoint.getLongitude()));
                TreeMap<String, Double> startLine = new TreeMap<String, Double>();
                if (isLatitude) {
                    count = Integer.valueOf(String.format(Locale.ENGLISH, "%.7f", deltaLatitude).substring(5));
                    deltaLat = deltaLatitude / (double)count;
                    deltaLong = deltaLongitude / (double)count;
                    if (startPoint.getLatitude() < endPoint.getLatitude()) {
                        for (j = 0; j < count; ++j) {
                            startLine.put(String.format(Locale.ENGLISH, "%.7f", startPoint.getLatitude() + (double)j * deltaLat), startPoint.getLongitude() + (double)j * deltaLong);
                        }
                    } else {
                        for (j = 0; j < count; ++j) {
                            startLine.put(String.format(Locale.ENGLISH, "%.7f", endPoint.getLatitude() + (double)j * deltaLat), endPoint.getLongitude() + (double)j * deltaLong);
                        }
                    }
                } else {
                    count = Integer.valueOf(String.format(Locale.ENGLISH, "%.7f", deltaLongitude).substring(5));
                    deltaLat = deltaLatitude / (double)count;
                    deltaLong = deltaLongitude / (double)count;
                    if (startPoint.getLongitude() < endPoint.getLongitude()) {
                        for (j = 0; j < count; ++j) {
                            startLine.put(String.format(Locale.ENGLISH, "%.7f", startPoint.getLongitude() + (double)j * deltaLong), startPoint.getLatitude() + (double)j * deltaLat);
                        }
                    } else {
                        for (j = 0; j < count; ++j) {
                            startLine.put(String.format(Locale.ENGLISH, "%.7f", endPoint.getLongitude() + (double)j * deltaLong), endPoint.getLatitude() + (double)j * deltaLat);
                        }
                    }
                }
                i += filterIndexCount;
                ++i;
                int j = 0;
                while (i < recordSize) {
                    GpsCoordinate lastLatLong = new GpsCoordinate(device.translateValue(recordLatitude, (double)recordLatitude.get(i - 1).intValue() / 1000.0), device.translateValue(recordLongitude, (double)recordLongitude.get(i - 1).intValue() / 1000.0));
                    GpsCoordinate latLong = new GpsCoordinate(device.translateValue(recordLatitude, (double)recordLatitude.get(i).intValue() / 1000.0), device.translateValue(recordLongitude, (double)recordLongitude.get(i).intValue() / 1000.0));
                    int speedFactor = 1 + recordSpeed.get(i) / 1000 / 15;
                    if (isLatitude) {
                        if (startLine.get(lastLatLong.getFormattedLatitude()) != null && startLine.get(latLong.getFormattedLatitude()) != null && Math.abs((Double)startLine.get(lastLatLong.getFormattedLatitude()) - lastLatLong.getLongitude()) <= 8.0E-5 * (double)speedFactor && Math.abs((Double)startLine.get(latLong.getFormattedLatitude()) - latLong.getLongitude()) > 2.0E-5 / (double)speedFactor) {
                            if (j > 0) {
                                log.log(Level.OFF, String.format(Locale.ENGLISH, "startLine hit at %s - lap %2d time = %s - speed = %4d km/h", StringHelper.getFormatedTime("mm:ss.SSS", (long)recordSet.getTime_ms(i)), j, StringHelper.getFormatedTime("mm:ss.SSS", (long)(recordSet.getTime_ms(i) - lapStartTime)), recordSpeed.get(i) / 1000));
                            }
                            lapStartTime = recordSet.getTime_ms(i);
                            i += filterIndexCount;
                            ++j;
                        }
                    } else if (startLine.get(lastLatLong.getFormattedLongitude()) != null && startLine.get(latLong.getFormattedLongitude()) != null && Math.abs((Double)startLine.get(lastLatLong.getFormattedLongitude()) - lastLatLong.getLatitude()) <= 8.0E-5 * (double)speedFactor && Math.abs((Double)startLine.get(latLong.getFormattedLongitude()) - latLong.getLatitude()) > 2.0E-5 / (double)speedFactor) {
                        if (j > 0) {
                            log.log(Level.OFF, String.format(Locale.ENGLISH, "startLine hit at %s - lap %2d time = %s - speed = %4d km/h", StringHelper.getFormatedTime("mm:ss.SSS", (long)recordSet.getTime_ms(i)), j, StringHelper.getFormatedTime("mm:ss.SSS", (long)(recordSet.getTime_ms(i) - lapStartTime)), recordSpeed.get(i) / 1000));
                        }
                        lapStartTime = recordSet.getTime_ms(i);
                        i += filterIndexCount;
                        ++j;
                    }
                    ++i;
                }
            }
            catch (RuntimeException e) {
                log.log(Level.WARNING, e.getMessage(), e);
            }
        }
        if (log.isLoggable(Level.TIME)) {
            log.log(Level.TIME, "calcualation time = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - startTime));
        }
        return labTimes;
    }
}

