/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.cache;

import com.google.gson.Gson;
import gde.DataAccess;
import gde.exception.ThrowableUtils;
import gde.histo.cache.ExtendedVault;
import gde.histo.cache.HistoVault;
import gde.log.Level;
import gde.log.Logger;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

public final class VaultProxy {
    private static final String $CLASS_NAME = VaultProxy.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private static Schema vaultSchema;
    private static Unmarshaller jaxbUnmarshaller;
    private static Marshaller jaxbMarshaller;

    private static Schema getVaultSchema() {
        if (vaultSchema == null) {
            try (InputStream inputStream = DataAccess.getInstance().getCacheXsdInputStream();){
                StreamSource xsdStreamSource = new StreamSource(inputStream);
                vaultSchema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(xsdStreamSource);
            }
            catch (Exception e) {
                throw ThrowableUtils.rethrow(e);
            }
        }
        return vaultSchema;
    }

    public static Unmarshaller getUnmarshaller() {
        if (jaxbUnmarshaller == null) {
            try {
                jaxbUnmarshaller = HistoVault.getJaxbContext().createUnmarshaller();
                jaxbUnmarshaller.setSchema(VaultProxy.getVaultSchema());
            }
            catch (Exception e) {
                throw ThrowableUtils.rethrow(e);
            }
        }
        return jaxbUnmarshaller;
    }

    public static Marshaller getMarshaller() {
        if (jaxbMarshaller == null) {
            try {
                jaxbMarshaller = HistoVault.getJaxbContext().createMarshaller();
                jaxbMarshaller.setProperty("jaxb.formatted.output", true);
                jaxbMarshaller.setSchema(VaultProxy.getVaultSchema());
            }
            catch (Exception e) {
                throw ThrowableUtils.rethrow(e);
            }
        }
        return jaxbMarshaller;
    }

    public static HistoVault loadJson(InputStream inputStream) {
        HistoVault vault = null;
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            vault = (HistoVault)new Gson().fromJson((Reader)reader, HistoVault.class);
        }
        catch (Exception e) {
            ThrowableUtils.rethrow(e);
        }
        return vault;
    }

    public static HistoVault load(InputStream inputStream) {
        HistoVault vault = null;
        try {
            vault = (HistoVault)VaultProxy.getUnmarshaller().unmarshal(inputStream);
        }
        catch (Exception e) {
            ThrowableUtils.rethrow(e);
        }
        return vault;
    }

    public static void storeJson(HistoVault newVault, OutputStream outputStream) {
        HistoVault storableVault = newVault instanceof ExtendedVault ? new HistoVault(newVault) : newVault;
        String json = new Gson().toJson((Object)storableVault);
        log.log(Level.FINER, json);
        try {
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
            writer.write(json);
            writer.flush();
        }
        catch (Exception e) {
            ThrowableUtils.rethrow(e);
        }
    }

    public static void store(HistoVault newVault, OutputStream outputStream) {
        try {
            VaultProxy.getMarshaller().marshal((Object)newVault, outputStream);
        }
        catch (Exception e) {
            ThrowableUtils.rethrow(e);
        }
    }

    public static void threadSafeStore(HistoVault newVault, OutputStream outputStream) throws JAXBException {
        Marshaller marshaller = HistoVault.getJaxbContext().createMarshaller();
        marshaller.setSchema(VaultProxy.getVaultSchema());
        marshaller.marshal((Object)newVault, outputStream);
    }

    public HistoVault threadSafeLoad(InputStream inputStream) throws JAXBException {
        Unmarshaller unmarshaller = HistoVault.getJaxbContext().createUnmarshaller();
        unmarshaller.setSchema(VaultProxy.getVaultSchema());
        return (HistoVault)unmarshaller.unmarshal(inputStream);
    }

    static {
        jaxbUnmarshaller = null;
        jaxbMarshaller = null;
    }
}

