/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.win32.NOTIFYICONDATA;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TypedListener;

public class TrayItem
extends Item {
    Tray parent;
    int id;
    Image image2;
    Image highlightImage;
    ToolTip toolTip;
    String toolTipText;
    boolean visible = true;

    public TrayItem(Tray parent, int style) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
        this.createUpdateWidget(true);
    }

    public void addSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addMenuDetectListener(MenuDetectListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener2);
        this.addListener(35, typedListener);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createUpdateWidget(boolean newIcon) {
        int n2;
        NOTIFYICONDATA iconData = new NOTIFYICONDATA();
        iconData.cbSize = NOTIFYICONDATA.sizeof;
        if (newIcon) {
            int n3 = this.display.nextTrayId;
            n2 = n3;
            this.display.nextTrayId = n3 + 1;
        } else {
            n2 = this.id;
        }
        this.id = n2;
        iconData.uID = n2;
        iconData.hWnd = this.display.hwndMessage;
        iconData.uFlags = 1;
        iconData.uCallbackMessage = 32772;
        OS.Shell_NotifyIcon(newIcon ? 0 : 1, iconData);
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Image getHighlightImage() {
        this.checkWidget();
        return this.highlightImage;
    }

    public Tray getParent() {
        this.checkWidget();
        return this.parent;
    }

    public ToolTip getToolTip() {
        this.checkWidget();
        return this.toolTip;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.visible;
    }

    long messageProc(long hwnd, int msg, long wParam, long lParam) {
        switch ((int)lParam) {
            case 513: {
                if (!this.hooks(13)) break;
                OS.SetForegroundWindow(hwnd);
                this.sendSelectionEvent(13);
                break;
            }
            case 515: 
            case 518: {
                if (!this.hooks(14)) break;
                OS.SetForegroundWindow(hwnd);
                this.sendSelectionEvent(14);
                break;
            }
            case 517: {
                if (!this.hooks(35)) break;
                OS.SetForegroundWindow(hwnd);
                this.sendEvent(35);
                if (!this.isDisposed()) break;
                return 0L;
            }
            case 1026: {
                if (this.toolTip == null || this.toolTip.visible) break;
                this.toolTip.visible = true;
                if (!this.toolTip.hooks(22)) break;
                OS.SetForegroundWindow(hwnd);
                this.toolTip.sendEvent(22);
                if (!this.isDisposed()) break;
                return 0L;
            }
            case 1027: 
            case 1028: 
            case 1029: {
                if (this.toolTip == null) break;
                if (this.toolTip.visible) {
                    this.toolTip.visible = false;
                    if (this.toolTip.hooks(23)) {
                        OS.SetForegroundWindow(hwnd);
                        this.toolTip.sendEvent(23);
                        if (this.isDisposed()) {
                            return 0L;
                        }
                    }
                }
                if (lParam != 1029L || !this.toolTip.hooks(13)) break;
                OS.SetForegroundWindow(hwnd);
                this.toolTip.sendSelectionEvent(13);
                if (!this.isDisposed()) break;
                return 0L;
            }
        }
        this.display.wakeThread();
        return 0L;
    }

    void recreate() {
        this.createUpdateWidget(false);
        if (!this.visible) {
            this.setVisible(false);
        }
        if (this.text.length() != 0) {
            this.setText(this.text);
        }
        if (this.image != null) {
            this.setImage(this.image);
        }
        if (this.toolTipText != null) {
            this.setToolTipText(this.toolTipText);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.toolTip != null) {
            this.toolTip.item = null;
        }
        this.toolTip = null;
        if (this.image2 != null) {
            this.image2.dispose();
        }
        this.image2 = null;
        this.highlightImage = null;
        this.toolTipText = null;
        NOTIFYICONDATA iconData = new NOTIFYICONDATA();
        iconData.cbSize = NOTIFYICONDATA.sizeof;
        iconData.uID = this.id;
        iconData.hWnd = this.display.hwndMessage;
        OS.Shell_NotifyIcon(2, iconData);
    }

    public void removeSelectionListener(SelectionListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener2);
        this.eventTable.unhook(14, listener2);
    }

    public void removeMenuDetectListener(MenuDetectListener listener2) {
        this.checkWidget();
        if (listener2 == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, listener2);
    }

    public void setHighlightImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.highlightImage = image;
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        if (this.image2 != null) {
            this.image2.dispose();
        }
        this.image2 = null;
        long hIcon = 0L;
        Image icon = image;
        if (icon != null) {
            switch (icon.type) {
                case 0: {
                    this.image2 = Display.createIcon(image);
                    hIcon = this.image2.handle;
                    break;
                }
                case 1: {
                    hIcon = icon.handle;
                }
            }
        }
        NOTIFYICONDATA iconData = new NOTIFYICONDATA();
        iconData.cbSize = NOTIFYICONDATA.sizeof;
        iconData.uID = this.id;
        iconData.hWnd = this.display.hwndMessage;
        iconData.hIcon = hIcon;
        iconData.uFlags = 2;
        OS.Shell_NotifyIcon(1, iconData);
    }

    public void setToolTip(ToolTip toolTip) {
        this.checkWidget();
        ToolTip oldTip = this.toolTip;
        ToolTip newTip = toolTip;
        if (oldTip != null) {
            oldTip.item = null;
        }
        this.toolTip = newTip;
        if (newTip != null) {
            newTip.item = this;
        }
    }

    public void setToolTipText(String string2) {
        this.checkWidget();
        this.toolTipText = string2;
        NOTIFYICONDATA iconData = new NOTIFYICONDATA();
        if (string2 != null) {
            char[] szTip = iconData.szTip;
            int length = Math.min(szTip.length - 1, string2.length());
            string2.getChars(0, length, szTip, 0);
        }
        iconData.cbSize = NOTIFYICONDATA.sizeof;
        iconData.uID = this.id;
        iconData.hWnd = this.display.hwndMessage;
        iconData.uFlags = 4;
        OS.Shell_NotifyIcon(1, iconData);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (this.visible == visible) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        this.visible = visible;
        NOTIFYICONDATA iconData = new NOTIFYICONDATA();
        iconData.cbSize = NOTIFYICONDATA.sizeof;
        iconData.uID = this.id;
        iconData.hWnd = this.display.hwndMessage;
        iconData.uFlags = 8;
        iconData.dwState = visible ? 0 : 1;
        iconData.dwStateMask = 1;
        OS.Shell_NotifyIcon(1, iconData);
        if (!visible) {
            this.sendEvent(23);
        }
    }
}

