/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSmartCopy;
import java.io.IOException;
import java.io.OutputStream;

public class PdfConcatenate {
    protected Document document = new Document();
    protected PdfCopy copy;

    public PdfConcatenate(OutputStream os) throws DocumentException {
        this(os, false);
    }

    public PdfConcatenate(OutputStream os, boolean smart) throws DocumentException {
        this.copy = smart ? new PdfSmartCopy(this.document, os) : new PdfCopy(this.document, os);
    }

    public int addPages(PdfReader reader) throws DocumentException, IOException {
        this.open();
        int n2 = reader.getNumberOfPages();
        for (int i2 = 1; i2 <= n2; ++i2) {
            this.copy.addPage(this.copy.getImportedPage(reader, i2));
        }
        this.copy.freeReader(reader);
        reader.close();
        return n2;
    }

    public PdfCopy getWriter() {
        return this.copy;
    }

    public void open() {
        if (!this.document.isOpen()) {
            this.document.open();
        }
    }

    public void close() {
        this.document.close();
    }
}

