/*
 * Decompiled with CFR 0.152.
 */
package gde.device.r2prototyping;

import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.RecordSet;
import gde.device.DeviceDialog;
import gde.device.IDevice;
import gde.device.MeasurementType;
import gde.device.r2prototyping.S32;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.MeasurementControlConfigurable;
import gde.ui.SWTResourceManager;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class S32Dialog
extends DeviceDialog {
    static final Logger log = Logger.getLogger(S32Dialog.class.getName());
    CTabFolder tabFolder;
    CTabFolder subTabFolder1;
    CTabFolder subTabFolder2;
    CTabItem visualizationTabItem;
    CTabItem configurationTabItem;
    Composite configurationMainComposite;
    Label tabItemLabel;
    Button saveVisualizationButton;
    Button inputFileButton;
    Button helpButton;
    Button closeButton;
    final IDevice device;
    final Settings settings;
    String selectedSetupFile;
    String selectedVersionFile;
    RecordSet lastActiveRecordSet = null;
    boolean isVisibilityChanged = false;
    boolean isConfigChanged = false;
    int measurementsCount = 0;
    final List<CTabItem> csonfigurations = new ArrayList<CTabItem>();
    final List<Composite> measurementControls = new ArrayList<Composite>();

    public S32Dialog(Shell parent, S32 useDevice) {
        super(parent);
        this.device = useDevice;
        this.settings = Settings.getInstance();
        this.measurementsCount = this.device.getNumberOfMeasurements(1);
    }

    public void open() {
        try {
            this.shellAlpha = Settings.getInstance().getDialogAlphaValue();
            this.isAlphaEnabled = Settings.getInstance().isDeviceDialogAlphaEnabled();
            log.log(Level.FINE, "dialogShell.isDisposed() " + String.valueOf(this.dialogShell == null ? "null" : Boolean.valueOf(this.dialogShell.isDisposed())));
            if (this.dialogShell == null || this.dialogShell.isDisposed()) {
                this.dialogShell = this.settings.isDeviceDialogsModal() ? new Shell(this.application.getShell(), 34912) : (this.settings.isDeviceDialogsOnTop() ? new Shell(this.application.getDisplay(), 18528) : new Shell(this.application.getDisplay(), 2144));
                SWTResourceManager.registerResourceUser((Widget)this.dialogShell);
                FormLayout dialogShellLayout = new FormLayout();
                this.dialogShell.setLayout((Layout)dialogShellLayout);
                this.dialogShell.pack();
                this.dialogShell.setSize(GDE.IS_LINUX ? 740 : 675, 500);
                this.dialogShell.setText(this.device.getName() + Messages.getString((String)"GDE_MSGT0273"));
                this.dialogShell.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.dialogShell.setImage(SWTResourceManager.getImage((String)"gde/resource/ToolBoxHot.gif"));
                this.dialogShell.addListener(31, new Listener(){

                    public void handleEvent(Event event) {
                        switch (event.detail) {
                            case 2: {
                                S32Dialog.this.dialogShell.close();
                                event.detail = 0;
                                event.doit = false;
                            }
                        }
                    }
                });
                this.dialogShell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent evt) {
                        log.log(Level.FINEST, "dialogShell.widgetDisposed, event=" + String.valueOf(evt));
                        if (S32Dialog.this.device.isChangePropery()) {
                            String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{S32Dialog.this.device.getPropertiesFileName()});
                            if (S32Dialog.this.application.openYesNoMessageDialog(S32Dialog.this.getDialogShell(), msg) == 64) {
                                log.log(Level.FINE, "SWT.YES");
                                S32Dialog.this.device.storeDeviceProperties();
                                S32Dialog.this.setClosePossible(true);
                            }
                        }
                        S32Dialog.this.dispose();
                    }
                });
                this.dialogShell.addHelpListener(new HelpListener(){

                    public void helpRequested(HelpEvent evt) {
                        log.log(Level.FINER, "dialogShell.helpRequested, event=" + String.valueOf(evt));
                        S32Dialog.this.application.openHelpDialog("JLog3", "HelpInfo.html", true);
                    }
                });
                this.dialogShell.addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent paintevent) {
                        if (log.isLoggable(Level.FINEST)) {
                            log.log(Level.FINEST, "dialogShell.paintControl, event=" + String.valueOf(paintevent));
                        }
                        RecordSet activeRecordSet = S32Dialog.this.application.getActiveRecordSet();
                        if (S32Dialog.this.lastActiveRecordSet == null && activeRecordSet != null || activeRecordSet != null && !S32Dialog.this.lastActiveRecordSet.getName().equals(activeRecordSet.getName())) {
                            S32Dialog.this.tabFolder.setSelection(Channels.getInstance().getActiveChannelNumber() - 1);
                        }
                        S32Dialog.this.lastActiveRecordSet = S32Dialog.this.application.getActiveRecordSet();
                    }
                });
                this.tabFolder = new CTabFolder((Composite)this.dialogShell, 0);
                this.tabFolder.setSimple(false);
                FormData tabFolderLData = new FormData();
                tabFolderLData.top = new FormAttachment(0, 1000, 0);
                tabFolderLData.left = new FormAttachment(0, 1000, 0);
                tabFolderLData.right = new FormAttachment(1000, 1000, 0);
                tabFolderLData.bottom = new FormAttachment(1000, 1000, -50);
                this.tabFolder.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.tabFolder.setLayoutData((Object)tabFolderLData);
                for (int i = 1; i <= this.device.getChannelCount(); ++i) {
                    this.createVisualizationTabItem(i, this.device.getNumberOfMeasurements(i));
                }
                this.tabFolder.setSelection(Channels.getInstance().getActiveChannelNumber() - 1);
                this.saveVisualizationButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData saveButtonLData = new FormData();
                saveButtonLData.width = 130;
                saveButtonLData.height = GDE.IS_MAC ? 33 : 30;
                saveButtonLData.left = new FormAttachment(0, 1000, 15);
                saveButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.saveVisualizationButton.setLayoutData((Object)saveButtonLData);
                this.saveVisualizationButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.saveVisualizationButton.setText(Messages.getString((String)"GDE_MSGT3810"));
                this.saveVisualizationButton.setToolTipText(Messages.getString((String)"GDE_MSGT3811"));
                this.saveVisualizationButton.setEnabled(false);
                this.saveVisualizationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "saveButton.widgetSelected, event=" + String.valueOf(evt));
                        S32Dialog.this.device.storeDeviceProperties();
                        S32Dialog.this.saveVisualizationButton.setEnabled(false);
                    }
                });
                this.inputFileButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData inputFileButtonLData = new FormData();
                inputFileButtonLData.width = 130;
                inputFileButtonLData.height = GDE.IS_MAC ? 33 : 30;
                inputFileButtonLData.left = new FormAttachment(0, 1000, 155);
                inputFileButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.inputFileButton.setLayoutData((Object)inputFileButtonLData);
                this.inputFileButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.inputFileButton.setText(Messages.getString((String)"GDE_MSGT3812"));
                this.inputFileButton.setToolTipText(Messages.getString((String)"GDE_MSGT3813"));
                this.inputFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "inputFileButton.widgetSelected, event=" + String.valueOf(evt));
                        if (S32Dialog.this.isVisibilityChanged) {
                            String msg = Messages.getString((String)"GDE_MSGI0041", (Object[])new String[]{S32Dialog.this.device.getPropertiesFileName()});
                            if (S32Dialog.this.application.openYesNoMessageDialog(S32Dialog.this.dialogShell, msg) == 64) {
                                log.log(Level.FINE, "SWT.YES");
                                S32Dialog.this.device.storeDeviceProperties();
                            }
                        }
                        S32Dialog.this.device.open_closeCommPort();
                    }
                });
                this.helpButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData helpButtonLData = new FormData();
                helpButtonLData.width = GDE.IS_LINUX ? 70 : 65;
                helpButtonLData.height = GDE.IS_MAC ? 33 : 30;
                helpButtonLData.left = new FormAttachment(0, 1000, GDE.IS_LINUX ? 332 : 302);
                helpButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.helpButton.setLayoutData((Object)helpButtonLData);
                this.helpButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.helpButton.setImage(SWTResourceManager.getImage((String)"gde/resource/QuestionHot.gif"));
                this.helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "helpButton.widgetSelected, event=" + String.valueOf(evt));
                        S32Dialog.this.application.openHelpDialog("JLog3", "HelpInfo.html", true);
                    }
                });
                this.closeButton = new Button((Composite)this.dialogShell, 0x1000008);
                FormData closeButtonLData = new FormData();
                closeButtonLData.width = 130;
                closeButtonLData.height = GDE.IS_MAC ? 33 : 30;
                closeButtonLData.right = new FormAttachment(1000, 1000, -10);
                closeButtonLData.bottom = new FormAttachment(1000, 1000, GDE.IS_MAC ? -8 : -10);
                this.closeButton.setLayoutData((Object)closeButtonLData);
                this.closeButton.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)GDE.WIDGET_FONT_SIZE, (int)0));
                this.closeButton.setText(Messages.getString((String)"GDE_MSGT0485"));
                this.closeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent evt) {
                        log.log(Level.FINEST, "closeButton.widgetSelected, event=" + String.valueOf(evt));
                        S32Dialog.this.dispose();
                    }
                });
                this.dialogShell.setLocation(this.getParent().toDisplay(this.getParent().getSize().x / 2 - 375, 10));
                this.dialogShell.open();
            } else {
                this.dialogShell.setVisible(true);
                this.dialogShell.setActive();
            }
            Display display = this.dialogShell.getDisplay();
            while (!this.dialogShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void createVisualizationTabItem(int channelNumber, int numMeasurements) {
        this.visualizationTabItem = new CTabItem(this.tabFolder, 0);
        this.visualizationTabItem.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + (GDE.IS_LINUX ? 1 : 0)), (int)0));
        this.visualizationTabItem.setText(this.device.getChannelNameReplacement(channelNumber));
        final ScrolledComposite scolledComposite = new ScrolledComposite((Composite)this.tabFolder, 512);
        scolledComposite.setLayout((Layout)new FillLayout());
        this.visualizationTabItem.setControl((Control)scolledComposite);
        final Composite mainTabComposite = new Composite((Composite)scolledComposite, 0);
        GridLayout mainTabCompositeLayout = new GridLayout();
        mainTabCompositeLayout.makeColumnsEqualWidth = true;
        mainTabCompositeLayout.numColumns = 2;
        mainTabComposite.setLayout((Layout)mainTabCompositeLayout);
        mainTabComposite.setSize(610, 350);
        scolledComposite.setContent((Control)mainTabComposite);
        this.tabItemLabel = new Label(mainTabComposite, 0x1000000);
        GridData tabItemLabelLData = new GridData();
        tabItemLabelLData.grabExcessHorizontalSpace = true;
        tabItemLabelLData.horizontalAlignment = 2;
        tabItemLabelLData.verticalAlignment = 1;
        tabItemLabelLData.heightHint = 18;
        tabItemLabelLData.widthHint = 600;
        tabItemLabelLData.horizontalSpan = 2;
        this.tabItemLabel.setLayoutData((Object)tabItemLabelLData);
        this.tabItemLabel.setFont(SWTResourceManager.getFont((String)GDE.WIDGET_FONT_NAME, (int)(GDE.WIDGET_FONT_SIZE + 2), (int)1));
        this.tabItemLabel.setText(Messages.getString((String)"GDE_MSGT3809"));
        List measurementTypes = this.device.getChannelMeasuremtsReplacedNames(channelNumber);
        for (int i = 0; i < numMeasurements; ++i) {
            this.measurementControls.add((Composite)new MeasurementControlConfigurable(mainTabComposite, (DeviceDialog)this, channelNumber, i, (MeasurementType)measurementTypes.get(i), this.device, 1, " " + i, ""));
        }
        scolledComposite.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent evt) {
                log.log(java.util.logging.Level.FINEST, "scolledComposite.controlResized, event=" + String.valueOf(evt));
                int height = 35 + S32Dialog.this.device.getChannelMeasuremtsReplacedNames(S32Dialog.this.tabFolder.getSelectionIndex() + 1).size() * 28 / 2;
                Channel channel = (Channel)Channels.getInstance().get((Object)(S32Dialog.this.tabFolder.getSelectionIndex() + 1));
                if (channel != null && channel.getActiveRecordSet() != null) {
                    height = 35 + (channel.getActiveRecordSet().size() + 1) * 28 / 2;
                }
                mainTabComposite.setSize(scolledComposite.getClientArea().width, height);
            }

            public void controlMoved(ControlEvent evt) {
                log.log(java.util.logging.Level.FINEST, "scolledComposite.controlMoved, event=" + String.valueOf(evt));
                int height = 35 + S32Dialog.this.device.getChannelMeasuremtsReplacedNames(S32Dialog.this.tabFolder.getSelectionIndex() + 1).size() * 28 / 2;
                Channel channel = (Channel)Channels.getInstance().get((Object)(S32Dialog.this.tabFolder.getSelectionIndex() + 1));
                if (channel != null && channel.getActiveRecordSet() != null) {
                    height = 35 + (channel.getActiveRecordSet().size() + 1) * 28 / 2;
                }
                mainTabComposite.setSize(scolledComposite.getClientArea().width, height);
            }
        });
    }

    public void enableSaveButton(boolean enable) {
        this.saveVisualizationButton.setEnabled(enable);
        this.application.updateAllTabs(true);
    }

    public Integer getTabFolderSelectionIndex() {
        return this.tabFolder.getItemCount() == this.tabFolder.getSelectionIndex() + 1 ? this.tabFolder.getSelectionIndex() - 1 : this.tabFolder.getSelectionIndex();
    }
}

