/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader.datablock;

import com.monstarmike.tlmreader.datablock.AltitudeBlock;
import com.monstarmike.tlmreader.datablock.DataBlock;
import com.monstarmike.tlmreader.primitives.Ints;

public class AltitudeZeroBlock
extends DataBlock {
    private int altOffset;

    public AltitudeZeroBlock(byte[] rawData) {
        super(rawData);
        this.altOffset = Ints.fromBytes(rawData[8], rawData[9], rawData[10], rawData[11]);
        this.measurementNames.add("Altitude Offset");
        this.measurementUnits.add("m");
        this.measurementFactors.add(0.1);
        this.measurementValues.add(this.getAltOffset());
    }

    @Override
    public boolean areValuesEquals(DataBlock block) {
        if (block instanceof AltitudeBlock) {
            AltitudeZeroBlock alt = (AltitudeZeroBlock)block;
            return alt.altOffset == this.altOffset;
        }
        return false;
    }

    public int getAltOffset() {
        return this.altOffset;
    }
}

