/*
 * Decompiled with CFR 0.152.
 */
package com.monstarmike.tlmreader;

import com.monstarmike.tlmreader.datablock.HeaderBlock;
import com.monstarmike.tlmreader.datablock.HeaderNameBlock;
import java.io.BufferedInputStream;
import java.io.IOException;

public abstract class TlmParser {
    int byteCounter;

    public int getNumberOfBytesRead() {
        return this.byteCounter;
    }

    protected void parseStream(BufferedInputStream bufferedStream) throws IOException {
        int flightNumber = -1;
        byte[] headerTest = new byte[4];
        bufferedStream.mark(4);
        while (bufferedStream.read(headerTest, 0, 4) == 4) {
            bufferedStream.reset();
            if (HeaderBlock.isHeaderBlock(headerTest)) {
                byte[] headerBytes = new byte[36];
                this.byteCounter += bufferedStream.read(headerBytes, 0, 36);
                if (HeaderNameBlock.isHeaderName(headerBytes)) {
                    ++flightNumber;
                }
                this.handleHeaderBlock(headerBytes, flightNumber);
            } else {
                byte[] dataBytes = new byte[20];
                this.byteCounter += bufferedStream.read(dataBytes, 0, 20);
                this.handleDataBlock(dataBytes, flightNumber);
            }
            bufferedStream.mark(4);
        }
    }

    protected abstract void handleDataBlock(byte[] var1, int var2);

    protected abstract void handleHeaderBlock(byte[] var1, int var2);
}

