/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.GdiplusStartupInput;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;

public abstract class Device
implements Drawable {
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    Font systemFont;
    int nFonts = 256;
    LOGFONT[] logFonts;
    TEXTMETRIC metrics;
    int[] pixels;
    long[] scripts;
    long[] gdipToken;
    long fontCollection;
    String[] loadedFonts;
    boolean disposed;
    boolean enableAutoScaling = true;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData data2) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (data2 != null) {
                this.debug = data2.debug;
                this.tracking = data2.tracking;
            }
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
                this.trackingLock = new Object();
            }
            this.create(data2);
            this.init();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void addFont(String font) {
        if (this.loadedFonts == null) {
            this.loadedFonts = new String[4];
        }
        int length = this.loadedFonts.length;
        int i2 = 0;
        while (i2 < length) {
            if (font.equals(this.loadedFonts[i2])) {
                return;
            }
            ++i2;
        }
        int index = 0;
        while (index < length) {
            if (this.loadedFonts[index] == null) break;
            ++index;
        }
        if (index == length) {
            String[] temp = new String[length + 4];
            System.arraycopy(this.loadedFonts, 0, temp, 0, length);
            this.loadedFonts = temp;
        }
        this.loadedFonts[index] = font;
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    void checkGDIP() {
        if (this.gdipToken != null) {
            return;
        }
        long[] token = new long[1];
        GdiplusStartupInput input = new GdiplusStartupInput();
        input.GdiplusVersion = 1;
        if (Gdip.GdiplusStartup(token, input, 0L) != 0) {
            SWT.error(2);
        }
        this.gdipToken = token;
        if (this.loadedFonts != null) {
            this.fontCollection = Gdip.PrivateFontCollection_new();
            if (this.fontCollection == 0L) {
                SWT.error(2);
            }
            int i2 = 0;
            while (i2 < this.loadedFonts.length) {
                String path2 = this.loadedFonts[i2];
                if (path2 == null) break;
                int length = path2.length();
                char[] buffer = new char[length + 1];
                path2.getChars(0, length, buffer, 0);
                Gdip.PrivateFontCollection_AddFontFile(this.fontCollection, buffer);
                ++i2;
            }
            this.loadedFonts = null;
        }
    }

    protected void create(DeviceData data2) {
    }

    int computePixels(float height) {
        long hDC = this.internal_new_GC(null);
        int pixels = -((int)(0.5f + height * (float)OS.GetDeviceCaps(hDC, 90) / 72.0f));
        this.internal_dispose_GC(hDC, null);
        return pixels;
    }

    float computePoints(LOGFONT logFont, long hFont) {
        long hDC = this.internal_new_GC(null);
        int logPixelsY = OS.GetDeviceCaps(hDC, 90);
        int pixels = 0;
        if (logFont.lfHeight > 0) {
            long oldFont = OS.SelectObject(hDC, hFont);
            TEXTMETRIC lptm = new TEXTMETRIC();
            OS.GetTextMetrics(hDC, lptm);
            OS.SelectObject(hDC, oldFont);
            pixels = logFont.lfHeight - lptm.tmInternalLeading;
        } else {
            pixels = -logFont.lfHeight;
        }
        this.internal_dispose_GC(hDC, null);
        return (float)pixels * 72.0f / (float)logPixelsY;
    }

    protected void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.isDisposed()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.checkDevice();
            this.release();
            this.destroy();
            this.disposed = true;
            if (this.tracking) {
                Object object = this.trackingLock;
                synchronized (object) {
                    this.printErrors();
                    this.objects = null;
                    this.errors = null;
                    this.trackingLock = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int i2 = 0;
            while (i2 < this.objects.length) {
                if (this.objects[i2] == object) {
                    this.objects[i2] = null;
                    this.errors[i2] = null;
                    return;
                }
                ++i2;
            }
        }
    }

    long EnumFontFamProc(long lpelfe, long lpntme, long FontType, long lParam) {
        boolean scalable;
        boolean isScalable = ((int)FontType & 1) == 0;
        boolean bl = scalable = lParam == 1L;
        if (isScalable == scalable) {
            LOGFONT logFont;
            if (this.nFonts == this.logFonts.length) {
                LOGFONT[] newLogFonts = new LOGFONT[this.logFonts.length + 128];
                System.arraycopy(this.logFonts, 0, newLogFonts, 0, this.nFonts);
                this.logFonts = newLogFonts;
                int[] newPixels = new int[newLogFonts.length];
                System.arraycopy(this.pixels, 0, newPixels, 0, this.nFonts);
                this.pixels = newPixels;
            }
            if ((logFont = this.logFonts[this.nFonts]) == null) {
                logFont = new LOGFONT();
            }
            OS.MoveMemory(logFont, lpelfe, LOGFONT.sizeof);
            this.logFonts[this.nFonts] = logFont;
            if (logFont.lfHeight > 0) {
                OS.MoveMemory(this.metrics, lpntme, TEXTMETRIC.sizeof);
                this.pixels[this.nFonts] = logFont.lfHeight - this.metrics.tmInternalLeading;
            } else {
                this.pixels[this.nFonts] = -logFont.lfHeight;
            }
            ++this.nFonts;
        }
        return 1L;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    private Rectangle getBoundsInPixels() {
        long hDC = this.internal_new_GC(null);
        int width = OS.GetDeviceCaps(hDC, 8);
        int height = OS.GetDeviceCaps(hDC, 10);
        this.internal_dispose_GC(hDC, null);
        return new Rectangle(0, 0, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData data2 = new DeviceData();
        data2.debug = this.debug;
        data2.tracking = this.tracking;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                int count = 0;
                int length = this.objects.length;
                int i2 = 0;
                while (i2 < length) {
                    if (this.objects[i2] != null) {
                        ++count;
                    }
                    ++i2;
                }
                int index = 0;
                data2.objects = new Object[count];
                data2.errors = new Error[count];
                int i3 = 0;
                while (i3 < length) {
                    if (this.objects[i3] != null) {
                        data2.objects[index] = this.objects[i3];
                        data2.errors[index] = this.errors[i3];
                        ++index;
                    }
                    ++i3;
                }
            }
        } else {
            data2.objects = new Object[0];
            data2.errors = new Error[0];
        }
        return data2;
    }

    public Rectangle getClientArea() {
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        long hDC = this.internal_new_GC(null);
        int bits = OS.GetDeviceCaps(hDC, 12);
        int planes = OS.GetDeviceCaps(hDC, 14);
        this.internal_dispose_GC(hDC, null);
        return bits * planes;
    }

    public Point getDPI() {
        this.checkDevice();
        long hDC = this.internal_new_GC(null);
        int dpiX = OS.GetDeviceCaps(hDC, 88);
        int dpiY = OS.GetDeviceCaps(hDC, 90);
        this.internal_dispose_GC(hDC, null);
        return DPIUtil.autoScaleDown(new Point(dpiX, dpiY));
    }

    int _getDPIx() {
        long hDC = this.internal_new_GC(null);
        int dpi = OS.GetDeviceCaps(hDC, 88);
        this.internal_dispose_GC(hDC, null);
        return dpi;
    }

    public FontData[] getFontList(String faceName, boolean scalable) {
        this.checkDevice();
        Callback callback = new Callback(this, "EnumFontFamProc", 4);
        long lpEnumFontFamProc = callback.getAddress();
        if (lpEnumFontFamProc == 0L) {
            SWT.error(3);
        }
        this.metrics = new TEXTMETRIC();
        this.pixels = new int[this.nFonts];
        this.logFonts = new LOGFONT[this.nFonts];
        int i2 = 0;
        while (i2 < this.logFonts.length) {
            this.logFonts[i2] = new LOGFONT();
            ++i2;
        }
        this.nFonts = 0;
        int offset = 0;
        long hDC = this.internal_new_GC(null);
        if (faceName == null) {
            OS.EnumFontFamilies(hDC, null, lpEnumFontFamProc, scalable ? 1 : 0);
            offset = this.nFonts;
            int i3 = 0;
            while (i3 < offset) {
                LOGFONT lf = this.logFonts[i3];
                OS.EnumFontFamilies(hDC, lf.lfFaceName, lpEnumFontFamProc, scalable ? 1 : 0);
                ++i3;
            }
        } else {
            TCHAR lpFaceName = new TCHAR(0, faceName, true);
            OS.EnumFontFamilies(hDC, lpFaceName.chars, lpEnumFontFamProc, scalable ? 1 : 0);
        }
        int logPixelsY = OS.GetDeviceCaps(hDC, 90);
        this.internal_dispose_GC(hDC, null);
        int count = 0;
        FontData[] result2 = new FontData[this.nFonts - offset];
        int i4 = offset;
        while (i4 < this.nFonts) {
            FontData fd = FontData.win32_new(this.logFonts[i4], (float)this.pixels[i4] * 72.0f / (float)logPixelsY);
            int j2 = 0;
            while (j2 < count) {
                if (fd.equals(result2[j2])) break;
                ++j2;
            }
            if (j2 == count) {
                result2[count++] = fd;
            }
            ++i4;
        }
        if (count != result2.length) {
            FontData[] newResult = new FontData[count];
            System.arraycopy(result2, 0, newResult, 0, count);
            result2 = newResult;
        }
        callback.dispose();
        this.logFonts = null;
        this.pixels = null;
        this.metrics = null;
        return result2;
    }

    String getLastError() {
        int error2 = OS.GetLastError();
        if (error2 == 0) {
            return "";
        }
        return " [GetLastError=0x" + Integer.toHexString(error2) + "]";
    }

    String getLastErrorText() {
        int error2 = OS.GetLastError();
        if (error2 == 0) {
            return "";
        }
        int dwFlags = 4864;
        long[] buffer = new long[1];
        int length = OS.FormatMessage(dwFlags, 0L, error2, 1024, buffer, 0, 0L);
        if (length == 0) {
            return " [GetLastError=0x" + Integer.toHexString(error2) + "]";
        }
        char[] buffer1 = new char[length];
        OS.MoveMemory(buffer1, buffer[0], length * 2);
        if (buffer[0] != 0L) {
            OS.LocalFree(buffer[0]);
        }
        return new String(buffer1);
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        int pixel = 0;
        int alpha = 255;
        switch (id) {
            case 37: {
                alpha = 0;
            }
            case 1: {
                pixel = 0xFFFFFF;
                break;
            }
            case 2: {
                pixel = 0;
                break;
            }
            case 3: {
                pixel = 255;
                break;
            }
            case 4: {
                pixel = 128;
                break;
            }
            case 5: {
                pixel = 65280;
                break;
            }
            case 6: {
                pixel = 32768;
                break;
            }
            case 7: {
                pixel = 65535;
                break;
            }
            case 8: {
                pixel = 32896;
                break;
            }
            case 9: {
                pixel = 0xFF0000;
                break;
            }
            case 10: {
                pixel = 0x800000;
                break;
            }
            case 11: {
                pixel = 0xFF00FF;
                break;
            }
            case 12: {
                pixel = 0x800080;
                break;
            }
            case 13: {
                pixel = 0xFFFF00;
                break;
            }
            case 14: {
                pixel = 0x808000;
                break;
            }
            case 15: {
                pixel = 0xC0C0C0;
                break;
            }
            case 16: {
                pixel = 0x808080;
            }
        }
        return Color.win32_new(this, pixel, alpha);
    }

    public Font getSystemFont() {
        this.checkDevice();
        long hFont = OS.GetStockObject(13);
        return Font.win32_new(this, hFont);
    }

    public boolean getWarnings() {
        this.checkDevice();
        return false;
    }

    protected void init() {
        if (this.debug) {
            OS.GdiSetBatchLimit(1);
        }
        this.systemFont = this.getSystemFont();
        long[] ppSp = new long[1];
        int[] piNumScripts = new int[1];
        OS.ScriptGetProperties(ppSp, piNumScripts);
        this.scripts = new long[piNumScripts[0]];
        OS.MoveMemory(this.scripts, ppSp[0], this.scripts.length * C.PTR_SIZEOF);
    }

    @Override
    public abstract long internal_new_GC(GCData var1);

    @Override
    public abstract void internal_dispose_GC(long var1, GCData var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.disposed;
        }
    }

    public boolean loadFont(String path2) {
        TCHAR lpszFilename;
        boolean loaded;
        this.checkDevice();
        if (path2 == null) {
            SWT.error(4);
        }
        boolean bl = loaded = OS.AddFontResourceEx(lpszFilename = new TCHAR(0, path2, true), 16, 0L) != 0L;
        if (loaded) {
            if (this.gdipToken != null) {
                if (this.fontCollection == 0L) {
                    this.fontCollection = Gdip.PrivateFontCollection_new();
                    if (this.fontCollection == 0L) {
                        SWT.error(2);
                    }
                }
                int length = path2.length();
                char[] buffer = new char[length + 1];
                path2.getChars(0, length, buffer, 0);
                Gdip.PrivateFontCollection_AddFontFile(this.fontCollection, buffer);
            } else {
                this.addFont(path2);
            }
        }
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int i2 = 0;
            while (i2 < this.objects.length) {
                if (this.objects[i2] == null) {
                    this.objects[i2] = object;
                    this.errors[i2] = new Error();
                    return;
                }
                ++i2;
            }
            Object[] newObjects = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, newObjects, 0, this.objects.length);
            newObjects[this.objects.length] = object;
            this.objects = newObjects;
            Error[] newErrors = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, newErrors, 0, this.errors.length);
            newErrors[this.errors.length] = new Error();
            this.errors = newErrors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printErrors() {
        if (!DEBUG) {
            return;
        }
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                if (this.objects == null || this.errors == null) {
                    return;
                }
                int objectCount = 0;
                int colors = 0;
                int cursors = 0;
                int fonts = 0;
                int gcs = 0;
                int images = 0;
                int paths = 0;
                int patterns = 0;
                int regions = 0;
                int textLayouts = 0;
                int transforms = 0;
                int i2 = 0;
                while (i2 < this.objects.length) {
                    Object object2 = this.objects[i2];
                    if (object2 != null) {
                        ++objectCount;
                        if (object2 instanceof Color) {
                            ++colors;
                        }
                        if (object2 instanceof Cursor) {
                            ++cursors;
                        }
                        if (object2 instanceof Font) {
                            ++fonts;
                        }
                        if (object2 instanceof GC) {
                            ++gcs;
                        }
                        if (object2 instanceof Image) {
                            ++images;
                        }
                        if (object2 instanceof Path) {
                            ++paths;
                        }
                        if (object2 instanceof Pattern) {
                            ++patterns;
                        }
                        if (object2 instanceof Region) {
                            ++regions;
                        }
                        if (object2 instanceof TextLayout) {
                            ++textLayouts;
                        }
                        if (object2 instanceof Transform) {
                            ++transforms;
                        }
                    }
                    ++i2;
                }
                if (objectCount != 0) {
                    String string2 = "Summary: ";
                    if (colors != 0) {
                        string2 = String.valueOf(string2) + colors + " Color(s), ";
                    }
                    if (cursors != 0) {
                        string2 = String.valueOf(string2) + cursors + " Cursor(s), ";
                    }
                    if (fonts != 0) {
                        string2 = String.valueOf(string2) + fonts + " Font(s), ";
                    }
                    if (gcs != 0) {
                        string2 = String.valueOf(string2) + gcs + " GC(s), ";
                    }
                    if (images != 0) {
                        string2 = String.valueOf(string2) + images + " Image(s), ";
                    }
                    if (paths != 0) {
                        string2 = String.valueOf(string2) + paths + " Path(s), ";
                    }
                    if (patterns != 0) {
                        string2 = String.valueOf(string2) + patterns + " Pattern(s), ";
                    }
                    if (regions != 0) {
                        string2 = String.valueOf(string2) + regions + " Region(s), ";
                    }
                    if (textLayouts != 0) {
                        string2 = String.valueOf(string2) + textLayouts + " TextLayout(s), ";
                    }
                    if (transforms != 0) {
                        string2 = String.valueOf(string2) + transforms + " Transforms(s), ";
                    }
                    if (string2.length() != 0) {
                        string2 = string2.substring(0, string2.length() - 2);
                        System.err.println(string2);
                    }
                    int i3 = 0;
                    while (i3 < this.errors.length) {
                        if (this.errors[i3] != null) {
                            this.errors[i3].printStackTrace(System.err);
                        }
                        ++i3;
                    }
                }
            }
        }
    }

    protected void release() {
        if (this.gdipToken != null) {
            if (this.fontCollection != 0L) {
                Gdip.PrivateFontCollection_delete(this.fontCollection);
            }
            this.fontCollection = 0L;
            Gdip.GdiplusShutdown(this.gdipToken[0]);
        }
        this.gdipToken = null;
        this.scripts = null;
        this.logFonts = null;
        this.nFonts = 0;
    }

    public void setWarnings(boolean warnings) {
        this.checkDevice();
    }

    boolean getEnableAutoScaling() {
        return this.enableAutoScaling;
    }

    void setEnableAutoScaling(boolean value) {
        this.enableAutoScaling = value;
    }

    protected int getDeviceZoom() {
        return DPIUtil.mapDPIToZoom(this._getDPIx());
    }
}

