/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Image;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.TabStop;
import com.itextpdf.text.pdf.PdfChunk;
import com.itextpdf.text.pdf.PdfFont;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfLine {
    protected ArrayList<PdfChunk> line;
    protected float left;
    protected float width;
    protected int alignment;
    protected float height;
    protected boolean newlineSplit = false;
    protected float originalWidth;
    protected boolean isRTL = false;
    protected ListItem listItem = null;
    protected TabStop tabStop = null;
    protected float tabStopAnchorPosition = Float.NaN;
    protected float tabPosition = Float.NaN;

    PdfLine(float left2, float right2, int alignment, float height) {
        this.left = left2;
        this.originalWidth = this.width = right2 - left2;
        this.alignment = alignment;
        this.height = height;
        this.line = new ArrayList();
    }

    PdfLine(float left2, float originalWidth, float remainingWidth, int alignment, boolean newlineSplit, ArrayList<PdfChunk> line2, boolean isRTL) {
        this.left = left2;
        this.originalWidth = originalWidth;
        this.width = remainingWidth;
        this.alignment = alignment;
        this.line = line2;
        this.newlineSplit = newlineSplit;
        this.isRTL = isRTL;
    }

    PdfChunk add(PdfChunk chunk, float currentLeading) {
        if (chunk != null && !chunk.toString().equals("") && !chunk.toString().equals(" ") && (this.height < currentLeading || this.line.isEmpty())) {
            this.height = currentLeading;
        }
        return this.add(chunk);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    PdfChunk add(PdfChunk chunk) {
        if (chunk == null || chunk.toString().equals("")) {
            return null;
        }
        PdfChunk overflow = chunk.split(this.width);
        boolean bl = this.newlineSplit = chunk.isNewlineSplit() || overflow == null;
        if (chunk.isTab()) {
            Object[] tab2 = (Object[])chunk.getAttribute("TAB");
            if (chunk.isAttribute("TABSETTINGS")) {
                boolean isWhiteSpace = (Boolean)tab2[1];
                if (isWhiteSpace && this.line.isEmpty()) return null;
                this.flush();
                this.tabStopAnchorPosition = Float.NaN;
                this.tabStop = PdfChunk.getTabStop(chunk, this.originalWidth - this.width);
                if (this.tabStop.getPosition() > this.originalWidth) {
                    if (isWhiteSpace) {
                        overflow = null;
                    } else if ((double)Math.abs(this.originalWidth - this.width) < 0.001) {
                        this.addToLine(chunk);
                        overflow = null;
                    } else {
                        overflow = chunk;
                    }
                    this.width = 0.0f;
                    return overflow;
                } else {
                    chunk.setTabStop(this.tabStop);
                    if (!this.isRTL && this.tabStop.getAlignment() == TabStop.Alignment.LEFT) {
                        this.width = this.originalWidth - this.tabStop.getPosition();
                        this.tabStop = null;
                        this.tabPosition = Float.NaN;
                    } else {
                        this.tabPosition = this.originalWidth - this.width;
                    }
                    this.addToLine(chunk);
                }
                return overflow;
            } else {
                Float tabStopPosition = Float.valueOf(((Float)tab2[1]).floatValue());
                boolean newline = (Boolean)tab2[2];
                if (newline && tabStopPosition.floatValue() < this.originalWidth - this.width) {
                    return chunk;
                }
                chunk.adjustLeft(this.left);
                this.width = this.originalWidth - tabStopPosition.floatValue();
                this.addToLine(chunk);
            }
            return overflow;
        } else if (chunk.length() > 0 || chunk.isImage()) {
            if (overflow != null) {
                chunk.trimLastSpace();
            }
            this.width -= chunk.width();
            this.addToLine(chunk);
            return overflow;
        } else {
            if (this.line.size() < 1) {
                chunk = overflow;
                overflow = chunk.truncate(this.width);
                this.width -= chunk.width();
                if (chunk.length() > 0) {
                    this.addToLine(chunk);
                    return overflow;
                }
                if (overflow == null) return null;
                this.addToLine(overflow);
                return null;
            }
            this.width += this.line.get(this.line.size() - 1).trimLastSpace();
        }
        return overflow;
    }

    private void addToLine(PdfChunk chunk) {
        String value;
        int anchorIndex;
        if (chunk.changeLeading) {
            float f2;
            if (chunk.isImage()) {
                Image img = chunk.getImage();
                f2 = chunk.getImageHeight() + chunk.getImageOffsetY() + img.getBorderWidthTop() + img.getSpacingBefore();
            } else {
                f2 = chunk.getLeading();
            }
            if (f2 > this.height) {
                this.height = f2;
            }
        }
        if (this.tabStop != null && this.tabStop.getAlignment() == TabStop.Alignment.ANCHOR && Float.isNaN(this.tabStopAnchorPosition) && (anchorIndex = (value = chunk.toString()).indexOf(this.tabStop.getAnchorChar())) != -1) {
            float subWidth = chunk.width(value.substring(anchorIndex, value.length()));
            this.tabStopAnchorPosition = this.originalWidth - this.width - subWidth;
        }
        this.line.add(chunk);
    }

    public int size() {
        return this.line.size();
    }

    public Iterator<PdfChunk> iterator() {
        return this.line.iterator();
    }

    float height() {
        return this.height;
    }

    float indentLeft() {
        if (this.isRTL) {
            switch (this.alignment) {
                case 1: {
                    return this.left + this.width / 2.0f;
                }
                case 2: {
                    return this.left;
                }
                case 3: {
                    return this.left + (this.hasToBeJustified() ? 0.0f : this.width);
                }
            }
            return this.left + this.width;
        }
        if (this.getSeparatorCount() <= 0) {
            switch (this.alignment) {
                case 2: {
                    return this.left + this.width;
                }
                case 1: {
                    return this.left + this.width / 2.0f;
                }
            }
        }
        return this.left;
    }

    public boolean hasToBeJustified() {
        return (this.alignment == 3 && !this.newlineSplit || this.alignment == 8) && this.width != 0.0f;
    }

    public void resetAlignment() {
        if (this.alignment == 3) {
            this.alignment = 0;
        }
    }

    void setExtraIndent(float extra) {
        this.left += extra;
        this.width -= extra;
        this.originalWidth -= extra;
    }

    float widthLeft() {
        return this.width;
    }

    int numberOfSpaces() {
        int numberOfSpaces = 0;
        for (PdfChunk pdfChunk : this.line) {
            String tmp = pdfChunk.toString();
            int length = tmp.length();
            for (int i2 = 0; i2 < length; ++i2) {
                if (tmp.charAt(i2) != ' ') continue;
                ++numberOfSpaces;
            }
        }
        return numberOfSpaces;
    }

    public void setListItem(ListItem listItem) {
        this.listItem = listItem;
    }

    public Chunk listSymbol() {
        return this.listItem != null ? this.listItem.getListSymbol() : null;
    }

    public float listIndent() {
        return this.listItem != null ? this.listItem.getIndentationLeft() : 0.0f;
    }

    public ListItem listItem() {
        return this.listItem;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer();
        for (PdfChunk pdfChunk : this.line) {
            tmp.append(pdfChunk.toString());
        }
        return tmp.toString();
    }

    public int getLineLengthUtf32() {
        int total = 0;
        for (PdfChunk element : this.line) {
            total += element.lengthUtf32();
        }
        return total;
    }

    public boolean isNewlineSplit() {
        return this.newlineSplit && this.alignment != 8;
    }

    public int getLastStrokeChunk() {
        PdfChunk chunk;
        int lastIdx;
        for (lastIdx = this.line.size() - 1; lastIdx >= 0 && !(chunk = this.line.get(lastIdx)).isStroked(); --lastIdx) {
        }
        return lastIdx;
    }

    public PdfChunk getChunk(int idx) {
        if (idx < 0 || idx >= this.line.size()) {
            return null;
        }
        return this.line.get(idx);
    }

    public float getOriginalWidth() {
        return this.originalWidth;
    }

    float[] getMaxSize(float fixedLeading, float multipliedLeading) {
        float normal_leading = 0.0f;
        float image_leading = -10000.0f;
        for (int k2 = 0; k2 < this.line.size(); ++k2) {
            PdfChunk chunk = this.line.get(k2);
            if (chunk.isImage()) {
                Image img = chunk.getImage();
                if (!chunk.changeLeading()) continue;
                float height = chunk.getImageHeight() + chunk.getImageOffsetY() + img.getSpacingBefore();
                image_leading = Math.max(height, image_leading);
                continue;
            }
            normal_leading = chunk.changeLeading() ? Math.max(chunk.getLeading(), normal_leading) : Math.max(fixedLeading + multipliedLeading * chunk.font().size(), normal_leading);
        }
        return new float[]{normal_leading > 0.0f ? normal_leading : fixedLeading, image_leading};
    }

    boolean isRTL() {
        return this.isRTL;
    }

    int getSeparatorCount() {
        int s2 = 0;
        for (PdfChunk element : this.line) {
            PdfChunk ck = element;
            if (ck.isTab()) {
                if (ck.isAttribute("TABSETTINGS")) continue;
                return -1;
            }
            if (!ck.isHorizontalSeparator()) continue;
            ++s2;
        }
        return s2;
    }

    public float getWidthCorrected(float charSpacing, float wordSpacing) {
        float total = 0.0f;
        for (int k2 = 0; k2 < this.line.size(); ++k2) {
            PdfChunk ck = this.line.get(k2);
            total += ck.getWidthCorrected(charSpacing, wordSpacing);
        }
        return total;
    }

    public float getAscender() {
        float ascender = 0.0f;
        for (int k2 = 0; k2 < this.line.size(); ++k2) {
            PdfChunk ck = this.line.get(k2);
            if (ck.isImage()) {
                ascender = Math.max(ascender, ck.getImageHeight() + ck.getImageOffsetY());
                continue;
            }
            PdfFont font = ck.font();
            float textRise = ck.getTextRise();
            ascender = Math.max(ascender, (textRise > 0.0f ? textRise : 0.0f) + font.getFont().getFontDescriptor(1, font.size()));
        }
        return ascender;
    }

    public float getDescender() {
        float descender = 0.0f;
        for (int k2 = 0; k2 < this.line.size(); ++k2) {
            PdfChunk ck = this.line.get(k2);
            if (ck.isImage()) {
                descender = Math.min(descender, ck.getImageOffsetY());
                continue;
            }
            PdfFont font = ck.font();
            float textRise = ck.getTextRise();
            descender = Math.min(descender, (textRise < 0.0f ? textRise : 0.0f) + font.getFont().getFontDescriptor(3, font.size()));
        }
        return descender;
    }

    public void flush() {
        if (this.tabStop != null) {
            float textWidth = this.originalWidth - this.width - this.tabPosition;
            float tabStopPosition = this.tabStop.getPosition(this.tabPosition, this.originalWidth - this.width, this.tabStopAnchorPosition);
            this.width = this.originalWidth - tabStopPosition - textWidth;
            if (this.width < 0.0f) {
                tabStopPosition += this.width;
            }
            if (!this.isRTL) {
                this.tabStop.setPosition(tabStopPosition);
            } else {
                this.tabStop.setPosition(this.originalWidth - this.width - this.tabPosition);
            }
            this.tabStop = null;
            this.tabPosition = Float.NaN;
        }
    }
}

