/**
* Project: VSXu: Realtime modular visual programming engine.
*
* This file is part of Vovoid VSXu.
*
* @author Jonatan Wallmander, Robert Wenzel, Vovoid Media Technologies AB Copyright (C) 2003-2013
* @see The GNU Lesser General Public License (LGPL)
*
* VSXu Engine is free software; you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
* or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
* for more details.
*
* You should have received a copy of the GNU Lesser General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/


class module_float_array_pick : public vsx_module
{
  // in
  vsx_module_param_float_array* float_in;
  vsx_module_param_float* which;

  // out
  vsx_module_param_float* result_float;

  // internal
  vsx_float_array* my_array;

public:

  void module_info(vsx_module_specification* info)
  {
    info->identifier =
      "maths;array;float_array_pick";

    info->description =
      "picks the value from the array/list\n"
      "and delivers it as out parameter"
    ;

    info->in_param_spec =
      "float_in:float_array,"
      "which:float"
    ;

    info->out_param_spec =
      "result_float:float";

    info->component_class =
      "parameters";
  }

  void declare_params(vsx_module_param_list& in_parameters, vsx_module_param_list& out_parameters)
  {
    loading_done = true;

    //--------------------------------------------------------------------------------------------------

    float_in = (vsx_module_param_float_array*)in_parameters.create(VSX_MODULE_PARAM_ID_FLOAT_ARRAY,"float_in");

    which = (vsx_module_param_float*)in_parameters.create(VSX_MODULE_PARAM_ID_FLOAT,"which");
    which->set(0);

    //--------------------------------------------------------------------------------------------------

    result_float = (vsx_module_param_float*)out_parameters.create(VSX_MODULE_PARAM_ID_FLOAT,"result_float");
    result_float->set(0);
  }

  void run()
  {
    my_array = float_in->get_addr();

    if (!my_array)
      return;

    if ( which->get() < 0.0f )
      return;

    if ( (size_t)which->get() >= my_array->data->size() )
      return;

    size_t index = (size_t)which->get();

    result_float->set(
      (*(my_array->data))[ index ]
    );
  }

};
