/* This file has been generated by the Perl script `afblue.pl', */
/* using data from file `afblue.dat'.                           */

/***************************************************************************/
/*                                                                         */
/*  afblue.h                                                               */
/*                                                                         */
/*    Auto-fitter data for blue strings (specification).                   */
/*                                                                         */
/*  Copyright 2013-2016 by                                                 */
/*  David Turner, Robert Wilhelm, and Werner Lemberg.                      */
/*                                                                         */
/*  This file is part of the FreeType project, and may only be used,       */
/*  modified, and distributed under the terms of the FreeType project      */
/*  license, LICENSE.TXT.  By continuing to use, modify, or distribute     */
/*  this file you indicate that you have read the license and              */
/*  understand and accept it fully.                                        */
/*                                                                         */
/***************************************************************************/


#ifndef AFBLUE_H_
#define AFBLUE_H_


FT_BEGIN_HEADER


  /* an auxiliary macro to decode a UTF-8 character -- since we only use */
  /* hard-coded, self-converted data, no error checking is performed     */
#define GET_UTF8_CHAR( ch, p )                      \
          do                                        \
          {                                         \
            ch = (unsigned char)*p++;               \
            if ( ch >= 0x80 )                       \
            {                                       \
              FT_UInt  len_;                        \
                                                    \
                                                    \
              if ( ch < 0xE0 )                      \
              {                                     \
                len_ = 1;                           \
                ch  &= 0x1F;                        \
              }                                     \
              else if ( ch < 0xF0 )                 \
              {                                     \
                len_ = 2;                           \
                ch  &= 0x0F;                        \
              }                                     \
              else                                  \
              {                                     \
                len_ = 3;                           \
                ch  &= 0x07;                        \
              }                                     \
                                                    \
              for ( ; len_ > 0; len_-- )            \
                ch = ( ch << 6 ) | ( *p++ & 0x3F ); \
            }                                       \
          } while ( 0 )


  /*************************************************************************/
  /*************************************************************************/
  /*****                                                               *****/
  /*****                    B L U E   S T R I N G S                    *****/
  /*****                                                               *****/
  /*************************************************************************/
  /*************************************************************************/

  /* At the bottommost level, we define strings for finding blue zones. */


#define AF_BLUE_STRING_MAX_LEN  51

  /* The AF_Blue_String enumeration values are offsets into the */
  /* `af_blue_strings' array.                                   */

  typedef enum  AF_Blue_String_
  {
    AF_BLUE_STRING_ARABIC_TOP = 0,
    AF_BLUE_STRING_ARABIC_BOTTOM = 18,
    AF_BLUE_STRING_ARABIC_JOIN = 33,
    AF_BLUE_STRING_BENGALI_BASE = 36,
    AF_BLUE_STRING_BENGALI_TOP = 68,
    AF_BLUE_STRING_BENGALI_HEAD = 96,
    AF_BLUE_STRING_CYRILLIC_CAPITAL_TOP = 128,
    AF_BLUE_STRING_CYRILLIC_CAPITAL_BOTTOM = 152,
    AF_BLUE_STRING_CYRILLIC_SMALL = 176,
    AF_BLUE_STRING_CYRILLIC_SMALL_DESCENDER = 200,
    AF_BLUE_STRING_DEVANAGARI_BASE = 209,
    AF_BLUE_STRING_DEVANAGARI_TOP = 241,
    AF_BLUE_STRING_DEVANAGARI_HEAD = 273,
    AF_BLUE_STRING_DEVANAGARI_BOTTOM = 305,
    AF_BLUE_STRING_GEORGIAN_MKHEDRULI_TOP = 313,
    AF_BLUE_STRING_GEORGIAN_MKHEDRULI_BOTTOM = 345,
    AF_BLUE_STRING_GEORGIAN_MKHEDRULI_ASCENDER = 377,
    AF_BLUE_STRING_GEORGIAN_MKHEDRULI_DESCENDER = 409,
    AF_BLUE_STRING_GEORGIAN_ASOMTAVRULI_TOP = 441,
    AF_BLUE_STRING_GEORGIAN_ASOMTAVRULI_BOTTOM = 473,
    AF_BLUE_STRING_GEORGIAN_NUSKHURI_TOP = 505,
    AF_BLUE_STRING_GEORGIAN_NUSKHURI_BOTTOM = 537,
    AF_BLUE_STRING_GEORGIAN_NUSKHURI_ASCENDER = 569,
    AF_BLUE_STRING_GEORGIAN_NUSKHURI_DESCENDER = 601,
    AF_BLUE_STRING_GREEK_CAPITAL_TOP = 633,
    AF_BLUE_STRING_GREEK_CAPITAL_BOTTOM = 654,
    AF_BLUE_STRING_GREEK_SMALL_BETA_TOP = 672,
    AF_BLUE_STRING_GREEK_SMALL = 690,
    AF_BLUE_STRING_GREEK_SMALL_DESCENDER = 714,
    AF_BLUE_STRING_GUJARATI_TOP = 738,
    AF_BLUE_STRING_GUJARATI_BOTTOM = 770,
    AF_BLUE_STRING_GUJARATI_ASCENDER = 802,
    AF_BLUE_STRING_GUJARATI_DESCENDER = 852,
    AF_BLUE_STRING_GUJARATI_DIGIT_TOP = 885,
    AF_BLUE_STRING_HEBREW_TOP = 905,
    AF_BLUE_STRING_HEBREW_BOTTOM = 929,
    AF_BLUE_STRING_HEBREW_DESCENDER = 947,
    AF_BLUE_STRING_KANNADA_TOP = 962,
    AF_BLUE_STRING_KANNADA_BOTTOM = 1006,
    AF_BLUE_STRING_KHMER_TOP = 1038,
    AF_BLUE_STRING_KHMER_SUBSCRIPT_TOP = 1062,
    AF_BLUE_STRING_KHMER_BOTTOM = 1102,
    AF_BLUE_STRING_KHMER_DESCENDER = 1134,
    AF_BLUE_STRING_KHMER_LARGE_DESCENDER = 1168,
    AF_BLUE_STRING_KHMER_SYMBOLS_WAXING_TOP = 1255,
    AF_BLUE_STRING_KHMER_SYMBOLS_WANING_BOTTOM = 1263,
    AF_BLUE_STRING_LAO_TOP = 1271,
    AF_BLUE_STRING_LAO_BOTTOM = 1303,
    AF_BLUE_STRING_LAO_ASCENDER = 1335,
    AF_BLUE_STRING_LAO_LARGE_ASCENDER = 1351,
    AF_BLUE_STRING_LAO_DESCENDER = 1363,
    AF_BLUE_STRING_LATIN_CAPITAL_TOP = 1387,
    AF_BLUE_STRING_LATIN_CAPITAL_BOTTOM = 1403,
    AF_BLUE_STRING_LATIN_SMALL_F_TOP = 1419,
    AF_BLUE_STRING_LATIN_SMALL = 1433,
    AF_BLUE_STRING_LATIN_SMALL_DESCENDER = 1447,
    AF_BLUE_STRING_LATIN_SUBS_CAPITAL_TOP = 1457,
    AF_BLUE_STRING_LATIN_SUBS_CAPITAL_BOTTOM = 1477,
    AF_BLUE_STRING_LATIN_SUBS_SMALL_F_TOP = 1497,
    AF_BLUE_STRING_LATIN_SUBS_SMALL = 1517,
    AF_BLUE_STRING_LATIN_SUBS_SMALL_DESCENDER = 1553,
    AF_BLUE_STRING_LATIN_SUPS_CAPITAL_TOP = 1573,
    AF_BLUE_STRING_LATIN_SUPS_CAPITAL_BOTTOM = 1604,
    AF_BLUE_STRING_LATIN_SUPS_SMALL_F_TOP = 1633,
    AF_BLUE_STRING_LATIN_SUPS_SMALL = 1659,
    AF_BLUE_STRING_LATIN_SUPS_SMALL_DESCENDER = 1684,
    AF_BLUE_STRING_MALAYALAM_TOP = 1695,
    AF_BLUE_STRING_MALAYALAM_BOTTOM = 1739,
    AF_BLUE_STRING_MYANMAR_TOP = 1771,
    AF_BLUE_STRING_MYANMAR_BOTTOM = 1803,
    AF_BLUE_STRING_MYANMAR_ASCENDER = 1835,
    AF_BLUE_STRING_MYANMAR_DESCENDER = 1863,
    AF_BLUE_STRING_SINHALA_TOP = 1895,
    AF_BLUE_STRING_SINHALA_BOTTOM = 1927,
    AF_BLUE_STRING_SINHALA_DESCENDER = 1959,
    AF_BLUE_STRING_TAMIL_TOP = 2003,
    AF_BLUE_STRING_TAMIL_BOTTOM = 2035,
    AF_BLUE_STRING_TELUGU_TOP = 2067,
    AF_BLUE_STRING_TELUGU_BOTTOM = 2095,
    AF_BLUE_STRING_THAI_TOP = 2123,
    AF_BLUE_STRING_THAI_BOTTOM = 2147,
    AF_BLUE_STRING_THAI_ASCENDER = 2175,
    AF_BLUE_STRING_THAI_LARGE_ASCENDER = 2187,
    AF_BLUE_STRING_THAI_DESCENDER = 2199,
    AF_BLUE_STRING_THAI_LARGE_DESCENDER = 2215,
    AF_BLUE_STRING_THAI_DIGIT_TOP = 2223,
    af_blue_1_1 = 2234,
#ifdef AF_CONFIG_OPTION_CJK
    AF_BLUE_STRING_CJK_TOP = af_blue_1_1 + 1,
    AF_BLUE_STRING_CJK_BOTTOM = af_blue_1_1 + 203,
    af_blue_1_1_1 = af_blue_1_1 + 404,
#ifdef AF_CONFIG_OPTION_CJK_BLUE_HANI_VERT
    AF_BLUE_STRING_CJK_LEFT = af_blue_1_1_1 + 1,
    AF_BLUE_STRING_CJK_RIGHT = af_blue_1_1_1 + 204,
    af_blue_1_1_2 = af_blue_1_1_1 + 405,
#else
    af_blue_1_1_2 = af_blue_1_1_1 + 0,
#endif /* AF_CONFIG_OPTION_CJK_BLUE_HANI_VERT */
    af_blue_1_2 = af_blue_1_1_2 + 0,
#else
    af_blue_1_2 = af_blue_1_1 + 0,
#endif /* AF_CONFIG_OPTION_CJK                */


    AF_BLUE_STRING_MAX   /* do not remove */

  } AF_Blue_String;


  FT_LOCAL_ARRAY( char )
  af_blue_strings[];


  /*************************************************************************/
  /*************************************************************************/
  /*****                                                               *****/
  /*****                 B L U E   S T R I N G S E T S                 *****/
  /*****                                                               *****/
  /*************************************************************************/
  /*************************************************************************/

  /* The next level is to group blue strings into style-specific sets. */


  /* Properties are specific to a writing system.  We assume that a given  */
  /* blue string can't be used in more than a single writing system, which */
  /* is a safe bet.                                                        */
#define AF_BLUE_PROPERTY_LATIN_TOP       ( 1U << 0 )  /* must have value 1 */
#define AF_BLUE_PROPERTY_LATIN_SUB_TOP   ( 1U << 1 )
#define AF_BLUE_PROPERTY_LATIN_NEUTRAL   ( 1U << 2 )
#define AF_BLUE_PROPERTY_LATIN_X_HEIGHT  ( 1U << 3 )
#define AF_BLUE_PROPERTY_LATIN_LONG      ( 1U << 4 )

#define AF_BLUE_PROPERTY_CJK_TOP    ( 1U << 0 )       /* must have value 1 */
#define AF_BLUE_PROPERTY_CJK_HORIZ  ( 1U << 1 )       /* must have value 2 */
#define AF_BLUE_PROPERTY_CJK_RIGHT  AF_BLUE_PROPERTY_CJK_TOP


#define AF_BLUE_STRINGSET_MAX_LEN  8

  /* The AF_Blue_Stringset enumeration values are offsets into the */
  /* `af_blue_stringsets' array.                                   */

  typedef enum  AF_Blue_Stringset_
  {
    AF_BLUE_STRINGSET_ARAB = 0,
    AF_BLUE_STRINGSET_BENG = 4,
    AF_BLUE_STRINGSET_CYRL = 9,
    AF_BLUE_STRINGSET_DEVA = 15,
    AF_BLUE_STRINGSET_GEOR = 21,
    AF_BLUE_STRINGSET_GEOK = 26,
    AF_BLUE_STRINGSET_GREK = 33,
    AF_BLUE_STRINGSET_GUJR = 40,
    AF_BLUE_STRINGSET_HEBR = 46,
    AF_BLUE_STRINGSET_KNDA = 50,
    AF_BLUE_STRINGSET_KHMR = 53,
    AF_BLUE_STRINGSET_KHMS = 59,
    AF_BLUE_STRINGSET_LAO = 62,
    AF_BLUE_STRINGSET_LATN = 68,
    AF_BLUE_STRINGSET_LATB = 75,
    AF_BLUE_STRINGSET_LATP = 82,
    AF_BLUE_STRINGSET_MLYM = 89,
    AF_BLUE_STRINGSET_MYMR = 92,
    AF_BLUE_STRINGSET_NONE = 97,
    AF_BLUE_STRINGSET_SINH = 98,
    AF_BLUE_STRINGSET_TAML = 102,
    AF_BLUE_STRINGSET_TELU = 105,
    AF_BLUE_STRINGSET_THAI = 108,
    af_blue_2_1 = 116,
#ifdef AF_CONFIG_OPTION_CJK
    AF_BLUE_STRINGSET_HANI = af_blue_2_1 + 0,
    af_blue_2_1_1 = af_blue_2_1 + 2,
#ifdef AF_CONFIG_OPTION_CJK_BLUE_HANI_VERT
    af_blue_2_1_2 = af_blue_2_1_1 + 2,
#else
    af_blue_2_1_2 = af_blue_2_1_1 + 0,
#endif /* AF_CONFIG_OPTION_CJK_BLUE_HANI_VERT */
    af_blue_2_2 = af_blue_2_1_2 + 1,
#else
    af_blue_2_2 = af_blue_2_1 + 0,
#endif /* AF_CONFIG_OPTION_CJK                */


    AF_BLUE_STRINGSET_MAX   /* do not remove */

  } AF_Blue_Stringset;


  typedef struct  AF_Blue_StringRec_
  {
    AF_Blue_String  string;
    FT_UShort       properties;

  } AF_Blue_StringRec;


  FT_LOCAL_ARRAY( AF_Blue_StringRec )
  af_blue_stringsets[];

/* */

FT_END_HEADER


#endif /* AFBLUE_H_ */


/* END */
