# The test does the following:
# 1. Uses debug executes to ensure that multiple threads enter ordered_commit
#    as a group.
# 2. Uses debug execute to ensure that one thread in the group fails after
#    flushing to the log with commit-consensus-error
# 3. Verifies that none of the trxs in the group committed (all trxs were
#    aborted in the engine)
# 4. Verifies that the trxs that were aborted released their owned_gtid (and
#    gtid_executed was not updates for these trxs)
# 5. All row locks for the trxs were released as part of abort. So subsequent
#    inserts with the same key is a success
# 6. The newly committed trxs were assigned sequentially increasing gtid
#    (since #4 ensured that owned_gtids were released correctly)

# clean slate
reset master;

# setup
--let $master_uuid= `SELECT @@GLOBAL.SERVER_UUID`
create table t1(a int primary key, b char(8)) engine=innodb;
connect(con1,localhost,root,,);
connect(con2,localhost,root,,);

# conn1 is the session that becomes leader of the group. conn2 becomes the
# follower. conn1 simulates before commit error by setting
# simulate_before_commit_error. trxs in both sessions will be rolled back
# implicitly. binlog events generated by both trxs will be retained in the
# binlog.
--connection con1
set session debug="+d,simulate_before_commit_error";
set session debug="+d,become_group_leader";
--send insert into t1 values (1, 'a');

--connection con2
set session debug="+d,become_group_follower";
--send insert into t1 values (2, 'b');

--connection con1
--error ER_ERROR_DURING_COMMIT
--reap
--connection con2
--error ER_ERROR_DURING_COMMIT
--reap

# Cleanup
--disconnect con1
--disconnect con2

--connection default
# Verify that the trx was rolled back
select * from t1;

# Binlog should retain events for the rolledback trxs
--source include/show_binlog_events.inc

# Insert a flush log and wait until gtid_executed table is compressed
SET @@GLOBAL.DEBUG= '+d,compress_gtid_table';
flush logs;
SET DEBUG_SYNC='now WAIT_FOR complete_compression';

# Verify that gtid_executed table is maintained correctly. It should have only
# one entry corresponding to 'create table...'
--replace_result $master_uuid MASTER_UUID
select * from mysql.gtid_executed;

# Inserting same keys into table should succeed since earlier trxs were rolled
# back releasing all row locks
insert into t1 values(1, 'a');
insert into t1 values(2, 'b');
select * from t1;

# Insert a flush log and wait until gtid_executed table is compressed
SET @@GLOBAL.DEBUG= '+d,compress_gtid_table';
flush logs;
SET DEBUG_SYNC='now WAIT_FOR complete_compression';

# Verify that gtid_executed table is maintained correctly without any holes
--replace_result $master_uuid MASTER_UUID
select * from mysql.gtid_executed;

drop table t1;
SET @@GLOBAL.DEBUG= '-d,compress_gtid_table';
