/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import javax.xml.transform.ErrorListener;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class StandardErrorHandler
implements ErrorHandler {
    private ErrorListener errorListener;
    private int warningCount = 0;
    private int errorCount = 0;
    private int fatalErrorCount = 0;
    private boolean silent = false;

    public StandardErrorHandler(ErrorListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.errorListener = listener;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    @Override
    public void warning(SAXParseException e) {
        try {
            ++this.warningCount;
            if (!this.silent) {
                this.errorListener.warning(XPathException.makeXPathException(e));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        ++this.errorCount;
        if (!this.silent) {
            this.reportError(e, false);
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        ++this.fatalErrorCount;
        if (!this.silent) {
            this.reportError(e, true);
        }
        throw e;
    }

    protected void reportError(SAXParseException e, boolean isFatal) {
        try {
            ExplicitLocation loc = new ExplicitLocation(e.getSystemId(), e.getLineNumber(), e.getColumnNumber());
            XPathException err = new XPathException("Error reported by XML parser", loc, (Throwable)e);
            err.setErrorCode("SXXP0003");
            if (isFatal) {
                this.errorListener.fatalError(err);
            } else {
                this.errorListener.error(err);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getFatalErrorCount() {
        return this.fatalErrorCount;
    }
}

