/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.Year;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Optional;
import org.exparity.hamcrest.date.core.TemporalConverter;
import org.exparity.hamcrest.date.core.TemporalMatcher;
import org.exparity.hamcrest.date.core.TemporalProvider;
import org.hamcrest.Description;

public class IsYear<T>
extends TemporalMatcher<T> {
    private final TemporalConverter<T, Year> converter;
    private final TemporalProvider<Year> expected;
    private final Locale locale;
    private final Optional<ZoneId> zone;

    public IsYear(TemporalConverter<T, Year> converter, TemporalProvider<Year> expected, Optional<ZoneId> zone, Locale locale) {
        this.expected = expected;
        this.converter = converter;
        this.locale = locale;
        this.zone = zone;
    }

    public IsYear(TemporalConverter<T, Year> converter, TemporalProvider<Year> expected) {
        this(converter, expected, Optional.empty(), Locale.getDefault(Locale.Category.FORMAT));
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        Year actualValue;
        Year expectedValue = this.expected.apply(this.zone);
        if (!expectedValue.equals(actualValue = this.converter.apply(actual, this.zone))) {
            mismatchDescription.appendText("the date has the year " + actualValue);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the date has the year " + this.expected.apply(this.zone));
    }

    @Override
    public TemporalMatcher<T> atZone(ZoneId zone) {
        return new IsYear<T>(this.converter, this.expected, Optional.of(zone), this.locale);
    }

    @Override
    public TemporalMatcher<T> atLocale(Locale locale) {
        return new IsYear<T>(this.converter, this.expected, this.zone, locale);
    }
}

