/*
 * Decompiled with CFR 0.152.
 */
package jodd.log.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import jodd.log.Logger;
import jodd.log.LoggerProvider;
import jodd.log.impl.SimpleLogger;

public class SimpleLoggerProvider
implements LoggerProvider<SimpleLogger> {
    private final long startTime;
    private static Map<String, SimpleLogger> loggers = new HashMap<String, SimpleLogger>();
    private Function<String, SimpleLogger> simpleLoggerFunction = n -> new SimpleLogger(this, (String)n, Logger.Level.DEBUG);

    protected SimpleLoggerProvider() {
        this.startTime = System.currentTimeMillis();
    }

    public long getElapsedTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    @Override
    public SimpleLogger createLogger(String name) {
        return loggers.computeIfAbsent(name, this.simpleLoggerFunction);
    }
}

