/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.apache.jmeter.assertions.JSONPathAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.gui.util.JSyntaxTextArea;
import org.apache.jmeter.gui.util.JTextScrollPane;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

@GUIMenuSortOrder(value=2)
@TestElementMetadata(labelResource="json_assertion_title")
public class JSONPathAssertionGui
extends AbstractAssertionGui
implements ChangeListener {
    private static final long serialVersionUID = -6008018002423594040L;
    private static final String JSON_ASSERTION_PATH = "json_assertion_path";
    private static final String JSON_ASSERTION_VALIDATION = "json_assertion_validation";
    private static final String JSON_ASSERTION_REGEX = "json_assertion_regex";
    private static final String JSON_ASSERTION_EXPECTED_VALUE = "json_assertion_expected_value";
    private static final String JSON_ASSERTION_NULL = "json_assertion_null";
    private static final String JSON_ASSERTION_INVERT = "json_assertion_invert";
    private static final String JSON_ASSERTION_TITLE = "json_assertion_title";
    protected JTextField jsonPath = null;
    protected JSyntaxTextArea jsonValue = null;
    protected JCheckBox jsonValidation = null;
    protected JCheckBox expectNull = null;
    protected JCheckBox invert = null;
    protected JCheckBox isRegex;

    public JSONPathAssertionGui() {
        this.init();
    }

    void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JPanel panel = this.buildPanel();
        this.add(panel, "Center");
        this.jsonValidation.addChangeListener(this);
        this.expectNull.addChangeListener(this);
    }

    protected JPanel buildPanel() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fillx, wrap 2, insets 0", "[][fill,grow]"));
        this.jsonPath = new JTextField();
        panel.add(JMeterUtils.labelFor((Component)this.jsonPath, (String)JSON_ASSERTION_PATH));
        panel.add((Component)this.jsonPath, "span, growx");
        this.jsonValidation = new JCheckBox();
        panel.add(JMeterUtils.labelFor((Component)this.jsonValidation, (String)JSON_ASSERTION_VALIDATION));
        panel.add((Component)this.jsonValidation, "span");
        this.isRegex = new JCheckBox();
        panel.add(JMeterUtils.labelFor((Component)this.isRegex, (String)JSON_ASSERTION_REGEX));
        panel.add((Component)this.isRegex, "span");
        this.jsonValue = JSyntaxTextArea.getInstance((int)5, (int)60);
        panel.add(JMeterUtils.labelFor((Component)this.jsonValue, (String)JSON_ASSERTION_EXPECTED_VALUE));
        panel.add((Component)JTextScrollPane.getInstance((JSyntaxTextArea)this.jsonValue));
        this.expectNull = new JCheckBox();
        panel.add(JMeterUtils.labelFor((Component)this.expectNull, (String)JSON_ASSERTION_NULL));
        panel.add((Component)this.expectNull, "span");
        this.invert = new JCheckBox();
        panel.add(JMeterUtils.labelFor((Component)this.invert, (String)JSON_ASSERTION_INVERT));
        panel.add((Component)this.invert, "span");
        return panel;
    }

    public void clearGui() {
        super.clearGui();
        this.jsonPath.setText("");
        this.jsonValue.setText("");
        this.jsonValidation.setSelected(false);
        this.expectNull.setSelected(false);
        this.invert.setSelected(false);
        this.isRegex.setSelected(true);
    }

    public TestElement createTestElement() {
        JSONPathAssertion jpAssertion = new JSONPathAssertion();
        this.modifyTestElement((TestElement)jpAssertion);
        return jpAssertion;
    }

    public String getLabelResource() {
        return JSON_ASSERTION_TITLE;
    }

    public void modifyTestElement(TestElement element) {
        super.configureTestElement(element);
        if (element instanceof JSONPathAssertion) {
            JSONPathAssertion jpAssertion = (JSONPathAssertion)element;
            jpAssertion.setJsonPath(this.jsonPath.getText());
            jpAssertion.setExpectedValue(this.jsonValue.getText());
            jpAssertion.setJsonValidationBool(this.jsonValidation.isSelected());
            jpAssertion.setExpectNull(this.expectNull.isSelected());
            jpAssertion.setInvert(this.invert.isSelected());
            jpAssertion.setIsRegex(this.isRegex.isSelected());
        }
    }

    public void configure(TestElement element) {
        super.configure(element);
        if (element instanceof JSONPathAssertion) {
            JSONPathAssertion jpAssertion = (JSONPathAssertion)element;
            this.jsonPath.setText(jpAssertion.getJsonPath());
            this.jsonValue.setText(jpAssertion.getExpectedValue());
            this.jsonValidation.setSelected(jpAssertion.isJsonValidationBool());
            this.expectNull.setSelected(jpAssertion.isExpectNull());
            this.invert.setSelected(jpAssertion.isInvert());
            this.isRegex.setSelected(jpAssertion.isUseRegex());
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.jsonValue.setEnabled(this.jsonValidation.isSelected() && !this.expectNull.isSelected());
        this.isRegex.setEnabled(this.jsonValidation.isSelected() && !this.expectNull.isSelected());
    }
}

