/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutEnabledQueueRequestor {
    private static final Logger logger = LoggerFactory.getLogger(TimeoutEnabledQueueRequestor.class);
    private TemporaryQueue tempQueue;
    private MessageProducer sender;
    private MessageConsumer receiver;

    public TimeoutEnabledQueueRequestor(Session session, Queue queue) throws JMSException {
        this.tempQueue = session.createTemporaryQueue();
        this.sender = session.createProducer((Destination)queue);
        this.receiver = session.createConsumer((Destination)this.tempQueue);
    }

    public Message request(Message message) throws JMSException {
        return this.request(message, 0L);
    }

    public Message request(Message message, long timeout) throws JMSException {
        message.setJMSReplyTo((Destination)this.tempQueue);
        this.sender.send(message);
        return this.receiver.receive(timeout);
    }

    public void close() throws JMSException {
        String queueName = this.tempQueue.getQueueName();
        try {
            this.sender.close();
        }
        catch (Exception ex) {
            logger.error("Error closing sender", (Throwable)ex);
        }
        try {
            this.receiver.close();
        }
        catch (Exception ex) {
            logger.error("Error closing receiver", (Throwable)ex);
        }
        try {
            this.tempQueue.delete();
        }
        catch (Exception ex) {
            logger.error("Error deleting tempQueue {}", (Object)queueName, (Object)ex);
        }
    }
}

