/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSession;
import javax.jms.Session;
import org.apache.jmeter.protocol.jms.sampler.QueueExecutor;
import org.apache.jmeter.protocol.jms.sampler.TimeoutEnabledQueueRequestor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryQueueExecutor
implements QueueExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemporaryQueueExecutor.class);
    private final TimeoutEnabledQueueRequestor requestor;
    private int timeout;

    public TemporaryQueueExecutor(QueueSession session, Queue destination, int timeoutMs) throws JMSException {
        this.requestor = new TimeoutEnabledQueueRequestor((Session)session, destination);
        this.timeout = timeoutMs;
    }

    @Override
    public Message sendAndReceive(Message request, int deliveryMode, int priority, long expiration) throws JMSException {
        LOGGER.debug("Sending message and waiting for response in Temporary queue with timeout {} ms (0==infinite)", (Object)this.timeout);
        return this.requestor.request(request, this.timeout);
    }

    @Override
    public void close() throws JMSException {
        this.requestor.close();
    }
}

