/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cursor;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.cursor.AsyncResultCursor;
import org.neo4j.driver.internal.cursor.AsyncResultCursorImpl;
import org.neo4j.driver.internal.cursor.DisposableAsyncResultCursor;
import org.neo4j.driver.internal.cursor.ResultCursorFactory;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.cursor.RxResultCursorImpl;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.PullResponseHandler;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.spi.Connection;

public class ResultCursorFactoryImpl
implements ResultCursorFactory {
    private final RunResponseHandler runHandler;
    private final Connection connection;
    private final PullResponseHandler pullHandler;
    private final PullAllResponseHandler pullAllHandler;
    private final boolean waitForRunResponse;
    private final Message runMessage;

    public ResultCursorFactoryImpl(Connection connection, Message runMessage, RunResponseHandler runHandler, PullResponseHandler pullHandler, PullAllResponseHandler pullAllHandler, boolean waitForRunResponse) {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(runMessage);
        Objects.requireNonNull(runHandler);
        Objects.requireNonNull(pullHandler);
        Objects.requireNonNull(pullAllHandler);
        this.connection = connection;
        this.runMessage = runMessage;
        this.runHandler = runHandler;
        this.pullHandler = pullHandler;
        this.pullAllHandler = pullAllHandler;
        this.waitForRunResponse = waitForRunResponse;
    }

    @Override
    public CompletionStage<AsyncResultCursor> asyncResult() {
        this.connection.write(this.runMessage, this.runHandler);
        this.pullAllHandler.prePopulateRecords();
        if (this.waitForRunResponse) {
            return this.runHandler.runFuture().thenApply(ignore -> new DisposableAsyncResultCursor(new AsyncResultCursorImpl(this.runHandler, this.pullAllHandler)));
        }
        return CompletableFuture.completedFuture(new DisposableAsyncResultCursor(new AsyncResultCursorImpl(this.runHandler, this.pullAllHandler)));
    }

    @Override
    public CompletionStage<RxResultCursor> rxResult() {
        this.connection.writeAndFlush(this.runMessage, this.runHandler);
        return this.runHandler.runFuture().thenApply(this::composeRxCursor);
    }

    private RxResultCursor composeRxCursor(Throwable runError) {
        return new RxResultCursorImpl(runError, this.runHandler, this.pullHandler);
    }
}

