/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabbedpane;

import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneUI;
import com.github.weisj.darklaf.ui.tabbedpane.TabbedPaneUtil;
import com.github.weisj.darklaf.util.DnDUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingConstants;
import javax.swing.TransferHandler;
import javax.swing.plaf.TabbedPaneUI;

public class TabbedPaneTransferHandler
extends TransferHandler
implements DropTargetListener,
SwingConstants {
    private static final String MIME_TYPE = "application/x-java-jvm-local-objectref;class=javax.swing.JTabbedPane";
    private static TabbedPaneDragGestureRecognizer recognizer = null;
    protected Point mouseLocation;
    private int lastTab = -1;
    private DataFlavor tabFlavor;
    private TabTransferable currentTransferable;

    public TabbedPaneTransferHandler() {
        try {
            this.tabFlavor = new DataFlavor(MIME_TYPE);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent e, int a) {
        int srcActions = this.getSourceActions(comp);
        int action = a;
        if (!(e instanceof MouseEvent) || action != 1 && action != 2 && action != 0x40000000 || (srcActions & action) == 0) {
            action = 0;
        }
        if (action != 0 && !GraphicsEnvironment.isHeadless()) {
            if (recognizer == null) {
                recognizer = new TabbedPaneDragGestureRecognizer(new TabbedPaneDragHandler());
            }
            recognizer.gestured(comp, (MouseEvent)e, srcActions, action);
        } else {
            this.exportDone(comp, null, 0);
        }
    }

    @Override
    public boolean importData(JComponent c, Transferable t) {
        boolean successful = false;
        if (this.hasTabFlavor(t.getTransferDataFlavors()) && this.mouseLocation != null) {
            try {
                JTabbedPane tabbedPane = (JTabbedPane)c;
                int tab = TabbedPaneUtil.getDroppedTabIndex(this.currentTransferable.getTabBounds(), tabbedPane, this.supportsIndicator(tabbedPane), this.mouseLocation);
                TabTransferable.TabTransferData td = (TabTransferable.TabTransferData)t.getTransferData(this.tabFlavor);
                if (!TabbedPaneUtil.moveTabs(td.sourceTabbedPane, tabbedPane, td.tabIndex, tab)) {
                    return true;
                }
                successful = true;
                DarkTabbedPaneUI ui = this.supportsIndicator(c);
                if (ui != null) {
                    ui.clearDropIndicator();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return successful;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return this.hasTabFlavor(flavors);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 2;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        JTabbedPane tabPane = (JTabbedPane)c;
        this.currentTransferable = new TabTransferable(tabPane);
        DarkTabbedPaneUI ui = this.supportsIndicator(c);
        int index = this.currentTransferable.transferData.tabIndex;
        index = tabPane.getTabCount() > 1 ? (index == 0 ? ++index : --index) : -1;
        tabPane.setSelectedIndex(index);
        if (ui != null) {
            ui.setRolloverTab(-1);
            this.createDragImage(tabPane, ui);
            ui.setSourceIndicator(this.currentTransferable.transferData.tabIndex);
        }
        return this.currentTransferable;
    }

    protected void createDragImage(JTabbedPane tabbedPane, DarkTabbedPaneUI ui) {
        Color color = ui != null ? ui.getDragBorderColor() : tabbedPane.getBackgroundAt(this.currentTransferable.transferData.tabIndex);
        Image tabImage = DnDUtil.createDragImage(tabbedPane, this.currentTransferable.transferData.tabBounds, 2, color);
        int w = tabImage.getWidth(null);
        int h = tabImage.getHeight(null);
        this.setDragImageOffset(new Point(w / 2, h / 2));
        this.setDragImage(tabImage);
    }

    protected boolean hasTabFlavor(DataFlavor[] flavors) {
        if (this.tabFlavor == null) {
            return false;
        }
        for (DataFlavor flavor : flavors) {
            if (!this.tabFlavor.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    private DarkTabbedPaneUI supportsIndicator(Component c) {
        TabbedPaneUI ui;
        if (c instanceof JTabbedPane && (ui = ((JTabbedPane)c).getUI()) instanceof DarkTabbedPaneUI) {
            return (DarkTabbedPaneUI)ui;
        }
        return null;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        TabTransferable t;
        e.getDropTargetContext().getComponent().setCursor(Cursor.getDefaultCursor());
        this.mouseLocation = e.getLocation();
        Component c = e.getDropTargetContext().getComponent();
        JTabbedPane destTabbedPane = (JTabbedPane)c;
        DarkTabbedPaneUI ui = this.supportsIndicator(destTabbedPane);
        if (ui != null && (t = this.currentTransferable) != null) {
            int tab = TabbedPaneUtil.getDroppedTabIndex(t.getTabBounds(), destTabbedPane, this.supportsIndicator(destTabbedPane), this.mouseLocation);
            if (tab == -1) {
                this.lastTab = tab;
                ui.clearDropIndicator();
                return;
            }
            Rectangle dropRect = TabbedPaneUtil.getDropRect(this.supportsIndicator(destTabbedPane), destTabbedPane, t.transferData.sourceTabbedPane, this.mouseLocation, t.getTabBounds(), tab, t.transferData.tabIndex, this.lastTab);
            ui.setDnDIndicatorRect(dropRect.x, dropRect.y, dropRect.width, dropRect.height, tab, t.transferData.sourceTabbedPane == destTabbedPane);
            this.lastTab = tab;
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        Component c = e.getDropTargetContext().getComponent();
        this.lastTab = -1;
        DarkTabbedPaneUI ui = this.supportsIndicator(c);
        if (ui != null) {
            ui.clearDropIndicator();
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        Component c = e.getDropTargetContext().getComponent();
        DarkTabbedPaneUI ui = this.supportsIndicator(c);
        if (ui != null) {
            ui.clearDropIndicator();
        }
    }

    protected class TabbedPaneDragHandler
    implements DragGestureListener,
    DragSourceListener {
        private boolean scrolls;

        protected TabbedPaneDragHandler() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            JComponent c = (JComponent)dge.getComponent();
            TabbedPaneTransferHandler th = (TabbedPaneTransferHandler)c.getTransferHandler();
            Transferable t = th.createTransferable(c);
            if (t != null) {
                this.scrolls = c.getAutoscrolls();
                c.setAutoscrolls(false);
                try {
                    Image im = th.getDragImage();
                    if (im == null) {
                        dge.startDrag(Cursor.getDefaultCursor(), t, this);
                    } else {
                        dge.startDrag(Cursor.getDefaultCursor(), im, th.getDragImageOffset(), t, this);
                    }
                    return;
                }
                catch (RuntimeException re) {
                    c.setAutoscrolls(this.scrolls);
                }
            }
            th.exportDone(c, t, 0);
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dsde) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            DragSourceContext dsc = dsde.getDragSourceContext();
            JComponent c = (JComponent)dsc.getComponent();
            if (dsde.getDropSuccess()) {
                ((TabbedPaneTransferHandler)c.getTransferHandler()).exportDone(c, dsc.getTransferable(), dsde.getDropAction());
            } else {
                ((TabbedPaneTransferHandler)c.getTransferHandler()).exportDone(c, dsc.getTransferable(), 0);
            }
            c.setAutoscrolls(this.scrolls);
            DarkTabbedPaneUI ui = TabbedPaneTransferHandler.this.supportsIndicator(TabbedPaneTransferHandler.this.currentTransferable.transferData.sourceTabbedPane);
            if (ui != null) {
                ui.clearSourceIndicator();
            }
            if (!dsde.getDropSuccess()) {
                TabbedPaneUtil.selectTab(TabbedPaneTransferHandler.this.currentTransferable.transferData.sourceTabbedPane, TabbedPaneTransferHandler.this.currentTransferable.transferData.tabIndex);
            }
            TabbedPaneTransferHandler.this.currentTransferable = null;
        }
    }

    public class TabTransferable
    implements Transferable {
        private final TabTransferData transferData;

        public TabTransferable(JTabbedPane tabbedPane) {
            int index = tabbedPane.getSelectedIndex();
            this.transferData = new TabTransferData(tabbedPane, index);
        }

        public Rectangle getTabBounds() {
            return new Rectangle(this.transferData.tabBounds);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            if (TabbedPaneTransferHandler.this.tabFlavor == null) {
                return new DataFlavor[0];
            }
            return new DataFlavor[]{TabbedPaneTransferHandler.this.tabFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return TabbedPaneTransferHandler.this.tabFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.transferData;
        }

        public class TabTransferData {
            private final JTabbedPane sourceTabbedPane;
            private final int tabIndex;
            private final Rectangle tabBounds;

            public TabTransferData(JTabbedPane tabbedPane, int tabIndex) {
                this.sourceTabbedPane = tabbedPane;
                this.tabIndex = tabIndex;
                this.tabBounds = tabbedPane.getBoundsAt(tabIndex);
            }
        }
    }

    public static class UIResource
    extends TabbedPaneTransferHandler {
    }

    protected static class TabbedPaneDragGestureRecognizer
    extends DragGestureRecognizer {
        protected TabbedPaneDragGestureRecognizer(DragGestureListener dgl) {
            super(DragSource.getDefaultDragSource(), null, 0, dgl);
        }

        void gestured(JComponent c, MouseEvent e, int srcActions, int action) {
            this.setComponent(c);
            this.setSourceActions(srcActions);
            this.appendEvent(e);
            this.fireDragGestureRecognized(action, e.getPoint());
        }

        @Override
        protected void registerListeners() {
        }

        @Override
        protected void unregisterListeners() {
        }
    }
}

