/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.list;

import com.github.weisj.darklaf.ui.cell.CellConstants;
import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.ui.cell.DarkCellRendererPane;
import com.github.weisj.darklaf.ui.list.DarkListCellRendererDelegate;
import com.github.weisj.darklaf.ui.list.DarkListUIBridge;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.plaf.ComponentUI;

public class DarkListUI
extends DarkListUIBridge
implements CellConstants {
    protected static final String KEY_PREFIX = "JList.";
    public static final String KEY_IS_COMBO_LIST = "JList..isComboList";
    public static final String KEY_ALTERNATE_ROW_COLOR = "JList.alternateRowColor";
    public static final String KEY_RENDER_BOOLEAN_AS_CHECKBOX = "JList.renderBooleanAsCheckBox";
    public static final String KEY_BOOLEAN_RENDER_TYPE = "JList.booleanRenderType";
    public static final String KEY_SHRINK_WRAP = "JList.shrinkWrap";
    public static final String KEY_FULL_ROW_SELECTION = "JList.fullRowSelection";
    public static final String KEY_IS_EDITING = "JList.isEditing";
    public static final String KEY_IS_LIST_EDITOR = "JComponent.listCellEditor";
    protected DarkListCellRendererDelegate rendererDelegate;

    public static ComponentUI createUI(JComponent list) {
        return new DarkListUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.remove(this.rendererPane);
        this.rendererPane = this.createCellRendererPane();
        c.add(this.rendererPane);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.rendererDelegate = new DarkListCellRendererDelegate();
        PropertyUtil.installBooleanProperty((JComponent)this.list, (String)KEY_ALTERNATE_ROW_COLOR, (String)"List.alternateRowColor");
    }

    protected CellRendererPane createCellRendererPane() {
        return new DarkCellRendererPane();
    }

    @Override
    protected DarkListUIBridge.Handler getHandler() {
        if (this.handler == null) {
            this.handler = new DarkHandler();
        }
        return this.handler;
    }

    @Override
    protected void paintImpl(Graphics g, JComponent c) {
        int endColumn;
        int startColumn;
        switch (this.layoutOrientation) {
            case 1: {
                if (this.list.getHeight() == this.listHeight) break;
                this.updateLayoutStateNeeded |= 0x100;
                this.redrawList();
                break;
            }
            case 2: {
                if (this.list.getWidth() == this.listWidth) break;
                this.updateLayoutStateNeeded |= 0x200;
                this.redrawList();
                break;
            }
        }
        this.maybeUpdateLayoutState();
        ListCellRenderer<Object> renderer = this.getCellRenderer(this.list);
        ListModel<Object> dataModel = this.list.getModel();
        ListSelectionModel selModel = this.list.getSelectionModel();
        if (renderer == null || dataModel.getSize() == 0) {
            return;
        }
        Rectangle paintBounds = g.getClipBounds();
        if (c.getComponentOrientation().isLeftToRight()) {
            startColumn = this.convertLocationToColumn(paintBounds.x, paintBounds.y);
            endColumn = this.convertLocationToColumn(paintBounds.x + paintBounds.width, paintBounds.y);
        } else {
            startColumn = this.convertLocationToColumn(paintBounds.x + paintBounds.width, paintBounds.y);
            endColumn = this.convertLocationToColumn(paintBounds.x, paintBounds.y);
        }
        int maxY = paintBounds.y + paintBounds.height;
        int maxX = paintBounds.x + paintBounds.width;
        int leadIndex = DarkListUI.adjustIndex(this.list.getLeadSelectionIndex(), this.list);
        int rowIncrement = this.layoutOrientation == 2 ? this.columnCount : 1;
        Rectangle rowBounds = new Rectangle();
        int colCounter = startColumn;
        while (rowBounds.x < maxX) {
            int maxRow;
            int row = this.convertLocationToRowInColumn(paintBounds.y, colCounter);
            int rowCount = Math.max(this.rowsPerColumn, this.getRowCount(colCounter));
            int index = this.getModelIndex(colCounter, row);
            if (colCounter <= endColumn) {
                rowBounds = this.getCellBounds(this.list, index);
            } else {
                rowBounds.x += rowBounds.width;
                rowBounds.width = maxX - rowBounds.x;
                rowBounds.y = paintBounds.y;
            }
            if (rowBounds == null) {
                return;
            }
            boolean lastColumn = colCounter == endColumn && this.getColumnCount() > 1 && colCounter * this.rowsPerColumn + rowCount >= dataModel.getSize();
            int bgWidth = lastColumn ? maxX - rowBounds.x : 0;
            int n = maxRow = lastColumn ? Integer.MAX_VALUE : rowCount;
            while (rowBounds.y < maxY) {
                rowBounds.height = this.getHeight(colCounter, row);
                for (int column = colCounter - 1; rowBounds.height <= 0 && column >= 0; --column) {
                    rowBounds.height = this.getHeight(colCounter - 1, row);
                }
                if (rowBounds.height <= 0) {
                    rowBounds.height = this.getHeight(0, 0);
                }
                g.setClip(rowBounds.x, rowBounds.y, bgWidth > 0 ? bgWidth : rowBounds.width, rowBounds.height);
                g.clipRect(paintBounds.x, paintBounds.y, paintBounds.width, paintBounds.height);
                int cellIndex = row < maxRow && colCounter <= endColumn ? index : -1;
                int rowIndex = row++;
                this.paintCell(g, cellIndex, rowBounds, renderer, dataModel, selModel, leadIndex, rowIndex, bgWidth);
                rowBounds.y += rowBounds.height;
                index += rowIncrement;
            }
            ++colCounter;
        }
        this.rendererPane.removeAll();
    }

    protected ListCellRenderer<Object> getCellRenderer(JList<Object> list) {
        ListCellRenderer<Object> renderer = list.getCellRenderer();
        this.rendererDelegate.setDelegate(renderer);
        return this.rendererDelegate;
    }

    protected void paintCell(Graphics g, int index, Rectangle rowBounds, ListCellRenderer<Object> cellRenderer, ListModel<Object> dataModel, ListSelectionModel selModel, int leadIndex, int row, int bgWidth) {
        boolean empty = index < 0 || index >= this.list.getModel().getSize();
        Object value = empty ? null : dataModel.getElementAt(index);
        boolean cellHasFocus = this.list.hasFocus() && index == leadIndex;
        boolean isSelected = selModel.isSelectedIndex(index);
        int cx = rowBounds.x;
        int cy = rowBounds.y;
        int cw = rowBounds.width;
        int ch = rowBounds.height;
        if (empty) {
            g.setColor(CellUtil.getListBackground((Component)this.list, this.list, false, row));
            g.fillRect(cx, cy, bgWidth > 0 ? bgWidth : cw, ch);
        } else {
            Component rendererComponent = cellRenderer.getListCellRendererComponent(this.list, value, index, isSelected, cellHasFocus);
            if (PropertyUtil.getBooleanProperty((JComponent)this.list, (String)KEY_SHRINK_WRAP)) {
                int w = Math.min(cw, rendererComponent.getPreferredSize().width + 4);
                if (!this.list.getComponentOrientation().isLeftToRight()) {
                    cx += cw - w;
                }
                cw = w;
            }
            this.rendererPane.paintComponent(g, rendererComponent, this.list, cx, cy, cw, ch, true);
        }
    }

    @Override
    public int getRowCount(int column) {
        return super.getRowCount(column);
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    protected class DarkHandler
    extends DarkListUIBridge.Handler {
        protected DarkHandler() {
            super(DarkListUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            String key = e.getPropertyName();
            if (DarkListUI.KEY_ALTERNATE_ROW_COLOR.equals(key)) {
                DarkListUI.this.list.repaint();
            }
        }

        @Override
        protected void adjustSelection(MouseEvent e) {
            int row = DarkListUI.this.list.locationToIndex(e.getPoint());
            if (row < 0) {
                if (!(!DarkListUI.this.isFileList || PropertyUtil.getBooleanProperty((JComponent)DarkListUI.this.list, (String)DarkListUI.KEY_FULL_ROW_SELECTION) || e.getID() != 501 || e.isShiftDown() && DarkListUI.this.list.getSelectionMode() != 0)) {
                    DarkListUI.this.list.clearSelection();
                }
            } else {
                boolean anchorSelected;
                int anchorIndex = DarkListUIBridge.adjustIndex(DarkListUI.this.list.getAnchorSelectionIndex(), DarkListUI.this.list);
                if (anchorIndex == -1) {
                    anchorIndex = 0;
                    anchorSelected = false;
                } else {
                    anchorSelected = DarkListUI.this.list.isSelectedIndex(anchorIndex);
                }
                if (DarkUIUtil.isMenuShortcutKeyDown(e)) {
                    if (e.isShiftDown()) {
                        if (anchorSelected) {
                            DarkListUI.this.list.addSelectionInterval(anchorIndex, row);
                        } else {
                            DarkListUI.this.list.removeSelectionInterval(anchorIndex, row);
                            if (DarkListUI.this.isFileList) {
                                DarkListUI.this.list.addSelectionInterval(row, row);
                                DarkListUI.this.list.getSelectionModel().setAnchorSelectionIndex(anchorIndex);
                            }
                        }
                    } else if (DarkListUI.this.list.isSelectedIndex(row)) {
                        DarkListUI.this.list.removeSelectionInterval(row, row);
                    } else {
                        DarkListUI.this.list.addSelectionInterval(row, row);
                    }
                } else if (e.isShiftDown()) {
                    DarkListUI.this.list.setSelectionInterval(anchorIndex, row);
                } else {
                    DarkListUI.this.list.setSelectionInterval(row, row);
                }
            }
        }
    }
}

