/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.renderer;

import java.awt.Component;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class SimpleListCellRenderer<T>
extends JLabel
implements ListCellRenderer<T> {
    public static <T> SimpleListCellRenderer<T> create(final Function<? super T, String> toText) {
        return new SimpleListCellRenderer<T>(){

            @Override
            protected void customize(T value) {
                this.setText((String)toText.apply(value));
            }
        };
    }

    public static <T> SimpleListCellRenderer<T> create(final BiConsumer<JLabel, T> customize) {
        return new SimpleListCellRenderer<T>(){

            @Override
            protected void customize(T value) {
                customize.accept(this, value);
            }
        };
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setComponentOrientation(list.getComponentOrientation());
        this.customize(value);
        this.setEnabled(list.isEnabled());
        this.setFont(list.getFont());
        Border border = null;
        if (cellHasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = UIManager.getBorder("List.cellNoFocusBorder");
        }
        this.setBorder(border);
        return this;
    }

    protected void customize(T value) {
        if (value instanceof Icon) {
            this.setIcon((Icon)value);
            this.setText("");
        } else {
            this.setIcon(null);
            this.setText(value == null ? "" : value.toString());
        }
    }
}

