/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import java.util.Locale;
import java.util.regex.Pattern;

public class SystemInfo {
    public static final String X86 = "32";
    public static final String X64 = "64";
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_VERSION = System.getProperty("os.version").toLowerCase(Locale.ENGLISH);
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String JAVA_RUNTIME_VERSION = System.getProperty("java.runtime.version");
    public static final boolean isWindows;
    public static final boolean isOS2;
    public static final boolean isMac;
    public static final boolean isLinux;
    public static final boolean isUnix;
    public static final boolean isFileSystemCaseSensitive;
    public static final boolean isAppleJvm;
    public static final boolean isOracleJvm;
    public static final boolean isSunJvm;
    public static final String jreArchitecture;
    public static final boolean isX86;
    public static final boolean isX64;
    public static final boolean undefinedArchitecture;
    public static final boolean isJava9OrGreater;
    protected static final String _OS_NAME;
    public static final boolean isMacOSMojave;
    public static final boolean isMacOSCatalina;
    public static final boolean isMacOSYosemite;
    public static final boolean isWindows10;
    public static final boolean isWindows7;
    public static final boolean isWindowsVista;

    public static String getOsName() {
        return isMac ? "mac" : (isWindows ? "windows" : "linux");
    }

    public static boolean isOsVersionAtLeast(String version) {
        return SystemInfo.compareVersionNumbers(OS_VERSION, version) >= 0;
    }

    public static int compareVersionNumbers(String v1, String v2) {
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[.\\_-]");
        String[] part2 = v2.split("[._\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? Integer.valueOf(p1).compareTo(Integer.valueOf(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length == part2.length) {
            return 0;
        }
        return part1.length > idx ? 1 : -1;
    }

    public static boolean isJavaVersionAtLeast(String v) {
        return SystemInfo.compareVersionNumbers(JAVA_RUNTIME_VERSION, v) >= 0;
    }

    private static boolean isOracleJvm() {
        String vendor = SystemInfo.getJavaVmVendor();
        return vendor != null && SystemInfo.containsIgnoreCase(vendor, "Oracle");
    }

    public static String getJavaVmVendor() {
        return System.getProperty("java.vm.vendor");
    }

    private static boolean isSunJvm() {
        String vendor = SystemInfo.getJavaVmVendor();
        return vendor != null && SystemInfo.containsIgnoreCase(vendor, "Sun") && SystemInfo.containsIgnoreCase(vendor, "Microsystems");
    }

    private static boolean isAppleJvm() {
        String vendor = SystemInfo.getJavaVmVendor();
        return vendor != null && SystemInfo.containsIgnoreCase(vendor, "Apple");
    }

    private static boolean containsIgnoreCase(String text, String pattern) {
        return Pattern.compile(pattern, 18).matcher(text).find();
    }

    static {
        jreArchitecture = System.getProperty("sun.arch.data.model");
        _OS_NAME = OS_NAME.toLowerCase(Locale.ENGLISH);
        isWindows = _OS_NAME.startsWith("windows");
        isOS2 = _OS_NAME.startsWith("os/2") || _OS_NAME.startsWith("os2");
        isMac = _OS_NAME.startsWith("mac");
        isLinux = _OS_NAME.startsWith("linux");
        isUnix = !isWindows && !isOS2;
        isFileSystemCaseSensitive = isUnix && !isMac;
        isAppleJvm = SystemInfo.isAppleJvm();
        isOracleJvm = SystemInfo.isOracleJvm();
        isSunJvm = SystemInfo.isSunJvm();
        isX64 = X64.equals(jreArchitecture);
        isX86 = X86.equals(jreArchitecture);
        undefinedArchitecture = !isX86 && !isX64;
        isMacOSCatalina = isMac && SystemInfo.isOsVersionAtLeast("10.15");
        isMacOSMojave = isMacOSCatalina || isMac && SystemInfo.isOsVersionAtLeast("10.14");
        isMacOSYosemite = isMacOSCatalina || isMac && SystemInfo.isOsVersionAtLeast("10.10");
        isWindows10 = isWindows && SystemInfo.isOsVersionAtLeast("10.0");
        isWindows7 = isWindows10 || isWindows && SystemInfo.isOsVersionAtLeast("6.1");
        isWindowsVista = isWindows7 || isWindows && SystemInfo.isOsVersionAtLeast("6.0");
        isJava9OrGreater = SystemInfo.isJavaVersionAtLeast("9");
    }
}

