/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSWritableList<DATATYPE extends ICSSWriteable>
extends CommonsArrayList<DATATYPE>
implements ICSSSourceLocationAware,
ICSSWriteable {
    private CSSSourceLocation m_aSourceLocation;

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        int n2 = this.size();
        if (n2 == 0) {
            return "";
        }
        if (n2 == 1) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(((ICSSWriteable)this.get(0)).getAsCSSString(iCSSWriterSettings, n));
            if (!bl) {
                stringBuilder.append(';');
            }
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ICSSWriteable iCSSWriteable = (ICSSWriteable)iterator.next();
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n + 1));
            }
            stringBuilder.append(iCSSWriteable.getAsCSSString(iCSSWriterSettings, n + 1));
            if (!bl || n3 < n2 - 1) {
                stringBuilder.append(';');
            }
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getNewLineString());
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

