/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSExpression;
import com.helger.css.decl.ICSSSelectorMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSSelectorMemberFunctionLike
implements ICSSSelectorMember,
ICSSSourceLocationAware {
    private final String m_sFuncName;
    private final CSSExpression m_aParamExpr;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSelectorMemberFunctionLike(@Nonnull @Nonempty String string, @Nonnull CSSExpression cSSExpression) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"FunctionName");
        if (!string.endsWith("(")) {
            throw new IllegalArgumentException("function name must end with a '('");
        }
        ValueEnforcer.notNull((Object)cSSExpression, (String)"ParameterExpression");
        this.m_sFuncName = string;
        this.m_aParamExpr = cSSExpression;
    }

    @Nonnull
    @Nonempty
    public String getFunctionName() {
        return this.m_sFuncName;
    }

    @Nonnull
    public CSSExpression getParameterExpression() {
        return this.m_aParamExpr;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return this.m_sFuncName + this.m_aParamExpr.getAsCSSString(iCSSWriterSettings, n) + ')';
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSelectorMemberFunctionLike cSSSelectorMemberFunctionLike = (CSSSelectorMemberFunctionLike)object;
        return this.m_sFuncName.equals(cSSSelectorMemberFunctionLike.m_sFuncName) && this.m_aParamExpr.equals(cSSSelectorMemberFunctionLike.m_aParamExpr);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sFuncName).append((Object)this.m_aParamExpr).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("functionName", (Object)this.m_sFuncName).append("paramExpr", (Object)this.m_aParamExpr).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

