/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.statistics;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.statistics.IMutableStatisticsHandlerCache;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedCounter;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedSize;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedTimer;
import com.helger.commons.statistics.IMutableStatisticsHandlerSize;
import com.helger.commons.statistics.IMutableStatisticsHandlerTimer;
import com.helger.commons.statistics.StatisticsHandlerCache;
import com.helger.commons.statistics.StatisticsHandlerCounter;
import com.helger.commons.statistics.StatisticsHandlerKeyedCounter;
import com.helger.commons.statistics.StatisticsHandlerKeyedSize;
import com.helger.commons.statistics.StatisticsHandlerKeyedTimer;
import com.helger.commons.statistics.StatisticsHandlerSize;
import com.helger.commons.statistics.StatisticsHandlerTimer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class StatisticsManager {
    private static final SimpleReadWriteLock s_aRWLockCache = new SimpleReadWriteLock();
    private static final SimpleReadWriteLock s_aRWLockTimer = new SimpleReadWriteLock();
    private static final SimpleReadWriteLock s_aRWLockKeyedTimer = new SimpleReadWriteLock();
    private static final SimpleReadWriteLock s_aRWLockSize = new SimpleReadWriteLock();
    private static final SimpleReadWriteLock s_aRWLockKeyedSize = new SimpleReadWriteLock();
    private static final SimpleReadWriteLock s_aRWLockCounter = new SimpleReadWriteLock();
    private static final SimpleReadWriteLock s_aRWLockKeyedCounter = new SimpleReadWriteLock();
    private static final ICommonsMap<String, StatisticsHandlerCache> s_aHdlCache = new CommonsHashMap<String, StatisticsHandlerCache>();
    private static final ICommonsMap<String, StatisticsHandlerTimer> s_aHdlTimer = new CommonsHashMap<String, StatisticsHandlerTimer>();
    private static final ICommonsMap<String, StatisticsHandlerKeyedTimer> s_aHdlKeyedTimer = new CommonsHashMap<String, StatisticsHandlerKeyedTimer>();
    private static final ICommonsMap<String, StatisticsHandlerSize> s_aHdlSize = new CommonsHashMap<String, StatisticsHandlerSize>();
    private static final ICommonsMap<String, StatisticsHandlerKeyedSize> s_aHdlKeyedSize = new CommonsHashMap<String, StatisticsHandlerKeyedSize>();
    private static final ICommonsMap<String, StatisticsHandlerCounter> s_aHdlCounter = new CommonsHashMap<String, StatisticsHandlerCounter>();
    private static final ICommonsMap<String, StatisticsHandlerKeyedCounter> s_aHdlKeyedCounter = new CommonsHashMap<String, StatisticsHandlerKeyedCounter>();
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsManager.class);
    private static final StatisticsManager s_aInstance = new StatisticsManager();

    private StatisticsManager() {
    }

    @Nonnull
    public static IMutableStatisticsHandlerCache getCacheHandler(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return StatisticsManager.getCacheHandler(clazz.getName());
    }

    @Nonnull
    public static IMutableStatisticsHandlerCache getCacheHandler(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Name");
        StatisticsHandlerCache statisticsHandlerCache = s_aRWLockCache.readLockedGet(() -> (StatisticsHandlerCache)s_aHdlCache.get(string));
        if (statisticsHandlerCache == null) {
            statisticsHandlerCache = s_aRWLockCache.writeLockedGet(() -> s_aHdlCache.computeIfAbsent(string, string -> new StatisticsHandlerCache()));
        }
        return statisticsHandlerCache;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllCacheHandler() {
        return s_aRWLockCache.readLockedGet(s_aHdlCache::copyOfKeySet);
    }

    @Nonnull
    public static IMutableStatisticsHandlerTimer getTimerHandler(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return StatisticsManager.getTimerHandler(clazz.getName());
    }

    @Nonnull
    public static IMutableStatisticsHandlerTimer getTimerHandler(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Name");
        StatisticsHandlerTimer statisticsHandlerTimer = s_aRWLockTimer.readLockedGet(() -> (StatisticsHandlerTimer)s_aHdlTimer.get(string));
        if (statisticsHandlerTimer == null) {
            statisticsHandlerTimer = s_aRWLockTimer.writeLockedGet(() -> s_aHdlTimer.computeIfAbsent(string, string -> new StatisticsHandlerTimer()));
        }
        return statisticsHandlerTimer;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllTimerHandler() {
        return s_aRWLockTimer.readLockedGet(s_aHdlTimer::copyOfKeySet);
    }

    @Nonnull
    public static IMutableStatisticsHandlerKeyedTimer getKeyedTimerHandler(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return StatisticsManager.getKeyedTimerHandler(clazz.getName());
    }

    @Nonnull
    public static IMutableStatisticsHandlerKeyedTimer getKeyedTimerHandler(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Name");
        StatisticsHandlerKeyedTimer statisticsHandlerKeyedTimer = s_aRWLockKeyedTimer.readLockedGet(() -> (StatisticsHandlerKeyedTimer)s_aHdlKeyedTimer.get(string));
        if (statisticsHandlerKeyedTimer == null) {
            statisticsHandlerKeyedTimer = s_aRWLockKeyedTimer.writeLockedGet(() -> s_aHdlKeyedTimer.computeIfAbsent(string, string -> new StatisticsHandlerKeyedTimer()));
        }
        return statisticsHandlerKeyedTimer;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllKeyedTimerHandler() {
        return s_aRWLockKeyedTimer.readLockedGet(s_aHdlKeyedTimer::copyOfKeySet);
    }

    @Nonnull
    public static IMutableStatisticsHandlerSize getSizeHandler(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return StatisticsManager.getSizeHandler(clazz.getName());
    }

    @Nonnull
    public static IMutableStatisticsHandlerSize getSizeHandler(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Name");
        StatisticsHandlerSize statisticsHandlerSize = s_aRWLockSize.readLockedGet(() -> (StatisticsHandlerSize)s_aHdlSize.get(string));
        if (statisticsHandlerSize == null) {
            statisticsHandlerSize = s_aRWLockSize.writeLockedGet(() -> s_aHdlSize.computeIfAbsent(string, string -> new StatisticsHandlerSize()));
        }
        return statisticsHandlerSize;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllSizeHandler() {
        return s_aRWLockSize.readLockedGet(s_aHdlSize::copyOfKeySet);
    }

    @Nonnull
    public static IMutableStatisticsHandlerKeyedSize getKeyedSizeHandler(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return StatisticsManager.getKeyedSizeHandler(clazz.getName());
    }

    @Nonnull
    public static IMutableStatisticsHandlerKeyedSize getKeyedSizeHandler(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Name");
        StatisticsHandlerKeyedSize statisticsHandlerKeyedSize = s_aRWLockKeyedSize.readLockedGet(() -> (StatisticsHandlerKeyedSize)s_aHdlKeyedSize.get(string));
        if (statisticsHandlerKeyedSize == null) {
            statisticsHandlerKeyedSize = s_aRWLockKeyedSize.writeLockedGet(() -> s_aHdlKeyedSize.computeIfAbsent(string, string -> new StatisticsHandlerKeyedSize()));
        }
        return statisticsHandlerKeyedSize;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllKeyedSizeHandler() {
        return s_aRWLockKeyedSize.readLockedGet(s_aHdlKeyedSize::copyOfKeySet);
    }

    @Nonnull
    public static IMutableStatisticsHandlerCounter getCounterHandler(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return StatisticsManager.getCounterHandler(clazz.getName());
    }

    @Nonnull
    public static IMutableStatisticsHandlerCounter getCounterHandler(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Name");
        StatisticsHandlerCounter statisticsHandlerCounter = s_aRWLockCounter.readLockedGet(() -> (StatisticsHandlerCounter)s_aHdlCounter.get(string));
        if (statisticsHandlerCounter == null) {
            statisticsHandlerCounter = s_aRWLockCounter.writeLockedGet(() -> s_aHdlCounter.computeIfAbsent(string, string -> new StatisticsHandlerCounter()));
        }
        return statisticsHandlerCounter;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllCounterHandler() {
        return s_aRWLockCounter.readLockedGet(s_aHdlCounter::copyOfKeySet);
    }

    @Nonnull
    public static IMutableStatisticsHandlerKeyedCounter getKeyedCounterHandler(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return StatisticsManager.getKeyedCounterHandler(clazz.getName());
    }

    @Nonnull
    public static IMutableStatisticsHandlerKeyedCounter getKeyedCounterHandler(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Name");
        StatisticsHandlerKeyedCounter statisticsHandlerKeyedCounter = s_aRWLockKeyedCounter.readLockedGet(() -> (StatisticsHandlerKeyedCounter)s_aHdlKeyedCounter.get(string));
        if (statisticsHandlerKeyedCounter == null) {
            statisticsHandlerKeyedCounter = s_aRWLockKeyedCounter.writeLockedGet(() -> s_aHdlKeyedCounter.computeIfAbsent(string, string -> new StatisticsHandlerKeyedCounter()));
        }
        return statisticsHandlerKeyedCounter;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllKeyedCounterHandler() {
        return s_aRWLockKeyedCounter.readLockedGet(s_aHdlKeyedCounter::copyOfKeySet);
    }

    public static void clearCache() {
        s_aRWLockCache.writeLocked(s_aHdlCache::clear);
        s_aRWLockTimer.writeLocked(s_aHdlTimer::clear);
        s_aRWLockKeyedTimer.writeLocked(s_aHdlKeyedTimer::clear);
        s_aRWLockSize.writeLocked(s_aHdlSize::clear);
        s_aRWLockKeyedSize.writeLocked(s_aHdlKeyedSize::clear);
        s_aRWLockCounter.writeLocked(s_aHdlCounter::clear);
        s_aRWLockKeyedCounter.writeLocked(s_aHdlKeyedCounter::clear);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cache was cleared: " + StatisticsManager.class.getName());
        }
    }
}

