/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.regex;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.cache.Cache;
import com.helger.commons.regex.RegExPattern;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.RegEx;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class RegExCache
extends Cache<RegExPattern, Pattern> {
    public static final int MAX_CACHE_SIZE = 1000;
    private static boolean s_bDefaultInstantiated = false;

    private RegExCache() {
        super(RegExPattern::getAsPattern, 1000, RegExCache.class.getName());
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static RegExCache getInstance() {
        RegExCache regExCache = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return regExCache;
    }

    @Nonnull
    public static Pattern getPattern(@Nonnull @RegEx @Nonempty String string) {
        return (Pattern)RegExCache.getInstance().getFromCache(new RegExPattern(string));
    }

    @Nonnull
    public static Pattern getPattern(@Nonnull @RegEx @Nonempty String string, @Nonnegative int n) {
        return (Pattern)RegExCache.getInstance().getFromCache(new RegExPattern(string, n));
    }

    private static final class SingletonHolder {
        private static final RegExCache s_aInstance = new RegExCache();

        private SingletonHolder() {
        }
    }
}

