/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mime;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.mime.EMimeQuoting;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class MimeTypeParameter
implements Serializable {
    private final String m_sAttribute;
    private final String m_sValue;
    private final boolean m_bValueRequiresQuoting;

    public MimeTypeParameter(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.isTrue(MimeTypeParser.isToken(string), () -> "MimeType parameter name is not a valid token: " + string);
        ValueEnforcer.notNull(string2, "Value");
        this.m_sAttribute = string;
        this.m_sValue = string2;
        this.m_bValueRequiresQuoting = !MimeTypeParser.isToken(string2);
    }

    @Nonnull
    @Nonempty
    public String getAttribute() {
        return this.m_sAttribute;
    }

    @Nonnull
    public String getValue() {
        return this.m_sValue;
    }

    public boolean isValueRequiringQuoting() {
        return this.m_bValueRequiresQuoting;
    }

    @Nonnull
    @Nonempty
    public String getValueQuotedIfNecessary(@Nonnull EMimeQuoting eMimeQuoting) {
        return this.m_bValueRequiresQuoting ? eMimeQuoting.getQuotedString(this.m_sValue) : this.m_sValue;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MimeTypeParameter mimeTypeParameter = (MimeTypeParameter)object;
        return this.m_sAttribute.equals(mimeTypeParameter.m_sAttribute) && this.m_sValue.equals(mimeTypeParameter.m_sValue);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sAttribute).append(this.m_sValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("Attribute", this.m_sAttribute).append("Value", this.m_sValue).append("ValueRequiresQuoting", this.m_bValueRequiresQuoting).getToString();
    }
}

