/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.gfx;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.collection.map.LRUMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.dimension.SizeInt;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.state.EChange;
import com.helger.commons.statistics.IMutableStatisticsHandlerCache;
import com.helger.commons.statistics.StatisticsManager;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class ImageDataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageDataManager.class);
    private static final IMutableStatisticsHandlerCache s_aStatsHdl = StatisticsManager.getCacheHandler(ImageDataManager.class);
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<IReadableResource, SizeInt> m_aImageData;
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<IReadableResource> m_aNonExistingResources = new CommonsHashSet<IReadableResource>();

    private ImageDataManager(@Nonnegative int n) {
        this.m_aImageData = new LRUMap<IReadableResource, SizeInt>(n);
    }

    public static boolean isInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static ImageDataManager getInstance() {
        ImageDataManager imageDataManager = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return imageDataManager;
    }

    @Nullable
    private static SizeInt _readImageData(@Nonnull IHasInputStream iHasInputStream) {
        SizeInt sizeInt = null;
        try (InputStream inputStream = iHasInputStream.getInputStream();){
            if (inputStream != null) {
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                if (bufferedImage != null) {
                    sizeInt = new SizeInt(bufferedImage.getWidth(), bufferedImage.getHeight());
                } else if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Does not seem to be an image resource: " + iHasInputStream);
                }
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Failed to resolve image resource: " + iHasInputStream);
            }
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError linkageError) {
            LOGGER.error("Seems like no AWT binding is present", (Throwable)linkageError);
        }
        catch (IIOException iIOException) {
            LOGGER.error("Failed to interprete image data from resource " + iHasInputStream + ": " + iIOException.getMessage());
        }
        catch (IOException iOException) {
            LOGGER.error("Failed to read image data from resource " + iHasInputStream, (Throwable)iOException);
        }
        catch (AccessControlException accessControlException) {
            LOGGER.error("Whatsoever on " + iHasInputStream, (Throwable)accessControlException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.error("Failed to read image data from resource " + iHasInputStream + ": " + illegalArgumentException.getMessage());
        }
        return sizeInt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SizeInt getImageSize(@Nullable IReadableResource iReadableResource) {
        SizeInt sizeInt;
        if (iReadableResource == null) {
            return null;
        }
        this.m_aRWLock.readLock().lock();
        try {
            sizeInt = (SizeInt)this.m_aImageData.get(iReadableResource);
            if (sizeInt != null) {
                s_aStatsHdl.cacheHit();
                SizeInt sizeInt2 = sizeInt;
                return sizeInt2;
            }
            if (this.m_aNonExistingResources.contains(iReadableResource)) {
                s_aStatsHdl.cacheHit();
                SizeInt sizeInt3 = null;
                return sizeInt3;
            }
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
        sizeInt = ImageDataManager._readImageData(iReadableResource);
        this.m_aRWLock.writeLocked(() -> {
            if (sizeInt == null) {
                this.m_aNonExistingResources.add(iReadableResource);
            } else {
                this.m_aImageData.put(iReadableResource, sizeInt);
            }
            s_aStatsHdl.cacheMiss();
        });
        return sizeInt;
    }

    @Nonnull
    public EChange clearCachedSize(@Nullable IReadableResource iReadableResource) {
        if (iReadableResource == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aRWLock.writeLockedGet(() -> {
            if (this.m_aImageData.remove(iReadableResource) != null) {
                return EChange.CHANGED;
            }
            if (this.m_aNonExistingResources.remove(iReadableResource)) {
                return EChange.CHANGED;
            }
            return EChange.UNCHANGED;
        });
    }

    @Nonnull
    public EChange clearCache() {
        return this.m_aRWLock.writeLockedGet(() -> {
            if (this.m_aImageData.isEmpty() && this.m_aNonExistingResources.isEmpty()) {
                return EChange.UNCHANGED;
            }
            this.m_aImageData.clear();
            this.m_aNonExistingResources.clear();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cache was cleared: " + ImageDataManager.class.getName());
            }
            return EChange.CHANGED;
        });
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<IReadableResource, SizeInt> getAllCachedSizes() {
        return this.m_aRWLock.readLockedGet(this.m_aImageData::getClone);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<IReadableResource> getAllNotExistingResources() {
        return this.m_aRWLock.readLockedGet(this.m_aNonExistingResources::getClone);
    }

    private static final class SingletonHolder {
        private static final ImageDataManager s_aInstance = new ImageDataManager(1000);

        private SingletonHolder() {
        }
    }
}

