#pragma once

#include <redasm/types/base.h>

namespace REDasm {

namespace AVR8Operands  {

enum {
    None,
    Register, RegisterStartR16,
    RegisterEvenPair, RegisterEvenPairStartR24,
    BranchAddress, RelativeAddress, LongAbsoluteAddress,
    IORegister, Data, DESRound, Bit,
    X, XP, MX,
    Y, YP, MY, YPQ,
    Z, ZP, MZ, ZPQ,
    RawWord, RawByte,
};

}

namespace AVR8Opcodes {

enum: u16 {
    Break_9598  = 0x9598,
    Clc_9488    = 0x9488,
    Clh_94d8    = 0x94d8,
    Cli_94f8    = 0x94f8,
    Cln_94a8    = 0x94a8,
    Cls_94c8    = 0x94c8,
    Clt_94e8    = 0x94e8,
    Clv_94b8    = 0x94b8,
    Clz_9498    = 0x9498,
    Eicall_9519 = 0x9519,
    Eijmp_9419  = 0x9419,
    Elpm_95d8   = 0x95d8,
    Icall_9509  = 0x9509,
    Ijmp_9409   = 0x9409,
    Lpm_95c8    = 0x95c8,
    Nop_0000    = 0x0000,
    Ret_9508    = 0x9508,
    Reti_9518   = 0x9518,
    Sec_9408    = 0x9408,
    Seh_9458    = 0x9458,
    Sei_9478    = 0x9478,
    Sen_9428    = 0x9428,
    Ses_9448    = 0x9448,
    Set_9468    = 0x9468,
    Sev_9438    = 0x9438,
    Sez_9418    = 0x9418,
    Sleep_9588  = 0x9588,
    Spm_95e8    = 0x95e8,
    Spm_95f8    = 0x95f8,
    Wdr_95a8    = 0x95a8,
    Des_940b    = 0x940b,
    Asr_9405    = 0x9405,
    Bclr_9488   = 0x9488,
    Brcc_f400   = 0xf400,
    Brcs_f000   = 0xf000,
    Breq_f001   = 0xf001,
    Brge_f404   = 0xf404,
    Brhc_f405   = 0xf405,
    Brhs_f005   = 0xf005,
    Brid_f407   = 0xf407,
    Brie_f007   = 0xf007,
    Brlo_f000   = 0xf000,
    Brlt_f004   = 0xf004,
    Brmi_f002   = 0xf002,
    Brne_f401   = 0xf401,
    Brpl_f402   = 0xf402,
    Brsh_f400   = 0xf400,
    Brtc_f406   = 0xf406,
    Brts_f006   = 0xf006,
    Brvc_f403   = 0xf403,
    Brvs_f003   = 0xf003,
    Bset_9408   = 0x9408,
    Call_940e   = 0x940e,
    Com_9400    = 0x9400,
    Dec_940a    = 0x940a,
    Inc_9403    = 0x9403,
    Jmp_940c    = 0x940c,
    Lpm_9004    = 0x9004,
    Lpm_9005    = 0x9005,
    Lsr_9406    = 0x9406,
    Neg_9401    = 0x9401,
    Pop_900f    = 0x900f,
    Xch_9204    = 0x9204,
    Las_9205    = 0x9205,
    Lac_9206    = 0x9206,
    Lat_9207    = 0x9207,
    Push_920f   = 0x920f,
    Rcall_d000  = 0xd000,
    Rjmp_c000   = 0xc000,
    Ror_9407    = 0x9407,
    Ser_ef0f    = 0xef0f,
    Swap_9402   = 0x9402,
    Adc_1c00    = 0x1c00,
    Add_0c00    = 0x0c00,
    Adiw_9600   = 0x9600,
    And_2000    = 0x2000,
    Andi_7000   = 0x7000,
    Bld_f800    = 0xf800,
    Brbc_f400   = 0xf400,
    Brbs_f000   = 0xf000,
    Bst_fa00    = 0xfa00,
    Cbi_9800    = 0x9800,
    Cp_1400     = 0x1400,
    Cpc_0400    = 0x0400,
    Cpi_3000    = 0x3000,
    Cpse_1000   = 0x1000,
    Elpm_9006   = 0x9006,
    Elpm_9007   = 0x9007,
    Eor_2400    = 0x2400,
    Fmul_0308   = 0x0308,
    Fmuls_0380  = 0x0380,
    Fmulsu_0388 = 0x0388,
    In_b000     = 0xb000,
    Ld_900c     = 0x900c,
    Ld_900d     = 0x900d,
    Ld_900e     = 0x900e,
    Ld_8008     = 0x8008,
    Ld_9009     = 0x9009,
    Ld_900a     = 0x900a,
    Ld_8000     = 0x8000,
    Ld_9001     = 0x9001,
    Ld_9002     = 0x9002,
    Ldd_8008    = 0x8008,
    Ldd_8000    = 0x8000,
    Ldi_e000    = 0xe000,
    Lds_9000    = 0x9000,
    Lds_a000    = 0xa000,
    Mov_2c00    = 0x2c00,
    Movw_0100   = 0x0100,
    Mul_9c00    = 0x9c00,
    Muls_0200   = 0x0200,
    Mulsu_0300  = 0x0300,
    Or_2800     = 0x2800,
    Ori_6000    = 0x6000,
    Out_b800    = 0xb800,
    Sbc_0800    = 0x0800,
    Sbci_4000   = 0x4000,
    Sbi_9a00    = 0x9a00,
    Sbic_9900   = 0x9900,
    Sbis_9b00   = 0x9b00,
    Sbiw_9700   = 0x9700,
    Sbr_6000    = 0x6000,
    Sbrc_fc00   = 0xfc00,
    Sbrs_fe00   = 0xfe00,
    St_920c     = 0x920c,
    St_920d     = 0x920d,
    St_920e     = 0x920e,
    St_8208     = 0x8208,
    St_9209     = 0x9209,
    St_920a     = 0x920a,
    St_8200     = 0x8200,
    St_9201     = 0x9201,
    St_9202     = 0x9202,
    Std_8208    = 0x8208,
    Std_8200    = 0x8200,
    Sts_9200    = 0x9200,
    Sts_a800    = 0xa800,
    Sub_1800    = 0x1800,
    Subi_5000   = 0x5000,
};

} // namespace AVR8Opcodes
} // namespace REDasm
