#pragma once

#include <forward_list>
#include <string>
#include <list>
#include <redasm/types/base.h>

namespace REDasm {

struct AVR8Operand { u16 mask; u64 tag; };

struct AVR8Instruction
{
    u16 mask;
    instruction_id_t id;
    std::string mnemonic;
    u64 size;
    std::list<AVR8Operand> operands;
};

class AVR8Decoder
{
    public:
        AVR8Decoder() = delete;
        static const AVR8Instruction *get(u16 opcode);

    private:
        static void initializeInstructions();

    private:
        static std::forward_list<AVR8Instruction> m_avrinstructions;
};

} // namespace REDasm
