// Copyright (c) 2018-2021 Dr. Colin Hirsch and Daniel Frey
// Please see LICENSE for license or visit https://github.com/taocpp/json/

#ifndef TAO_JSON_EVENTS_HPP
#define TAO_JSON_EVENTS_HPP

// Events producers
#include "events/from_file.hpp"
#include "events/from_input.hpp"
#include "events/from_stream.hpp"
#include "events/from_string.hpp"
#include "events/from_value.hpp"
#include "events/produce.hpp"

// Events consumers
#include "events/to_pretty_stream.hpp"
#include "events/to_stream.hpp"
#include "events/to_string.hpp"
#include "events/to_value.hpp"

// Events transformers
#include "events/binary_to_base64.hpp"
#include "events/binary_to_base64url.hpp"
#include "events/binary_to_exception.hpp"
#include "events/binary_to_hex.hpp"
#include "events/invalid_string_to_binary.hpp"
#include "events/invalid_string_to_exception.hpp"
#include "events/invalid_string_to_hex.hpp"
#include "events/key_camel_case_to_snake_case.hpp"
#include "events/key_snake_case_to_camel_case.hpp"
#include "events/limit_nesting_depth.hpp"
#include "events/limit_value_count.hpp"
#include "events/non_finite_to_exception.hpp"
#include "events/non_finite_to_null.hpp"
#include "events/non_finite_to_string.hpp"
#include "events/prefer_signed.hpp"
#include "events/prefer_unsigned.hpp"

// Events other
#include "events/debug.hpp"
#include "events/discard.hpp"
#include "events/hash.hpp"
#include "events/tee.hpp"
#include "events/validate_event_order.hpp"
#include "events/validate_keys.hpp"

#endif
