function(disable_warnings_for HEADERS SOURCES)
    if("${CMAKE_CXX_COMPILER_ID}" STREQUAL "GNU")
        set_source_files_properties(${HEADERS} PROPERTIES COMPILE_OPTIONS -w)
        set_source_files_properties(${SOURCES} PROPERTIES COMPILE_OPTIONS -w)
    endif()
endfunction()
 
function(check_ccache_and_ld)
    if(UNIX AND NOT APPLE)
        find_program(CCACHE_PROGRAM ccache)
        if(CCACHE_PROGRAM AND (CMAKE_GENERATOR STREQUAL "Ninja" OR CMAKE_GENERATOR STREQUAL "Unix Makefiles"))
            message(STATUS "${PROJECT_NAME}: Found CCache, speed up compilation")
            set(CMAKE_C_COMPILER_LAUNCHER   ${CCACHE_PROGRAM})
            set(CMAKE_CXX_COMPILER_LAUNCHER ${CCACHE_PROGRAM})
        endif()

        execute_process(COMMAND ${CMAKE_CXX_COMPILER} -fuse-ld=gold -Wl,--version ERROR_QUIET OUTPUT_VARIABLE ld_version)
        if("${ld_version}" MATCHES "GNU gold")
            message(STATUS "${PROJECT_NAME}: Found Gold linker, use faster linker")
            set(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} -fuse-ld=gold")
            set(CMAKE_SHARED_LINKER_FLAGS "${CMAKE_SHARED_LINKER_FLAGS} -fuse-ld=gold ")
        endif()
    endif()
endfunction()

function(check_documentation)
    find_package(Python)

    if(Python_FOUND)
        set(RDAPI_DOC_GEN ${CMAKE_CURRENT_SOURCE_DIR}/docs/gendoc.py)
        set(RDAPI_DOC_IN  ${CMAKE_CURRENT_SOURCE_DIR}/rdapi)
        set(RDAPI_DOC_OUT ${CMAKE_CURRENT_BINARY_DIR}/docs)
        message("Generating documentation")
        execute_process(COMMAND ${CMAKE_COMMAND} -E make_directory ${RDAPI_DOC_OUT})
        execute_process(COMMAND ${Python_EXECUTABLE} ${RDAPI_DOC_GEN} ${RDAPI_DOC_IN} ${RDAPI_DOC_OUT})
    else(Python_FOUND)
        message("Python not found, cannot generate documentation")
    endif(Python_FOUND)
endfunction()
