.TH "gmusicbrowser" "1" "Nov 18, 2020" "gmusicbrowser" ""
.SH "NAME"
gmusicbrowser \- Jukebox for large collections of music files

.SH "SYNOPSIS"
.B gmusicbrowser
.RI
[\-nocheck]
[\-noscan]
[\-demo]
[\-ro]
[\-rotags]
[\-play]
[\-nodbus]
[\-gst0|\-nogst]
[\-server]
[\-port N]
[\-cfg FILE]
[\-fifo FIFO|\-nofifo]
[\-debug]
[\-verbose]
[\-layout NAME]
[\-plugin NAME]
[\-searchpath FOLDER]
[\-use\-gnome\-session]
[\-workspace N]
[\-cmd CMD]
[\-ifnotrunning MODE]
[\-dbus\-id KEY]
FOLDER_OR_FILE ...
.br

.B gmusicbrowser
.RI
\-listcmd

.B gmusicbrowser
.RI
\-tagedit FOLDER_OR_FILE ...

.SH "DESCRIPTION"
This manual page explains the
.B gmusicbrowser
program.
.PP
\fBgmusicbrowser\fP can play and manage your songs, currently supports mp3, ogg, flac, mpc file formats.
see http://gmusicbrowser.sourceforge.net/ for more information.
.SH "OPTIONS"
.B
.TP
\fB\-c\fR, \fB\-nocheck\fR
don't check for updated/deleted songs on startup
.TP
\fB\-s\fR, \fB\-noscan\fR
don't scan folders for songs on startup
.TP
\fB\-demo\fR
don't save settings/tags on exit
.TP
\fB\-ro\fR
prevent modifying/renaming/deleting song files
.TP
\fB\-rotags\fR
prevent modifying tags of music files
.TP
\fB\-play\fR
start playing on startup
.TP
\fB\-nogst\fR
do not load any gstreamer librairies
.TP
\fB\-gst0\fR
prefer gstreamer\-0.10 over gstreamer\-1.x if both are available
.TP
\fB\-nodbus\fR
do not use DBus
.TP
\fB\-server\fR
send playing song to connected icecast client
.TP
\fB\-port N\fR
listen for connection on port N in icecast server mode
.TP
\fB\-C FILE\fR, \fB\-cfg FILE\fR
use FILE as configuration file (instead of 'gmbrc' in default folder),
if FILE is a folder (or ends with '/'), it will be used as base folder instead of ~/.config/gmusicbrowser/
.TP
\fB\-F FIFO\fR, \fB\-fifo FIFO\fR
use FIFO as named pipe to receive commans (instead of 'gmusicbrowser.fifo' in default folder)
.TP
\fB\-nofifo\fR
do not use/create named pipe
.TP
\fB\-dbus\-id KEY\fR
append .KEY to the DBus service id used by gmusicbrowser (org.gmusicbrowser)
.TP
\fB\-verbose\fR
print some info, like the file being played
.TP
\fB\-debug\fR
print lots of useless information, implies \-verbose
.TP
\fB\-backtrace\fR
print a backtrace for every warning
.TP
\fB\-l NAME\fR, \fB\-layout NAME\fR
use layout NAME for player window
.TP
\fB\-plugin NAME\fR
deactivate plugin identified by NAME
.TP
\fB\+plugin NAME\fR
activate plugin identified by NAME
.TP
\fB\-noplugins\fR
deactivate all plugins
.TP
\fB\-searchpath FOLDER\fR
add FOLDER to the list of folders searched for plugins and layouts
.TP
\fB\-use\-gnome\-session\fR
Use gnome libraries to save tags/settings on session logout (needs the Gnome2 perl module).
.TP
\fB\-workspace N\fR
Move initial window to workspace N (needs the Gnome2::Wnck perl module).
.TP
\fB\-cmd CMD\fR
add CMD to the list of commands to execute. If a running instance of gmusicbrowser is found, these commands will be sent via the fifo file or via DBus. If there is no running instance of gmusicbrowser, the behavior depends on option \-ifnotrunning
.TP

\fB\-ifnotrunning MODE\fR
change behavior when no running gmusicbrowser instance is found, MODE can be one of :
.RS
.IP \fInormal\fR
(default) launch a new instance and execute commands
.IP \fInocmd\fR
launch a new instance but discard commands
.IP \fIabort\fR
do nothing
.RE
.RS
Running instances of gmusicbrowser are detected via the fifo or via DBus.
To run more than one instance, use a unique fifo and a unique DBus\-id, or deactivate them.
.RE

.TP
\fB\-listcmd\fR
list the available commands and exit
.TP
\fB\-listlayout\fR
list the available layouts and exit
.TP
\fB\-listplugin\fR
list the available plugins and exit
.TP
\fB\-tagedit FOLDER_OR_FILE ...\fR
Load songs in FOLDER_OR_FILE and display a dialog to edit their tags.

.SH FILES
.TP
\fI~/.gmusicbrowser/tags\fP
contains songs tags and program options
.TP
\fI/usr/share/gmusicbrowser/plugins/\fP, \fI~/.gmusicbrowser/plugins/\fP
files with extension .pm in these folders are loaded as plugins on startup
.TP
\fI/usr/share/gmusicbrowser/layouts/*.layout\fP, \fI~/.gmusicbrowser/layouts/*.layout\fP
contains layouts definitions
.TP
\fI~/.gmusicbrowser/gmusicbrowser.fifo\fP
can be used to send commands to a running gmusicbrowser,
eg : echo CMD >~/.gmusicbrowser/gmusicbrowser.fifo where CMD is (run "gmusicbrowser \-listcmd" for an up-to-date list of commands) :
.TP
\fBNextSong\fR
Skip current song
.TP
\fBPrevSong\fR
choose previously played song
.TP
\fBPlayPause\fR
toggle Play/Pause mode
.TP
\fBStop\fR
stop playing
.TP
\fBRewind\fR SEC
rewind SEC seconds
.TP
\fBForward\fR SEC
forward SEC seconds
.TP
\fBBrowser\fR
open browser window
.TP
\fBShowHide\fR
hide/show gmusicbrowser windows
.TP
\fBQuit\fR
quit gmusicbrowser
.TP
\fBSave\fR
immediately save settings/song tags in ~/.gmusicbrowser/tags
.TP
\fBChangeDisplay\fR DISPLAY
migrate the program to display DISPLAY (example : ":1")

.SH "SEE ALSO"
http://gmusicbrowser.org/,

.SH "AUTHOR"
Copyright (c) 2005-2020 Quentin Sculo <squentin@free.fr>
