/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqlx.devapi;

import com.mysql.cj.api.result.Row;
import com.mysql.cj.core.exceptions.DataReadException;
import com.mysql.cj.core.io.BigDecimalValueFactory;
import com.mysql.cj.core.io.BooleanValueFactory;
import com.mysql.cj.core.io.ByteValueFactory;
import com.mysql.cj.core.io.DbDocValueFactory;
import com.mysql.cj.core.io.DoubleValueFactory;
import com.mysql.cj.core.io.IntegerValueFactory;
import com.mysql.cj.core.io.LongValueFactory;
import com.mysql.cj.core.io.StringValueFactory;
import com.mysql.cj.x.json.DbDoc;
import java.math.BigDecimal;
import java.util.Map;
import java.util.function.Supplier;

public class RowImpl
implements com.mysql.cj.api.x.Row {
    private Row row;
    private Supplier<Map<String, Integer>> lazyFieldNameToIndex;

    public RowImpl(Row row, Supplier<Map<String, Integer>> lazyFieldNameToIndex) {
        this.row = row;
        this.lazyFieldNameToIndex = lazyFieldNameToIndex;
    }

    private int fieldNameToIndex(String fieldName) {
        Integer idx = this.lazyFieldNameToIndex.get().get(fieldName);
        if (idx == null) {
            throw new DataReadException("Invalid column");
        }
        return idx;
    }

    @Override
    public BigDecimal getBigDecimal(String fieldName) {
        return this.getBigDecimal(this.fieldNameToIndex(fieldName));
    }

    @Override
    public BigDecimal getBigDecimal(int pos) {
        return this.row.getValue(pos, new BigDecimalValueFactory());
    }

    @Override
    public boolean getBoolean(String fieldName) {
        return this.getBoolean(this.fieldNameToIndex(fieldName));
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.row.getValue(pos, new BooleanValueFactory());
    }

    @Override
    public byte getByte(String fieldName) {
        return this.getByte(this.fieldNameToIndex(fieldName));
    }

    @Override
    public byte getByte(int pos) {
        return this.row.getValue(pos, new ByteValueFactory());
    }

    @Override
    public DbDoc getDbDoc(String fieldName) {
        return this.getDbDoc(this.fieldNameToIndex(fieldName));
    }

    @Override
    public DbDoc getDbDoc(int pos) {
        return this.row.getValue(pos, new DbDocValueFactory());
    }

    @Override
    public double getDouble(String fieldName) {
        return this.getDouble(this.fieldNameToIndex(fieldName));
    }

    @Override
    public double getDouble(int pos) {
        return this.row.getValue(pos, new DoubleValueFactory());
    }

    @Override
    public int getInt(String fieldName) {
        return this.getInt(this.fieldNameToIndex(fieldName));
    }

    @Override
    public int getInt(int pos) {
        return this.row.getValue(pos, new IntegerValueFactory());
    }

    @Override
    public long getLong(String fieldName) {
        return this.getLong(this.fieldNameToIndex(fieldName));
    }

    @Override
    public long getLong(int pos) {
        return this.row.getValue(pos, new LongValueFactory());
    }

    @Override
    public String getString(String fieldName) {
        return this.getString(this.fieldNameToIndex(fieldName));
    }

    @Override
    public String getString(int pos) {
        return this.row.getValue(pos, new StringValueFactory());
    }
}

