#include "kfilecoder.h"
#include "ExtractDialog.h"

#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>
#include <kmessagebox.h>

#include <qwindowdefs.h>
#include <qpushbutton.h>
#include <qfiledialog.h>
#include <qlineedit.h>
#include <qmessagebox.h>
#include <qpushbt.h>
#include <qdir.h>

extern KLocale *locale;

// ===========================================================================================================================
ExtractDialog::ExtractDialog( QWidget *parent, const char *name):QDialog(parent,name,TRUE)
{
  m_mainWnd = parent;
  *m_szDestDir = 0; // If the program use password and user click cancel

  m_btnOk = new QPushButton("Ok", this);
  CHECK_PTR( m_btnOk );
  m_btnOk -> setGeometry(100,130,100,30);

  m_btnCancel = new QPushButton("Cancel", this);
  CHECK_PTR( m_btnCancel );
  m_btnCancel -> setGeometry(300,130,100,30);

  m_btnBrowse = new QPushButton("Browse...", this);
  CHECK_PTR( m_btnBrowse );
  m_btnBrowse -> setGeometry(20,70,100,25);

	m_editDestDir = new QLineEdit(this);
  CHECK_PTR( m_editDestDir );
  m_editDestDir -> setGeometry(150,70,300,25);
	m_editDestDir -> setText("/");

  m_label = new QLabel(i18n("Please, enter the destination directory where KFileCoder will decode files:"), this);
  CHECK_PTR( m_label );
  m_label -> setGeometry(30,10,450,40);
	
  connect(m_btnOk,SIGNAL(clicked()),this,SLOT(slotOk()));
  connect(m_btnCancel,SIGNAL(clicked()),this,SLOT(slotCancel()));
  connect(m_btnBrowse,SIGNAL(clicked()),this,SLOT(slotBrowse()));
}

// ===========================================================================================================================
ExtractDialog::~ExtractDialog()
{	delete m_btnOk;
 	delete m_btnCancel;
	delete m_btnBrowse;
 	delete m_editDestDir;
	delete m_label;
}

// ===========================================================================================================================
char *ExtractDialog::getDestinationDirectory()
{
	return m_szDestDir;
}

// ===========================================================================================================================
void ExtractDialog::slotOk()
{	QDir qDir;

	// Rcuprer le dossier de destination
	sprintf (m_szDestDir, "%s", m_editDestDir -> text().data() );
   	
	// If directoryname is finised by '/', delete it
	if (m_szDestDir[strlen(m_szDestDir)-1] == '/')
		m_szDestDir[strlen(m_szDestDir)-1] = '\0'; // End of string

  this -> done(0);
}

// ===========================================================================================================================
void ExtractDialog::slotCancel()
{	this->done(-1);
}

// ===========================================================================================================================
void ExtractDialog::slotBrowse()
{	QFileDialog dlg;	
  QString strDir;

	strDir = dlg.getExistingDirectory();
	if (strDir.isEmpty())
		return ;

	m_editDestDir -> setText(strDir);
}





























