/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GIMP_PAINTBRUSH_H__
#define __GIMP_PAINTBRUSH_H__


#include "gimpbrushcore.h"


#define GIMP_TYPE_PAINTBRUSH            (gimp_paintbrush_get_type ())
#define GIMP_PAINTBRUSH(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GIMP_TYPE_PAINTBRUSH, GimpPaintbrush))
#define GIMP_PAINTBRUSH_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GIMP_TYPE_PAINTBRUSH, GimpPaintbrushClass))
#define GIMP_IS_PAINTBRUSH(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GIMP_TYPE_PAINTBRUSH))
#define GIMP_IS_PAINTBRUSH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GIMP_TYPE_PAINTBRUSH))
#define GIMP_PAINTBRUSH_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), GIMP_TYPE_PAINTBRUSH, GimpPaintbrushClass))


typedef struct _GimpPaintbrush      GimpPaintbrush;
typedef struct _GimpPaintbrushClass GimpPaintbrushClass;

struct _GimpPaintbrush
{
  GimpBrushCore parent_instance;
};

struct _GimpPaintbrushClass
{
  GimpBrushCoreClass parent_class;
};


void    gimp_paintbrush_register (Gimp                      *gimp,
                                  GimpPaintRegisterCallback  callback);

GType   gimp_paintbrush_get_type (void) G_GNUC_CONST;


/*  protected  */

void    _gimp_paintbrush_motion  (GimpPaintCore             *paint_core,
                                  GimpDrawable              *drawable,
                                  GimpPaintOptions          *paint_options,
                                  gdouble                    opacity);


#endif  /*  __GIMP_PAINTBRUSH_H__  */
