/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2000 Peter Mattis and Spencer Kimball
 *
 * gimpmisctools_pdb.c
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* NOTE: This file is autogenerated by pdbgen.pl */

#include "config.h"

#include "gimp.h"

/**
 * gimp_blend:
 * @drawable_ID: The affected drawable.
 * @blend_mode: The type of blend.
 * @paint_mode: The paint application mode.
 * @gradient_type: The type of gradient.
 * @opacity: The opacity of the final blend.
 * @offset: Offset relates to the starting and ending coordinates specified for the blend. This parameter is mode dependent.
 * @repeat: Repeat mode.
 * @supersample: Do adaptive supersampling.
 * @max_depth: Maximum recursion levels for supersampling.
 * @threshold: Supersampling threshold.
 * @x1: The x coordinate of this blend's starting point.
 * @y1: The y coordinate of this blend's starting point.
 * @x2: The x coordinate of this blend's ending point.
 * @y2: The y coordinate of this blend's ending point.
 *
 * Blend between the starting and ending coordinates with the specified
 * blend mode and gradient type.
 *
 * This tool requires information on the paint application mode, the
 * blend mode, and the gradient type. It creates the specified variety
 * of blend using the starting and ending coordinates as defined for
 * each gradient type.
 *
 * Returns: TRUE on success.
 */
gboolean
gimp_blend (gint32               drawable_ID,
	    GimpBlendMode        blend_mode,
	    GimpLayerModeEffects paint_mode,
	    GimpGradientType     gradient_type,
	    gdouble              opacity,
	    gdouble              offset,
	    GimpRepeatMode       repeat,
	    gboolean             supersample,
	    gint                 max_depth,
	    gdouble              threshold,
	    gdouble              x1,
	    gdouble              y1,
	    gdouble              x2,
	    gdouble              y2)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp_blend",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, blend_mode,
				    GIMP_PDB_INT32, paint_mode,
				    GIMP_PDB_INT32, gradient_type,
				    GIMP_PDB_FLOAT, opacity,
				    GIMP_PDB_FLOAT, offset,
				    GIMP_PDB_INT32, repeat,
				    GIMP_PDB_INT32, supersample,
				    GIMP_PDB_INT32, max_depth,
				    GIMP_PDB_FLOAT, threshold,
				    GIMP_PDB_FLOAT, x1,
				    GIMP_PDB_FLOAT, y1,
				    GIMP_PDB_FLOAT, x2,
				    GIMP_PDB_FLOAT, y2,
				    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_bucket_fill:
 * @drawable_ID: The affected drawable.
 * @fill_mode: The type of fill.
 * @paint_mode: The paint application mode.
 * @opacity: The opacity of the final bucket fill.
 * @threshold: The threshold determines how extensive the seed fill will be. It's value is specified in terms of intensity levels . This parameter is only valid when there is no selection in the specified image.
 * @sample_merged: Use the composite image, not the drawable.
 * @x: The x coordinate of this bucket fill's application. This parameter is only valid when there is no selection in the specified image.
 * @y: The y coordinate of this bucket fill's application. This parameter is only valid when there is no selection in the specified image.
 *
 * Fill the area specified either by the current selection if there is
 * one, or by a seed fill starting at the specified coordinates.
 *
 * This tool requires information on the paint application mode, and
 * the fill mode, which can either be in the foreground color, or in
 * the currently active pattern. If there is no selection, a seed fill
 * is executed at the specified coordinates and extends outward in
 * keeping with the threshold parameter. If there is a selection in the
 * target image, the threshold, sample merged, x, and y arguments are
 * unused. If the sample_merged parameter is non-zero, the data of the
 * composite image will be used instead of that for the specified
 * drawable. This is equivalent to sampling for colors after merging
 * all visible layers. In the case of merged sampling, the x,y
 * coordinates are relative to the image's origin; otherwise, they are
 * relative to the drawable's origin.
 *
 * Returns: TRUE on success.
 */
gboolean
gimp_bucket_fill (gint32               drawable_ID,
		  GimpBucketFillMode   fill_mode,
		  GimpLayerModeEffects paint_mode,
		  gdouble              opacity,
		  gdouble              threshold,
		  gboolean             sample_merged,
		  gdouble              x,
		  gdouble              y)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp_bucket_fill",
				    &nreturn_vals,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_INT32, fill_mode,
				    GIMP_PDB_INT32, paint_mode,
				    GIMP_PDB_FLOAT, opacity,
				    GIMP_PDB_FLOAT, threshold,
				    GIMP_PDB_INT32, sample_merged,
				    GIMP_PDB_FLOAT, x,
				    GIMP_PDB_FLOAT, y,
				    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}

/**
 * gimp_color_picker:
 * @image_ID: The image.
 * @drawable_ID: The affected drawable.
 * @x: x coordinate of upper-left corner of rectangle.
 * @y: y coordinate of upper-left corner of rectangle.
 * @sample_merged: Use the composite image, not the drawable.
 * @sample_average: Average the color of all the pixels in a specified radius.
 * @average_radius: The radius of pixels to average.
 * @color: The return color.
 *
 * Determine the color at the given drawable coordinates
 *
 * This tool determines the color at the specified coordinates. The
 * returned color is an RGB triplet even for grayscale and indexed
 * drawables. If the coordinates lie outside of the extents of the
 * specified drawable, then an error is returned. If the drawable has
 * an alpha channel, the algorithm examines the alpha value of the
 * drawable at the coordinates. If the alpha value is completely
 * transparent (0), then an error is returned. If the sample_merged
 * parameter is non-zero, the data of the composite image will be used
 * instead of that for the specified drawable. This is equivalent to
 * sampling for colors after merging all visible layers. In the case of
 * a merged sampling, the supplied drawable is ignored.
 *
 * Returns: TRUE on success.
 */
gboolean
gimp_color_picker (gint32    image_ID,
		   gint32    drawable_ID,
		   gdouble   x,
		   gdouble   y,
		   gboolean  sample_merged,
		   gboolean  sample_average,
		   gdouble   average_radius,
		   GimpRGB  *color)
{
  GimpParam *return_vals;
  gint nreturn_vals;
  gboolean success = TRUE;

  return_vals = gimp_run_procedure ("gimp_color_picker",
				    &nreturn_vals,
				    GIMP_PDB_IMAGE, image_ID,
				    GIMP_PDB_DRAWABLE, drawable_ID,
				    GIMP_PDB_FLOAT, x,
				    GIMP_PDB_FLOAT, y,
				    GIMP_PDB_INT32, sample_merged,
				    GIMP_PDB_INT32, sample_average,
				    GIMP_PDB_FLOAT, average_radius,
				    GIMP_PDB_END);

  success = return_vals[0].data.d_status == GIMP_PDB_SUCCESS;

  if (success)
    *color = return_vals[1].data.d_color;

  gimp_destroy_params (return_vals, nreturn_vals);

  return success;
}
