/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.parser;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.ExecutionFlowUtils;
import org.eclipse.wb.core.eval.ExecutionFlowUtils2;
import org.eclipse.wb.core.eval.ExpressionValue;
import org.eclipse.wb.core.model.IRootProcessor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.CompoundAssociation;
import org.eclipse.wb.core.model.association.ConstructorChildAssociation;
import org.eclipse.wb.core.model.association.ConstructorParentAssociation;
import org.eclipse.wb.core.model.association.InvocationChildArrayAssociation;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.core.model.association.InvocationChildEllipsisAssociation;
import org.eclipse.wb.core.model.association.InvocationSecondaryAssociation;
import org.eclipse.wb.core.model.association.RootAssociation;
import org.eclipse.wb.core.model.association.SuperConstructorArgumentAssociation;
import org.eclipse.wb.core.model.broadcast.EvaluationEventListener;
import org.eclipse.wb.core.model.broadcast.ExecutionFlowEnterFrame;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.core.model.broadcast.JavaInfoMethodAssociationOnParse;
import org.eclipse.wb.core.model.broadcast.JavaInfoTreeAlmostComplete;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.core.model.broadcast.ObjectInfoTreeComplete;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.model.JavaInfoEvaluationHelper;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.description.ConstructorDescription;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.model.generation.GenerationSettings;
import org.eclipse.wb.internal.core.model.nonvisual.ArrayObjectInfo;
import org.eclipse.wb.internal.core.model.nonvisual.EllipsisObjectInfo;
import org.eclipse.wb.internal.core.model.nonvisual.NonVisualBeanContainerInfo;
import org.eclipse.wb.internal.core.model.nonvisual.NonVisualBeanInfo;
import org.eclipse.wb.internal.core.model.util.GlobalStateJava;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.FieldInitializerVariableSupport;
import org.eclipse.wb.internal.core.model.variable.FieldReuseVariableSupport;
import org.eclipse.wb.internal.core.model.variable.FieldUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LazyVariableSupportUtils;
import org.eclipse.wb.internal.core.model.variable.LocalReuseVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.nls.NlsSupport;
import org.eclipse.wb.internal.core.parser.AbstractParseFactory;
import org.eclipse.wb.internal.core.parser.IJavaInfoParseResolver;
import org.eclipse.wb.internal.core.parser.IParseContextProcessor;
import org.eclipse.wb.internal.core.parser.IParseFactory;
import org.eclipse.wb.internal.core.parser.IParseFactorySimpleModelCic;
import org.eclipse.wb.internal.core.parser.IParseValidator;
import org.eclipse.wb.internal.core.parser.JavaInfoResolver;
import org.eclipse.wb.internal.core.parser.ParseFactoryNoModel;
import org.eclipse.wb.internal.core.parser.ParseRootContext;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.exception.NoEntryPointError;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.state.GlobalState;

public final class JavaInfoParser
implements IJavaInfoParseResolver {
    public static final String KEY_ROOT = "KEY_ROOT";
    public static final String KEY_COMPONENTS = "KEY_COMPONENTS";
    private final AstEditor m_editor;
    private final EditorState m_editorState;
    private final JavaInfoResolver m_javaInfoResolver;
    private final EvaluationEventListener m_evaluationListener;
    private final List<IParseFactory> m_parseFactories;
    private TypeDeclaration m_typeDeclaration;
    private JavaInfo m_rootComponent;
    private final List<JavaInfo> m_components;
    private ExecutionFlowParseVisitor m_visitor;
    private final Set<ASTNode> m_evaluatedNodes = Sets.newHashSet();
    private JavaInfoEvaluationHelper m_evaluationHelper;

    public static JavaInfo parse(ICompilationUnit modelUnit) throws Exception {
        JavaInfoParser.checkJavaVersion(modelUnit);
        final JavaInfoParser parser = new JavaInfoParser(modelUnit);
        return (JavaInfo)((Object)ExecutionUtils.runDesignTime((RunnableObjectEx)new RunnableObjectEx<JavaInfo>(){

            public JavaInfo runObject() throws Exception {
                return parser.parse();
            }
        }));
    }

    public static JavaInfo parse(AstEditor editor, MethodDeclaration rootMethod) throws Exception {
        final JavaInfoParser parser = new JavaInfoParser(editor);
        parser.m_editorState.setFlowDescription(new ExecutionFlowDescription(rootMethod));
        return (JavaInfo)((Object)ExecutionUtils.runDesignTime((RunnableObjectEx)new RunnableObjectEx<JavaInfo>(){

            public JavaInfo runObject() throws Exception {
                return parser.parseRootMethods();
            }
        }));
    }

    private static void checkJavaVersion(ICompilationUnit unit) {
        IJavaProject javaProject = unit.getJavaProject();
        float projectVersion = ProjectUtils.getJavaVersion(javaProject);
        float eclipseVersion = EnvironmentUtils.getJavaVersion();
        if (eclipseVersion < projectVersion) {
            DecimalFormat format = new DecimalFormat("#.###", new DecimalFormatSymbols(Locale.ENGLISH));
            String projectVersionString = format.format(projectVersion);
            String eclipseVersionString = format.format(eclipseVersion);
            throw new DesignerException(108, new String[]{projectVersionString, eclipseVersionString});
        }
    }

    private JavaInfoParser(ICompilationUnit modelUnit) throws Exception {
        this(new AstEditor(modelUnit));
    }

    private JavaInfoParser(AstEditor editor) throws Exception {
        this.m_editor = editor;
        this.m_editorState = EditorState.get(this.m_editor);
        this.m_javaInfoResolver = new JavaInfoResolver(editor);
        this.m_components = this.m_javaInfoResolver.getComponents();
        this.m_evaluationListener = (EvaluationEventListener)this.m_editorState.getBroadcast().getListener(EvaluationEventListener.class);
        this.m_parseFactories = ExternalFactoriesHelper.getElementsInstances(IParseFactory.class, (String)"org.eclipse.wb.core.java.parseFactories", (String)"factory");
        this.m_editor.putGlobalValue(KEY_COMPONENTS, this.m_components);
        GlobalState.setParsing((boolean)true);
        this.m_editorState.setExecuting(true);
    }

    private JavaInfo parse() throws Exception {
        this.validateASTEditor();
        ParseRootContext rootContext = this.prepareParseContext();
        ExecutionFlowDescription flowDescription = rootContext.getFlowDescription();
        JavaInfoParser.addStartMethodsNVO(flowDescription);
        this.m_rootComponent = rootContext.getRoot();
        this.m_editorState.setFlowDescription(flowDescription);
        this.m_editorState.setTmp_visitingContext(new ExecutionFlowUtils.VisitingContext(false));
        this.m_editorState.setTmp_Components(this.m_components);
        if (rootContext.getRoot() != null) {
            this.addJavaInfo(rootContext.getRoot(), null);
        }
        List processors = ExternalFactoriesHelper.getElementsInstances(IParseContextProcessor.class, (String)"org.eclipse.wb.core.java.parseContextProcessors", (String)"processor");
        for (IParseContextProcessor processor : processors) {
            processor.process(this.m_editor, flowDescription, this.m_components);
        }
        return this.parseRootMethods();
    }

    private void validateASTEditor() throws Exception {
        List validators = ExternalFactoriesHelper.getElementsInstances(IParseValidator.class, (String)"org.eclipse.wb.core.java.parseFactories", (String)"validator");
        for (IParseValidator validator : validators) {
            validator.validate(this.m_editor);
        }
    }

    private static void addStartMethodsNVO(ExecutionFlowDescription flowDescription) throws Exception {
        MethodDeclaration startMethod = flowDescription.getStartMethods().get(0);
        TypeDeclaration typeDeclaration = (TypeDeclaration)startMethod.getParent();
        MethodDeclaration[] methodDeclarationArray = typeDeclaration.getMethods();
        int n = methodDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration method = methodDeclarationArray[n2];
            NonVisualBeanInfo nonVisualInfo = NonVisualBeanContainerInfo.getNonVisualInfo((ASTNode)method);
            if (nonVisualInfo != null) {
                flowDescription.addStartMethod(method);
            }
            ++n2;
        }
    }

    private JavaInfo parseRootMethods() throws Exception {
        ExecutionFlowParseVisitor parseVisitor = this.getParseVisitor();
        parseVisitor.m_currentStatement = null;
        try {
            ExecutionFlowUtils.visit(this.m_editorState.getTmp_visitingContext(), this.m_editorState.getFlowDescription(), parseVisitor);
            GlobalState.setParsing((boolean)false);
            this.m_editorState.setExecuting(false);
            this.m_editorState.getFlowDescription().lockBinaryFlow();
            JavaInfo root = this.getRoot();
            if (root != null) {
                this.m_javaInfoResolver.setRootJavaInfo(root);
                return root;
            }
            if (this.m_editor.hasCompilationErrors()) {
                throw new DesignerException(101, new String[0]);
            }
            throw new NoEntryPointError(this.m_editor, this.m_typeDeclaration);
        }
        catch (Throwable e) {
            JavaInfoParser.disposeComponentsHierarchy(this.m_components, true);
            if (parseVisitor.m_currentStatement != null) {
                int position = AstNodeUtils.getSourceBegin((ASTNode)parseVisitor.m_currentStatement);
                DesignerExceptionUtils.setSourcePosition((Throwable)e, (int)position);
            }
            throw ReflectionUtils.propagate((Throwable)e);
        }
    }

    private static void disposeComponentsHierarchy(List<JavaInfo> components, boolean sendBroadcast) throws Exception {
        for (JavaInfo component : components) {
            try {
                component.refresh_dispose();
                if (!sendBroadcast) continue;
                component.getBroadcastObject().dispose();
            }
            catch (Throwable e) {
                DesignerPlugin.log((Throwable)e);
            }
        }
    }

    private void clearValuesOfDisconnectedModels(final JavaInfo root) {
        if (this.m_editorState.isLiveComponent()) {
            return;
        }
        this.m_editor.getAstUnit().accept(new ASTVisitor(){

            public void postVisit(ASTNode node) {
                JavaInfo model;
                Expression expression;
                ExpressionValue value;
                if (node instanceof Expression && (value = ExecutionFlowUtils2.getValue0(expression = (Expression)node)) != null && (model = (JavaInfo)((Object)value.getModel())) != null && !root.isItOrParentOf(model)) {
                    ExecutionFlowUtils2.clearPermanentValue(expression);
                }
            }
        });
    }

    private ExecutionFlowParseVisitor getParseVisitor() {
        if (this.m_visitor == null) {
            this.m_visitor = new ExecutionFlowParseVisitor();
        }
        return this.m_visitor;
    }

    private JavaInfo getRoot() throws Throwable {
        ((JavaEventListener)this.m_editorState.getBroadcast().getListener(JavaEventListener.class)).bindComponents(this.m_components);
        JavaInfoUtils.bindBinaryComponents(this.m_components);
        List<JavaInfo> rootComponents = this.getRootComponents();
        if (!rootComponents.isEmpty()) {
            try {
                JavaInfo root = rootComponents.get(0);
                GlobalStateJava.activate(root);
                root.setAssociation(new RootAssociation());
                this.callRootProcessors(root);
                ((JavaInfoTreeAlmostComplete)root.getBroadcast(JavaInfoTreeAlmostComplete.class)).invoke(root, this.m_components);
                this.m_editor.putGlobalValue(KEY_ROOT, (Object)root);
                ((ObjectInfoTreeComplete)root.getBroadcast(ObjectInfoTreeComplete.class)).invoke();
                this.clearValuesOfDisconnectedModels(root);
                NlsSupport.get(root);
                GenerationSettings.deduce(root);
                JavaInfo javaInfo = root;
                return javaInfo;
            }
            finally {
                JavaInfoParser.disposeComponentsHierarchy(rootComponents, false);
            }
        }
        return null;
    }

    private void callRootProcessors(JavaInfo root) throws Exception {
        ArrayList components = Lists.newArrayList();
        for (JavaInfo javaInfo : this.m_components) {
            if (components.contains((Object)javaInfo)) continue;
            components.add(javaInfo);
        }
        List processors = ExternalFactoriesHelper.getElementsInstances(IRootProcessor.class, (String)"org.eclipse.wb.core.java.rootProcessors", (String)"processor");
        for (IRootProcessor processor : processors) {
            processor.process(root, components);
        }
    }

    private List<JavaInfo> getRootComponents() throws Exception {
        LinkedList<JavaInfo> rootComponents = new LinkedList<JavaInfo>(this.m_components);
        Iterator I = rootComponents.iterator();
        while (I.hasNext()) {
            JavaInfo javaInfo = (JavaInfo)((Object)I.next());
            if (javaInfo.getParent() != null) {
                I.remove();
                continue;
            }
            if (NonVisualBeanInfo.isNVO(javaInfo)) {
                I.remove();
                continue;
            }
            if (javaInfo.canBeRoot()) continue;
            I.remove();
        }
        JavaInfoParser.getRootComponents_preferredRoot(rootComponents);
        Collections.sort(rootComponents, new Comparator<JavaInfo>(){

            @Override
            public int compare(JavaInfo o1, JavaInfo o2) {
                return JavaInfoParser.getComponentsTreeSize(o2) - JavaInfoParser.getComponentsTreeSize(o1);
            }
        });
        return rootComponents;
    }

    private static void getRootComponents_preferredRoot(List<JavaInfo> rootComponents) {
        boolean hasPreferredRoot = false;
        for (JavaInfo root : rootComponents) {
            hasPreferredRoot |= JavaInfoParser.isPreferredRoot(root);
        }
        if (hasPreferredRoot) {
            Iterator<JavaInfo> I = rootComponents.iterator();
            while (I.hasNext()) {
                JavaInfo root = I.next();
                if (JavaInfoParser.isPreferredRoot(root)) continue;
                I.remove();
            }
        }
    }

    private static boolean isPreferredRoot(JavaInfo root) {
        int position = root.getCreationSupport().getNode().getStartPosition();
        String endOfLineComment = root.getEditor().getEndOfLineComment(position);
        if (StringUtils.contains((String)endOfLineComment, (String)"@wbp.parser.preferredRoot")) {
            return true;
        }
        return JavaInfoUtils.hasTrueParameter(root, "parser.preferredRoot");
    }

    private ParseRootContext prepareParseContext() throws Exception {
        ICompilationUnit modelUnit = this.m_editor.getModelUnit();
        String unitPath = modelUnit.getUnderlyingResource().getFullPath().toPortableString();
        IType primaryType = CodeUtils.findPrimaryType(modelUnit);
        Assert.isTrueException((primaryType != null ? 1 : 0) != 0, (int)106, (Object[])new Object[]{unitPath});
        String primaryTypeName = primaryType.getElementName();
        this.m_typeDeclaration = AstNodeUtils.getTypeByName(this.m_editor.getAstUnit(), primaryTypeName);
        Assert.isTrueException((this.m_typeDeclaration != null ? 1 : 0) != 0, (int)110, (Object[])new Object[]{unitPath});
        ITypeBinding typeBinding = this.m_typeDeclaration.resolveBinding();
        Assert.isNotNull((Object)typeBinding);
        for (IParseFactory parseFactory : this.m_parseFactories) {
            ParseRootContext rootContext = parseFactory.getRootContext(this.m_editor, this.m_typeDeclaration, typeBinding);
            if (rootContext == null) continue;
            return rootContext;
        }
        EditorState editorState = EditorState.get(this.m_editor);
        if (editorState.getEditorLoader() == null) {
            if (!this.canBeClassWithGUI()) {
                throw new DesignerException(111, new String[]{primaryType.getFullyQualifiedName()});
            }
            throw new DesignerException(103, new String[]{primaryType.getFullyQualifiedName()});
        }
        MethodDeclaration mainMethod = AstNodeUtils.getMethodBySignature(this.m_typeDeclaration, "main(java.lang.String[])");
        if (mainMethod != null) {
            return new ParseRootContext(null, new ExecutionFlowDescription(mainMethod));
        }
        MethodDeclaration constructor = ExecutionFlowUtils.getExecutionFlowConstructor(this.m_typeDeclaration);
        if (constructor != null) {
            return new ParseRootContext(null, new ExecutionFlowDescription(constructor));
        }
        AbstractParseFactory.failIfFactory(this.m_editor, this.m_typeDeclaration, typeBinding);
        ((ObjectEventListener)this.m_editorState.getBroadcast().getListener(ObjectEventListener.class)).dispose();
        throw new NoEntryPointError(this.m_editor, this.m_typeDeclaration);
    }

    private boolean canBeClassWithGUI() {
        final AtomicBoolean result = new AtomicBoolean();
        this.m_editor.getAstUnit().accept(new ASTVisitor(){

            public void endVisit(ClassInstanceCreation node) {
                result.set(true);
            }
        });
        return result.get();
    }

    private void addJavaInfo(JavaInfo javaInfo, Expression creation) throws Exception {
        this.m_javaInfoResolver.addJavaInfo(javaInfo, creation);
        javaInfo.addRelatedNode((ASTNode)creation);
        GlobalStateJava.activate(javaInfo);
        if (javaInfo.getVariableSupport() == null) {
            LazyVariableSupportUtils.setLazyVariable(javaInfo);
        }
        if (javaInfo.getVariableSupport() == null) {
            Assert.isNotNull((Object)creation);
            javaInfo.setVariableSupport(new EmptyVariableSupport(javaInfo, creation));
        }
        if (!javaInfo.getCreationSupport().canBeEvaluated()) {
            this.getEvaluationHelper().evaluateJavaInfoUsingCreationSupport(javaInfo);
        }
    }

    private JavaInfoEvaluationHelper getEvaluationHelper() {
        if (this.m_evaluationHelper == null) {
            this.m_evaluationHelper = new JavaInfoEvaluationHelper(this.m_editor, this.getParseVisitor()){

                @Override
                protected JavaInfo getRootJavaInfo() {
                    return JavaInfoParser.this.m_rootComponent;
                }

                @Override
                protected JavaInfo getJavaInfoRepresentedBy(Expression expression) {
                    return JavaInfoParser.this.getJavaInfo(expression);
                }

                @Override
                protected void thisJavaInfoNodeProcessed(JavaInfo javaInfo, ASTNode node) throws Exception {
                    javaInfo.addRelatedNode(node);
                }
            };
        }
        return this.m_evaluationHelper;
    }

    private void evaluateNode(ASTNode node) throws Exception {
        if (!this.m_evaluatedNodes.contains(node)) {
            this.m_evaluatedNodes.add(node);
            try {
                JavaInfoEvaluationHelper evaluationHelper = this.getEvaluationHelper();
                if (JavaInfoParser.shouldNotifyAboutEvaluate(node)) {
                    this.m_evaluationListener.evaluateBefore(null, node);
                }
                evaluationHelper.evaluate(node);
                if (JavaInfoParser.shouldNotifyAboutEvaluate(node)) {
                    this.m_evaluationListener.evaluateAfter(null, node);
                }
            }
            catch (Throwable e) {
                if (DesignerExceptionUtils.isFatal((Throwable)e)) {
                    ReflectionUtils.propagate((Throwable)e);
                }
                if (node instanceof Expression && this.getJavaInfo((Expression)node) != null) {
                    ReflectionUtils.propagate((Throwable)e);
                }
                this.m_editorState.getBadParserNodes().add(node, e);
            }
        }
    }

    private static boolean shouldNotifyAboutEvaluate(ASTNode node) {
        return node instanceof ClassInstanceCreation || node instanceof MethodInvocation || node instanceof Statement;
    }

    private static Expression[] getExpressionArray(List<Expression> expressionList) {
        return expressionList.toArray(new Expression[expressionList.size()]);
    }

    private static int getComponentsTreeSize(ObjectInfo info) {
        int size = 1;
        for (ObjectInfo child : info.getChildren()) {
            size += JavaInfoParser.getComponentsTreeSize(child);
        }
        return size;
    }

    @Override
    public JavaInfo getJavaInfo(Expression expression) {
        return this.m_javaInfoResolver.getJavaInfo(expression);
    }

    private JavaInfo[] getJavaInfoArray(Expression[] expressions) throws Exception {
        JavaInfo[] javaInfos = new JavaInfo[expressions.length];
        int i = 0;
        while (i < expressions.length) {
            Expression expression = expressions[i];
            javaInfos[i] = this.getJavaInfo(expression);
            ++i;
        }
        return javaInfos;
    }

    private void throwDoubleAssociationException(JavaInfo parent, JavaInfo child, Association existingAssociation, Association newAssociation) throws DesignerException {
        String existingStatementSource = this.getAssociationStatementSource(existingAssociation);
        String newStatementSource = this.getAssociationStatementSource(newAssociation);
        String message = MessageFormat.format("\nChild:                    \n  {0}\nExisting: \n  {1} \n    {2}\nNew: \n  {3} \n    {4}", new Object[]{child, child.getParent(), existingAssociation, parent, newAssociation});
        DesignerException designerWarning = new DesignerException(107, new String[]{JavaInfoParser.getShortComponentName(child), existingStatementSource, newStatementSource, message});
        designerWarning.setSourcePosition(this.m_visitor.m_currentStatement.getStartPosition());
        throw designerWarning;
    }

    private String getAssociationStatementSource(Association association) {
        Statement statement = association.getStatement();
        return statement != null ? this.m_editor.getSource((ASTNode)statement) : "<null>";
    }

    private static String getShortComponentName(JavaInfo javaInfo) {
        if (javaInfo == null) {
            return "<null>";
        }
        return javaInfo.getVariableSupport().getComponentName();
    }

    private static boolean maybeNVO(ClassInstanceCreation creation) {
        BodyDeclaration body = AstNodeUtils.getEnclosingNode((ASTNode)creation, BodyDeclaration.class);
        if (body != null) {
            Javadoc doc = body.getJavadoc();
            return doc != null && doc.toString().contains("@wbp.nonvisual");
        }
        return false;
    }

    private final class ExecutionFlowParseVisitor
    extends ExecutionFlowUtils.ExecutionFlowFrameVisitor {
        private final Set<MethodDeclaration> m_visitedLazyMethods = Sets.newHashSet();

        private ExecutionFlowParseVisitor() {
        }

        @Override
        public boolean enterFrame(final ASTNode node) {
            MethodDeclaration method;
            ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    ((ExecutionFlowEnterFrame)((ExecutionFlowParseVisitor)ExecutionFlowParseVisitor.this).JavaInfoParser.this.m_editorState.getBroadcast().getListener(ExecutionFlowEnterFrame.class)).invoke(node);
                }
            });
            if (node instanceof MethodDeclaration) {
                method = (MethodDeclaration)node;
                if (this.m_visitedLazyMethods.contains(method)) {
                    return false;
                }
                if (LazyVariableSupportUtils.getInformation(method) != null) {
                    this.m_visitedLazyMethods.add(method);
                    return true;
                }
            }
            if (node instanceof MethodDeclaration && FactoryDescriptionHelper.isFactoryMethod(method = (MethodDeclaration)node)) {
                return false;
            }
            return super.enterFrame(node);
        }

        @Override
        public void leaveFrame(final ASTNode node) {
            super.leaveFrame(node);
            ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    ((EvaluationEventListener)((ExecutionFlowParseVisitor)ExecutionFlowParseVisitor.this).JavaInfoParser.this.m_editorState.getBroadcast().getListener(EvaluationEventListener.class)).leaveFrame(node);
                }
            });
        }

        public void postVisit(final ASTNode node) {
            ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    if (node instanceof Expression && !(node instanceof ClassInstanceCreation) && !(node instanceof MethodInvocation)) {
                        ExecutionFlowParseVisitor.this.endVisit((Expression)node);
                    }
                    JavaInfoParser.this.evaluateNode(node);
                }
            });
        }

        private void endVisit(Expression expression) {
            try {
                if (this.createJavaInfo_noModel((ASTNode)expression)) {
                    return;
                }
                for (IParseFactory parseFactory : JavaInfoParser.this.m_parseFactories) {
                    JavaInfo javaInfo = parseFactory.create(JavaInfoParser.this.m_editor, expression);
                    if (javaInfo == null) continue;
                    JavaInfoParser.this.addJavaInfo(javaInfo, expression);
                    break;
                }
            }
            catch (Throwable e) {
                ReflectionUtils.propagate((Throwable)e);
            }
        }

        private boolean createJavaInfo_noModel(ASTNode node) {
            List validators = ExternalFactoriesHelper.getElementsInstances(ParseFactoryNoModel.class, (String)"org.eclipse.wb.core.java.parseFactories", (String)"noModel");
            for (ParseFactoryNoModel validator : validators) {
                if (!validator.noModel(node)) continue;
                return true;
            }
            return false;
        }

        public void endVisit(ClassInstanceCreation creation) {
            try {
                boolean canBeOptimized;
                if (this.createJavaInfo_noModel((ASTNode)creation)) {
                    return;
                }
                IMethodBinding methodBinding = AstNodeUtils.getCreationBinding(creation);
                ITypeBinding typeBinding = AstNodeUtils.getTypeBinding((Expression)creation);
                if (typeBinding == null) {
                    return;
                }
                boolean bl = canBeOptimized = !JavaInfoParser.maybeNVO(creation);
                if (canBeOptimized && this.createJavaInfo_noModel(creation, typeBinding)) {
                    return;
                }
                Expression[] arguments = JavaInfoParser.getExpressionArray(DomGenerics.arguments(creation));
                JavaInfo[] argumentInfos = JavaInfoParser.this.getJavaInfoArray(arguments);
                JavaInfo javaInfo = null;
                if (canBeOptimized) {
                    List validators = ExternalFactoriesHelper.getElementsInstances(IParseFactorySimpleModelCic.class, (String)"org.eclipse.wb.core.java.parseFactories", (String)"simpleModel_CIC");
                    for (IParseFactorySimpleModelCic factory : validators) {
                        if (!factory.accept(JavaInfoParser.this.m_editor, creation, typeBinding)) continue;
                        javaInfo = factory.create(JavaInfoParser.this.m_editor, creation, typeBinding);
                        if (javaInfo != null) break;
                        return;
                    }
                }
                if (javaInfo == null) {
                    for (IParseFactory parseFactory : JavaInfoParser.this.m_parseFactories) {
                        javaInfo = parseFactory.create(JavaInfoParser.this.m_editor, creation, methodBinding, typeBinding, arguments, argumentInfos);
                        if (javaInfo != null) break;
                    }
                }
                if (javaInfo != null) {
                    JavaInfoParser.this.addJavaInfo(javaInfo, (Expression)creation);
                    this.bindChild_ClassInstanceCreation(creation, methodBinding, javaInfo, argumentInfos);
                    this.bindChild_SuperConstructorInvocation((Expression)creation, javaInfo);
                }
            }
            catch (Throwable e) {
                ReflectionUtils.propagate((Throwable)e);
            }
        }

        private boolean createJavaInfo_noModel(ClassInstanceCreation creation, ITypeBinding typeBinding) {
            List validators = ExternalFactoriesHelper.getElementsInstances(ParseFactoryNoModel.class, (String)"org.eclipse.wb.core.java.parseFactories", (String)"noModel");
            for (ParseFactoryNoModel validator : validators) {
                if (!validator.noModel(creation, typeBinding)) continue;
                return true;
            }
            return false;
        }

        public void endVisit(MethodInvocation invocation) {
            try {
                MethodDescription methodDescription;
                if (this.createJavaInfo_noModel((ASTNode)invocation)) {
                    return;
                }
                IMethodBinding methodBinding = AstNodeUtils.getMethodBinding(invocation);
                if (methodBinding == null) {
                    return;
                }
                Expression[] arguments = JavaInfoParser.getExpressionArray(DomGenerics.arguments(invocation));
                JavaInfo expressionInfo = JavaInfoParser.this.getJavaInfo(invocation.getExpression());
                JavaInfo[] argumentInfos = JavaInfoParser.this.getJavaInfoArray(arguments);
                for (IParseFactory parseFactory : JavaInfoParser.this.m_parseFactories) {
                    JavaInfo javaInfo = parseFactory.create(JavaInfoParser.this.m_editor, invocation, methodBinding, arguments, expressionInfo, argumentInfos, JavaInfoParser.this);
                    if (javaInfo == null) continue;
                    JavaInfoParser.this.addJavaInfo(javaInfo, (Expression)invocation);
                    break;
                }
                this.bindChild_MethodInvocation(invocation, methodBinding, expressionInfo, arguments, argumentInfos);
                if (expressionInfo != null && (methodDescription = expressionInfo.getDescription().getMethod(methodBinding)) != null && methodDescription.hasTrueTag("returnThis")) {
                    expressionInfo.bindToExpression((Expression)invocation);
                }
            }
            catch (Throwable e) {
                ReflectionUtils.propagate((Throwable)e);
            }
        }

        private void bindChild_setAssociation(JavaInfo parent, JavaInfo child, Association newAssociation) throws Exception {
            Association existingAssociation = child.getAssociation();
            if (existingAssociation == null) {
                parent.addChild(child);
                child.setAssociation(newAssociation);
            } else {
                if (child.getParent() != parent) {
                    JavaInfoParser.this.throwDoubleAssociationException(parent, child, existingAssociation, newAssociation);
                }
                child.setAssociation(new CompoundAssociation(existingAssociation, newAssociation));
            }
        }

        private void bindChild_MethodInvocation(MethodInvocation invocation, IMethodBinding methodBinding, JavaInfo expressionInfo, Expression[] arguments, JavaInfo[] argumentInfos) throws Exception {
            MethodDescription methodDescription;
            if (expressionInfo != null && (methodDescription = expressionInfo.getDescription().getMethod(methodBinding)) != null) {
                ITypeBinding[] parameterTypes = methodBinding.getParameterTypes();
                List<ParameterDescription> parameterDescriptions = methodDescription.getParameters();
                JavaInfo parent2Info = null;
                JavaInfo child2Info = null;
                for (ParameterDescription parameterDescription : parameterDescriptions) {
                    int parameterIndex = parameterDescription.getIndex();
                    if (parameterDescription.isChild()) {
                        JavaInfo parameterJavaInfo = argumentInfos[parameterIndex];
                        if (parameterTypes[parameterIndex].isArray()) {
                            Expression parameterExpression = arguments[parameterDescription.getIndex()];
                            if (parameterJavaInfo == null && parameterExpression instanceof ArrayCreation) {
                                ArrayCreation creation = (ArrayCreation)parameterExpression;
                                if (creation.getType().getComponentType().isSimpleType()) {
                                    this.bindChild_MethodInvocationParameter_ArrayCreation(invocation, methodDescription, expressionInfo, parameterDescription, creation);
                                }
                            } else if (parameterIndex == parameterDescriptions.size() - 1) {
                                Expression[] arrayArguments = (Expression[])ArrayUtils.subarray((Object[])arguments, (int)parameterIndex, (int)arguments.length);
                                JavaInfo[] arrayArgumentInfos = (JavaInfo[])ArrayUtils.subarray((Object[])argumentInfos, (int)parameterIndex, (int)argumentInfos.length);
                                this.bindChild_MethodInvocationParameter_ArrayEllipsis(invocation, methodDescription, expressionInfo, parameterIndex, parameterDescription, arrayArguments, arrayArgumentInfos);
                            }
                        } else if (parameterJavaInfo != null) {
                            this.bindChild_MethodInvocationParameter(invocation, methodDescription, expressionInfo, parameterDescription, parameterJavaInfo);
                        }
                    }
                    if (parameterDescription.isParent2()) {
                        parent2Info = argumentInfos[parameterIndex];
                    }
                    if (!parameterDescription.isChild2()) continue;
                    child2Info = argumentInfos[parameterIndex];
                }
                if (parent2Info != null && child2Info != null) {
                    this.bindChild_setAssociation(parent2Info, child2Info, new InvocationSecondaryAssociation(invocation));
                }
            }
        }

        private void bindChild_MethodInvocationParameter(MethodInvocation invocation, MethodDescription methodDescription, JavaInfo expressionInfo, ParameterDescription parameterDescription, JavaInfo parameterJavaInfo) throws Exception {
            if (parameterDescription.hasTrueTag("associateOnlyFirstTime") && parameterJavaInfo.getParent() != null) {
                return;
            }
            ((JavaInfoMethodAssociationOnParse)expressionInfo.getBroadcast(JavaInfoMethodAssociationOnParse.class)).invoke(expressionInfo, parameterJavaInfo, methodDescription);
            this.bindChild_setAssociation(expressionInfo, parameterJavaInfo, new InvocationChildAssociation(invocation));
        }

        private void bindChild_MethodInvocationParameter_ArrayCreation(MethodInvocation invocation, MethodDescription methodDescription, JavaInfo expressionInfo, ParameterDescription parameterDescription, ArrayCreation creation) throws Exception {
            ArrayObjectInfo arrayInfo = new ArrayObjectInfo(JavaInfoParser.this.m_editor, methodDescription.getName(), creation);
            expressionInfo.addChild(arrayInfo);
            arrayInfo.setRemoveOnEmpty(parameterDescription.hasTrueTag("arrayObject.removeOnEmpty"));
            arrayInfo.setHideInTree(parameterDescription.hasTrueTag("arrayObject.hideInTree"));
            Expression[] arrayItems = JavaInfoParser.getExpressionArray(creation.getInitializer().expressions());
            JavaInfo[] arrayJavaInfos = JavaInfoParser.this.getJavaInfoArray(arrayItems);
            int i = 0;
            while (i < arrayJavaInfos.length) {
                JavaInfo arrayJavaInfo = arrayJavaInfos[i];
                if (!(arrayJavaInfo == null || parameterDescription.hasTrueTag("associateOnlyFirstTime") && arrayJavaInfo.getParent() != null)) {
                    Assert.isNull((Object)arrayJavaInfo.getParent(), (String)String.format("Parent for array item %s already assigned.", arrayJavaInfo.toString()));
                    arrayInfo.addItem(arrayJavaInfo);
                    ((JavaInfoMethodAssociationOnParse)expressionInfo.getBroadcast(JavaInfoMethodAssociationOnParse.class)).invoke(expressionInfo, arrayJavaInfo, methodDescription);
                    this.bindChild_setAssociation(expressionInfo, arrayJavaInfo, new InvocationChildArrayAssociation(invocation, arrayInfo));
                }
                ++i;
            }
        }

        private void bindChild_MethodInvocationParameter_ArrayEllipsis(MethodInvocation invocation, MethodDescription methodDescription, JavaInfo expressionInfo, int parameterIndex, ParameterDescription parameterDescription, Expression[] arrayArguments, JavaInfo[] arrayJavaInfos) throws Exception {
            Class<?> itemType = parameterDescription.getType();
            Assert.isTrue((boolean)itemType.isArray(), (String)"Ellipsis type not array.");
            EllipsisObjectInfo arrayInfo = new EllipsisObjectInfo(JavaInfoParser.this.m_editor, methodDescription.getName(), itemType.getComponentType(), invocation, parameterIndex);
            expressionInfo.addChild(arrayInfo);
            arrayInfo.setRemoveOnEmpty(parameterDescription.hasTrueTag("arrayObject.removeOnEmpty"));
            arrayInfo.setHideInTree(parameterDescription.hasTrueTag("arrayObject.hideInTree"));
            arrayInfo.setOnEmptySource(parameterDescription.getTag("arrayObject.OnEmptySource"));
            int i = 0;
            while (i < arrayJavaInfos.length) {
                JavaInfo arrayJavaInfo = arrayJavaInfos[i];
                if (!(arrayJavaInfo == null || parameterDescription.hasTrueTag("associateOnlyFirstTime") && arrayJavaInfo.getParent() != null)) {
                    Assert.isNull((Object)arrayJavaInfo.getParent(), (String)String.format("Parent for array item %s already assigned.", arrayJavaInfo.toString()));
                    arrayInfo.addItem(arrayJavaInfo);
                    ((JavaInfoMethodAssociationOnParse)expressionInfo.getBroadcast(JavaInfoMethodAssociationOnParse.class)).invoke(expressionInfo, arrayJavaInfo, methodDescription);
                    this.bindChild_setAssociation(expressionInfo, arrayJavaInfo, new InvocationChildEllipsisAssociation(invocation, arrayInfo));
                }
                ++i;
            }
        }

        private void bindChild_ClassInstanceCreation(ClassInstanceCreation creation, IMethodBinding methodBinding, JavaInfo javaInfo, JavaInfo[] argumentInfos) throws Exception {
            ConstructorDescription constructor;
            if (javaInfo.getParent() == null && (constructor = javaInfo.getDescription().getConstructor(methodBinding)) != null) {
                for (ParameterDescription parameter : constructor.getParameters()) {
                    if (parameter.isParent()) {
                        JavaInfo parentInfo = argumentInfos[parameter.getIndex()];
                        if (parentInfo == null) break;
                        parentInfo.addChild(javaInfo);
                        javaInfo.setAssociation(new ConstructorParentAssociation());
                        break;
                    }
                    if (!parameter.isChild()) continue;
                    JavaInfo childInfo = argumentInfos[parameter.getIndex()];
                    if (childInfo == null) break;
                    javaInfo.addChild(childInfo);
                    childInfo.setAssociation(new ConstructorChildAssociation());
                    break;
                }
            }
        }

        private void bindChild_SuperConstructorInvocation(Expression expression, JavaInfo javaInfo) throws Exception {
            if (javaInfo.getParent() == null && expression.getLocationInParent() == SuperConstructorInvocation.ARGUMENTS_PROPERTY) {
                int argumentIndex;
                ParameterDescription parameter;
                SuperConstructorInvocation constructorInvocation = (SuperConstructorInvocation)expression.getParent();
                IMethodBinding constructorBinding = AstNodeUtils.getSuperBinding(constructorInvocation);
                Object object = JavaInfoEvaluationHelper.getValue(expression);
                javaInfo.setObject(object);
                JavaInfo thisJavaInfo = JavaInfoParser.this.getJavaInfo(null);
                ConstructorDescription constructorDescription = thisJavaInfo.getDescription().getConstructor(constructorBinding);
                if (constructorDescription != null && (parameter = constructorDescription.getParameter(argumentIndex = constructorInvocation.arguments().indexOf(expression))).isChild()) {
                    thisJavaInfo.addChild(javaInfo);
                    SuperConstructorArgumentAssociation association = new SuperConstructorArgumentAssociation(constructorInvocation);
                    javaInfo.setAssociation(association);
                }
            }
        }

        public void endVisit(VariableDeclarationFragment declaration) {
            if (this.createJavaInfo_noModel((ASTNode)declaration)) {
                return;
            }
            SimpleName variable = declaration.getName();
            Expression initializer = declaration.getInitializer();
            this.createVariableSupport((Expression)variable, initializer);
        }

        public void endVisit(Assignment assignment) {
            if (this.createJavaInfo_noModel((ASTNode)assignment)) {
                return;
            }
            Expression variable = assignment.getLeftHandSide();
            if (AstNodeUtils.isVariable((ASTNode)variable)) {
                Expression initializer = assignment.getRightHandSide();
                this.createVariableSupport(variable, initializer);
            }
        }

        private void createVariableSupport(final Expression variable, final Expression initializer) {
            ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    JavaInfo javaInfo = JavaInfoParser.this.getJavaInfo(initializer);
                    if (javaInfo != null) {
                        boolean noVariableSupport;
                        VariableSupport support = javaInfo.getVariableSupport();
                        boolean bl = noVariableSupport = support == null || support.isDefault();
                        if (noVariableSupport) {
                            List<Expression> assignments = ExecutionFlowUtils.getAssignments(((ExecutionFlowParseVisitor)ExecutionFlowParseVisitor.this).JavaInfoParser.this.m_editorState.getFlowDescription(), (ASTNode)variable);
                            IVariableBinding variableBinding = AstNodeUtils.getVariableBinding((ASTNode)variable);
                            if (variableBinding.isField()) {
                                support = assignments.size() == 1 ? (variable.getParent() instanceof VariableDeclarationFragment ? new FieldInitializerVariableSupport(javaInfo, variable) : new FieldUniqueVariableSupport(javaInfo, variable)) : new FieldReuseVariableSupport(javaInfo, variable);
                            } else {
                                SimpleName simpleVariable = (SimpleName)variable;
                                support = assignments.size() == 1 ? new LocalUniqueVariableSupport(javaInfo, simpleVariable) : new LocalReuseVariableSupport(javaInfo, simpleVariable);
                            }
                            javaInfo.setVariableSupport(support);
                        }
                    }
                }
            });
        }
    }
}

