/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.generic;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.AssociationObjectFactories;
import org.eclipse.wb.core.model.association.AssociationObjectFactory;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.generic.ContainerObjectValidator;
import org.eclipse.wb.internal.core.model.generic.ContainerObjectValidators;
import org.eclipse.wb.internal.core.model.generic.SimpleContainer;
import org.eclipse.wb.internal.core.model.generic.SimpleContainerConfigurable;
import org.eclipse.wb.internal.core.model.generic.SimpleContainerConfiguration;
import org.eclipse.wb.internal.core.utils.check.Assert;

public final class SimpleContainerFactory {
    private final JavaInfo m_javaInfo;
    private final boolean m_forCanvas;

    public SimpleContainerFactory(JavaInfo javaInfo, boolean forCanvas) {
        this.m_javaInfo = javaInfo;
        this.m_forCanvas = forCanvas;
    }

    public List<SimpleContainer> get() {
        ArrayList containers = Lists.newArrayList();
        this.addConfigurableContainers(containers);
        return containers;
    }

    private void addConfigurableContainers(List<SimpleContainer> containers) {
        List<SimpleContainerConfiguration> configurations = this.getConfigurations();
        for (SimpleContainerConfiguration configuration : configurations) {
            SimpleContainerConfigurable container = new SimpleContainerConfigurable(this.m_javaInfo, configuration);
            containers.add(container);
        }
    }

    public List<SimpleContainerConfiguration> getConfigurations() {
        ArrayList configurations = Lists.newArrayList();
        for (String prefix : this.getConfigurationPrefixes()) {
            SimpleContainerConfiguration configuration = this.createConfiguration(prefix);
            configurations.add(configuration);
        }
        return configurations;
    }

    private List<String> getConfigurationPrefixes() {
        ArrayList prefixes = Lists.newArrayList();
        this.addConfigurationPrefixes(prefixes, "simpleContainer");
        if (this.m_forCanvas) {
            this.addConfigurationPrefixes(prefixes, "simpleContainer.canvas");
        } else {
            this.addConfigurationPrefixes(prefixes, "simpleContainer.tree");
        }
        return prefixes;
    }

    private void addConfigurationPrefixes(List<String> prefixes, String basePrefix) {
        int i = 0;
        while (i < 10) {
            String prefix = String.valueOf(basePrefix) + (i == 0 ? "" : "." + i);
            String validatorText = this.getParameter(prefix);
            if (validatorText != null && ContainerObjectValidators.validateContainer((Object)((Object)this.m_javaInfo), (String)validatorText)) {
                prefixes.add(prefix);
            }
            ++i;
        }
    }

    private SimpleContainerConfiguration createConfiguration(String prefix) {
        return new SimpleContainerConfiguration(this.getComponentValidator(prefix), this.getAssociation(prefix));
    }

    private ContainerObjectValidator getComponentValidator(String prefix) {
        String validatorExpression = this.getParameter(String.valueOf(prefix) + ".component-validator");
        if (validatorExpression != null) {
            return ContainerObjectValidators.forComponentExpression((String)validatorExpression);
        }
        String componentString = this.getComponentString(prefix);
        Assert.isNotNull((Object)componentString, (String)"No 'component' validator.");
        String[] componentTypes = StringUtils.split((String)componentString);
        return ContainerObjectValidators.forList((String[])componentTypes);
    }

    private String getComponentString(String prefix) {
        String componentString = this.getParameter(String.valueOf(prefix) + ".component");
        if (componentString == null) {
            componentString = this.getParameter("simpleContainer.defaultComponent");
        }
        return componentString;
    }

    private AssociationObjectFactory getAssociation(String prefix) {
        String associationString = this.getParameter(String.valueOf(prefix) + ".association");
        if (associationString == null) {
            return AssociationObjectFactories.no();
        }
        return SimpleContainerFactory.getAssociation_invocationChild(associationString);
    }

    private static AssociationObjectFactory getAssociation_invocationChild(String associationString) {
        associationString = StringUtils.removeStart((String)associationString, (String)"invocationChild ");
        Assert.isTrue((boolean)associationString.startsWith("%parent%."), (String)"Association 'invocationChild' should start with '%%parent%%.', but '%s' found.", (Object[])new Object[]{associationString});
        return AssociationObjectFactories.invocationChild(associationString, false);
    }

    private String getParameter(String name) {
        return JavaInfoUtils.getParameter(this.m_javaInfo, name);
    }
}

