/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.eval.evaluators;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;

public final class DoubleEvaluator
implements IExpressionEvaluator {
    @Override
    public Object evaluate(EvaluationContext context, Expression expression, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
        if ("double".equals(typeQualifiedName)) {
            if (expression instanceof NumberLiteral) {
                NumberLiteral numberLiteral = (NumberLiteral)expression;
                String token = numberLiteral.getToken();
                token = StringUtils.stripEnd((String)token, (String)"Dd");
                return Double.valueOf(token);
            }
            if (expression instanceof PrefixExpression) {
                PrefixExpression prefixExpression = (PrefixExpression)expression;
                PrefixExpression.Operator operator = prefixExpression.getOperator();
                Expression operand = prefixExpression.getOperand();
                double operandValue = DoubleEvaluator.getDoubleValue(context, operand);
                if (operator == PrefixExpression.Operator.PLUS) {
                    return operandValue;
                }
                if (operator == PrefixExpression.Operator.MINUS) {
                    return -operandValue;
                }
            }
            if (expression instanceof InfixExpression) {
                InfixExpression infixExpression = (InfixExpression)expression;
                List<Expression> extendedOperands = DomGenerics.extendedOperands(infixExpression);
                double[] operands = new double[2 + extendedOperands.size()];
                operands[0] = DoubleEvaluator.getDoubleValue(context, infixExpression.getLeftOperand());
                operands[1] = DoubleEvaluator.getDoubleValue(context, infixExpression.getRightOperand());
                int i = 0;
                while (i < extendedOperands.size()) {
                    Expression operandExpression = extendedOperands.get(i);
                    operands[2 + i] = DoubleEvaluator.getDoubleValue(context, operandExpression);
                    ++i;
                }
                double value = operands[0];
                InfixExpression.Operator operator = infixExpression.getOperator();
                int i2 = 1;
                while (i2 < operands.length) {
                    double operand = operands[i2];
                    if (operator == InfixExpression.Operator.PLUS) {
                        value += operand;
                    } else if (operator == InfixExpression.Operator.MINUS) {
                        value -= operand;
                    } else if (operator == InfixExpression.Operator.TIMES) {
                        value *= operand;
                    } else if (operator == InfixExpression.Operator.DIVIDE) {
                        value /= operand;
                    } else if (operator == InfixExpression.Operator.REMAINDER) {
                        value %= operand;
                    }
                    ++i2;
                }
                return value;
            }
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    private static double getDoubleValue(EvaluationContext context, Expression expression) throws Exception {
        Object value = AstEvaluationEngine.evaluate(context, expression);
        if (value instanceof Character) {
            Character character = (Character)value;
            return character.charValue();
        }
        Number number = (Number)value;
        return number.doubleValue();
    }
}

