/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;

public final class TestTools {
    private static final Class TestCase_class;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("junit.framework.TestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestCase_class = clazz;
    }

    public static Object serialize(Object o) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baOutStream = new ByteArrayOutputStream(2000);
        ObjectOutputStream outStream = new ObjectOutputStream(baOutStream);
        outStream.writeObject(o);
        outStream.close();
        ByteArrayInputStream baInStream = new ByteArrayInputStream(baOutStream.toByteArray());
        ObjectInputStream inStream = new ObjectInputStream(baInStream);
        Object o2 = inStream.readObject();
        inStream.close();
        return o2;
    }

    public static void setUpOracleProxy() {
        System.setProperty("http.proxyHost", "www-proxy.us.oracle.com");
        System.setProperty("http.proxyPort", "80");
    }

    public static String[] buildOracleProxyCommandLineOptions() {
        return new String[]{"-Dhttp.proxyHost=www-proxy.us.oracle.com", "-Dhttp.proxyPort=80"};
    }

    public static void redirectSystemStreamsTo(OutputStream outputStream) {
        TestTools.redirectSystemStreamsTo(new PrintStream(outputStream));
    }

    public static void redirectSystemStreamsTo(PrintStream printStream) {
        System.setOut(printStream);
        System.setErr(printStream);
    }

    public static String execute(TestCase testCase) {
        long start = System.currentTimeMillis();
        TestResult result = testCase.run();
        long end = System.currentTimeMillis();
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        writer.print(testCase.getName());
        writer.print(": ");
        if (result.wasSuccessful()) {
            writer.println("OK");
        } else {
            TestFailure failure = null;
            failure = result.failures().hasMoreElements() ? (TestFailure)result.failures().nextElement() : (TestFailure)result.errors().nextElement();
            failure.thrownException().printStackTrace(writer);
        }
        writer.print("elapsed time: ");
        long elapsed = end - start;
        writer.print(elapsed / 1000L);
        writer.println(" sec.");
        return stringWriter.toString();
    }

    public static void clear(TestCase testCase) throws IllegalAccessException {
        Class<?> tempClass = testCase.getClass();
        while (tempClass != TestCase_class) {
            Field[] fields = tempClass.getDeclaredFields();
            int i = fields.length;
            while (i-- > 0) {
                Field field = fields[i];
                if (field.getType().isPrimitive() || Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                field.set(testCase, null);
            }
            tempClass = tempClass.getSuperclass();
        }
    }

    public static void setUpJUnitThreadContextClassLoader() {
        Thread thread = Thread.currentThread();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.dali.utility.tests.TestTools");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        thread.setContextClassLoader(clazz.getClassLoader());
    }

    private TestTools() {
        throw new UnsupportedOperationException();
    }
}

