/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.NameTools;

public class NameToolsTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.NameToolsTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.NameToolsTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public NameToolsTests(String name) {
        super(name);
    }

    public void testStringAbsentIgnoreCase() {
        List colorCollection = this.buildColorCollection();
        String returned = NameTools.uniqueNameForIgnoreCase((String)"Taupe", (Collection)colorCollection);
        NameToolsTests.assertEquals((String)"Taupe", (String)returned);
    }

    public void testStringPresentCaseDiffers() {
        List colorCollection = this.buildColorCollection();
        String returned = NameTools.uniqueNameFor((String)"green", (Collection)colorCollection);
        NameToolsTests.assertEquals((String)"green", (String)returned);
    }

    public void testStringPresentIgnoreCase() {
        List colorCollection = this.buildColorCollection();
        String returned = NameTools.uniqueNameForIgnoreCase((String)"green", (Collection)colorCollection);
        NameToolsTests.assertEquals((String)"green2", (String)returned);
    }

    public void testStringPresentWithAppendices() {
        List colorCollection = this.buildColorCollection();
        colorCollection.add("Red1");
        colorCollection.add("red2");
        String returned = NameTools.uniqueNameForIgnoreCase((String)"red", (Collection)colorCollection);
        colorCollection.remove("Red1");
        colorCollection.remove("red2");
        NameToolsTests.assertEquals((String)"red3", (String)returned);
    }

    private List buildColorCollection() {
        ArrayList<String> colorCollection = new ArrayList<String>();
        colorCollection.add("Red");
        colorCollection.add("Orange");
        colorCollection.add("Yellow");
        colorCollection.add("Green");
        colorCollection.add("Blue");
        colorCollection.add("Indigo");
        colorCollection.add("Violet");
        return colorCollection;
    }

    public void testUniqueNameForCollection1() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Oracle");
        strings.add("Oracle Corporation");
        strings.add("Oracle2");
        strings.add("oracle1");
        strings.add("Oracl");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameFor((String)"Oracle", strings));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueNameFor((String)"Test", strings));
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameForIgnoreCase((String)"Oracle", strings));
        NameToolsTests.assertEquals((String)"oracle3", (String)NameTools.uniqueNameForIgnoreCase((String)"oracle", strings));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueNameForIgnoreCase((String)"Test", strings));
    }

    public void testUniqueNameForCollection2() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Oracle");
        strings.add("oracle");
        strings.add("Oracle2");
        strings.add("Oracle1");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameFor((String)"Oracle", strings));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueNameFor((String)"Test", strings));
        strings.add("Oracle Corporation");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameForIgnoreCase((String)"Oracle", strings));
        NameToolsTests.assertEquals((String)"oracle3", (String)NameTools.uniqueNameForIgnoreCase((String)"oracle", strings));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueNameForIgnoreCase((String)"Test", strings));
    }

    public void testUniqueNameForCollection3() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Oracle");
        strings.add("Oracle");
        strings.add("Oracle2");
        strings.add("Oracle1");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameFor((String)"Oracle", strings));
    }

    public void testUniqueNameForIterator1() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Oracle");
        strings.add("Oracle Corporation");
        strings.add("Oracle2");
        strings.add("oracle1");
        strings.add("Oracl");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameFor((String)"Oracle", strings.iterator()));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueNameFor((String)"Test", strings.iterator()));
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameForIgnoreCase((String)"Oracle", strings.iterator()));
        NameToolsTests.assertEquals((String)"oracle3", (String)NameTools.uniqueNameForIgnoreCase((String)"oracle", strings.iterator()));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueNameForIgnoreCase((String)"Test", strings.iterator()));
    }

    public void testUniqueNameForIterator2() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Oracle");
        strings.add("oracle");
        strings.add("Oracle2");
        strings.add("Oracle1");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameFor((String)"Oracle", strings.iterator()));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueNameFor((String)"Test", strings.iterator()));
        strings.add("Oracle Corporation");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameForIgnoreCase((String)"Oracle", strings.iterator()));
        NameToolsTests.assertEquals((String)"oracle3", (String)NameTools.uniqueNameForIgnoreCase((String)"oracle", strings.iterator()));
        NameToolsTests.assertEquals((String)"Test", (String)NameTools.uniqueNameForIgnoreCase((String)"Test", strings.iterator()));
    }

    public void testUniqueNameForIterator3() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Oracle");
        strings.add("Oracle");
        strings.add("Oracle2");
        strings.add("Oracle1");
        NameToolsTests.assertEquals((String)"Oracle3", (String)NameTools.uniqueNameFor((String)"Oracle", strings.iterator()));
    }

    public void testUniqueJavaNameForCollection() {
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("Oracle");
        strings.add("Oracle");
        strings.add("Oracle2");
        strings.add("Oracle1");
        NameToolsTests.assertEquals((String)"private2", (String)NameTools.uniqueJavaNameFor((String)"private", strings.iterator()));
        NameToolsTests.assertEquals((String)"class2", (String)NameTools.uniqueJavaNameFor((String)"class", strings.iterator()));
    }

    public void testBuildQualifiedDatabaseObjectName() {
        NameToolsTests.assertEquals((String)"catalog.schema.name", (String)NameTools.buildQualifiedDatabaseObjectName((String)"catalog", (String)"schema", (String)"name"));
        NameToolsTests.assertEquals((String)"catalog..name", (String)NameTools.buildQualifiedDatabaseObjectName((String)"catalog", null, (String)"name"));
        NameToolsTests.assertEquals((String)"schema.name", (String)NameTools.buildQualifiedDatabaseObjectName(null, (String)"schema", (String)"name"));
        NameToolsTests.assertEquals((String)"name", (String)NameTools.buildQualifiedDatabaseObjectName(null, null, (String)"name"));
    }

    public void testJavaReservedWords() {
        NameToolsTests.assertTrue((boolean)CollectionTools.contains((Iterator)NameTools.javaReservedWords(), (Object)"class"));
        NameToolsTests.assertFalse((boolean)CollectionTools.contains((Iterator)NameTools.javaReservedWords(), (Object)"Class"));
        NameToolsTests.assertTrue((boolean)CollectionTools.contains((Iterator)NameTools.javaReservedWords(), (Object)"private"));
    }

    public void testconvertToJavaIdentifierString() {
        NameToolsTests.assertEquals((String)"foo", (String)NameTools.convertToJavaIdentifier((String)"foo"));
        NameToolsTests.assertEquals((String)"foo1", (String)NameTools.convertToJavaIdentifier((String)"foo1"));
        NameToolsTests.assertEquals((String)"Private", (String)NameTools.convertToJavaIdentifier((String)"private"));
        NameToolsTests.assertEquals((String)"_foo", (String)NameTools.convertToJavaIdentifier((String)"1foo"));
        NameToolsTests.assertEquals((String)"foo_", (String)NameTools.convertToJavaIdentifier((String)"foo%"));
        NameToolsTests.assertEquals((String)"foo__bar__", (String)NameTools.convertToJavaIdentifier((String)"foo  bar  "));
    }

    public void testconvertToJavaIdentifierStringChar() {
        boolean exCaught;
        block5: {
            String s;
            block4: {
                NameToolsTests.assertEquals((String)"foo", (String)NameTools.convertToJavaIdentifier((String)"foo", (char)'$'));
                NameToolsTests.assertEquals((String)"foo1", (String)NameTools.convertToJavaIdentifier((String)"foo1", (char)'$'));
                NameToolsTests.assertEquals((String)"Private", (String)NameTools.convertToJavaIdentifier((String)"private", (char)'$'));
                NameToolsTests.assertEquals((String)"$foo", (String)NameTools.convertToJavaIdentifier((String)"1foo", (char)'$'));
                NameToolsTests.assertEquals((String)"foo$", (String)NameTools.convertToJavaIdentifier((String)"foo%", (char)'$'));
                NameToolsTests.assertEquals((String)"foo$$bar$$", (String)NameTools.convertToJavaIdentifier((String)"foo  bar  ", (char)'$'));
                exCaught = false;
                try {
                    s = NameTools.convertToJavaIdentifier((String)"1foo", (char)'7');
                    NameToolsTests.fail((String)("invalid string: \"" + s + "\""));
                }
                catch (IllegalArgumentException ex) {
                    if (ex.getMessage().indexOf(55) == -1) break block4;
                    exCaught = true;
                }
            }
            NameToolsTests.assertTrue((boolean)exCaught);
            exCaught = false;
            try {
                s = NameTools.convertToJavaIdentifier((String)"foo%", (char)'^');
                NameToolsTests.fail((String)("invalid string: \"" + s + "\""));
            }
            catch (IllegalArgumentException ex) {
                if (ex.getMessage().indexOf(94) == -1) break block5;
                exCaught = true;
            }
        }
        NameToolsTests.assertTrue((boolean)exCaught);
    }
}

