/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.apps.admin.core.dump;

import java.io.File;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.TabularDataSupport;
import org.eclipse.virgo.apps.admin.core.dump.DumpPathLocator;
import org.osgi.framework.InvalidSyntaxException;

final class StandardDumpPathLocator
implements DumpPathLocator {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String CONFIG_PROPERTY = "dump.root.directory";
    private static final String MEDIC_MBEAN_QUERY = "org.eclipse.virgo.kernel:type=Configuration,name=org.eclipse.virgo.medic";
    private String dumpConfigValue;

    public StandardDumpPathLocator() throws InvalidSyntaxException {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            Object attribute = mBeanServer.getAttribute(new ObjectName(MEDIC_MBEAN_QUERY), "Properties");
            TabularDataSupport table = (TabularDataSupport)attribute;
            CompositeDataSupport composite = (CompositeDataSupport)table.get(new Object[]{CONFIG_PROPERTY});
            this.dumpConfigValue = composite.get("value").toString();
        }
        catch (Exception exception) {}
    }

    @Override
    public File getDumpDirectory() {
        File dumpDir;
        String path = this.dumpConfigValue;
        if (path != null && (dumpDir = new File(path)).exists() && dumpDir.isDirectory()) {
            return dumpDir;
        }
        return null;
    }

    @Override
    public File getDumpFolder(String folderName) {
        String path = String.format("%s%s%s", this.dumpConfigValue, FILE_SEPARATOR, folderName);
        File dumpDir = new File(path);
        if (dumpDir.exists() && dumpDir.isDirectory()) {
            return dumpDir;
        }
        return null;
    }

    @Override
    public File getDumpEntryFile(String folderName, String fileName) {
        String path = String.format("%s%s%s%s%s", this.dumpConfigValue, FILE_SEPARATOR, folderName, FILE_SEPARATOR, fileName);
        File dumpEntry = new File(path);
        if (dumpEntry.exists() && dumpEntry.isFile()) {
            return dumpEntry;
        }
        return null;
    }
}

